/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.parser;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.util.jar.Attributes;

public class StandAloneParser {
    private static final String BAD_JAR = "Jar file not correctly set up";
    private static final String EXPECTED_ARG = "Expected argument to option";
    private static final String NO_PARSER = "Parser not found in jar file";
    private static String rascalPath = null;
    private static String startSymbol = null;
    private static String input = null;

    public static void main(String[] args) throws Throwable {
        URL resource = StandAloneParser.class.getResource("StandAloneParser.class");
        if (resource.getProtocol().equals("jar")) {
            URLConnection conn = resource.openConnection();
            if (conn instanceof JarURLConnection) {
                Attributes mainAttributes = ((JarURLConnection)conn).getMainAttributes();
                String clsName = mainAttributes.getValue("X-Rascal-Saved-Class");
                if (clsName == null) {
                    StandAloneParser.fatal(BAD_JAR, "No saved parser class");
                }
                StandAloneParser.parseOptions(args);
                String classPath = System.getenv("CLASSPATH");
                String[] split = classPath != null ? classPath.split(System.getProperty("path.separator")) : new String[]{};
                URL[] urls = new URL[split.length + 1 + (rascalPath != null ? 1 : 0)];
                int i = 0;
                if (rascalPath != null) {
                    urls[i++] = new URL("file", null, rascalPath);
                }
                for (String path : split) {
                    urls[i++] = new URL("file", null, path);
                }
                urls[i++] = ((JarURLConnection)conn).getJarFileURL();
                try (URLClassLoader loader = new URLClassLoader(urls, null);){
                    Class<?> clazz = loader.loadClass(clsName);
                    if (startSymbol == null) {
                        for (Class<?> f : clazz.getDeclaredClasses()) {
                            if (!f.getSimpleName().startsWith("start__")) continue;
                            startSymbol = f.getSimpleName();
                            System.err.println("Using start symbol " + startSymbol);
                            break;
                        }
                    }
                    if (startSymbol == null) {
                        StandAloneParser.fatal("Start symbol required", "--start STARTSYMBOL");
                    }
                    Class<?> INodeFlattener2 = loader.loadClass("org.rascalmpl.parser.gtd.result.out.INodeFlattener");
                    Class<?> INodeConstructorFactory2 = loader.loadClass("org.rascalmpl.parser.gtd.result.out.INodeConstructorFactory");
                    Class<?> DefaultNodeFlattener2 = loader.loadClass("org.rascalmpl.parser.gtd.result.out.DefaultNodeFlattener");
                    Class<?> UPTRNodeFactory2 = loader.loadClass("org.rascalmpl.parser.uptr.UPTRNodeFactory");
                    Class<?> ParseError2 = loader.loadClass("org.rascalmpl.parser.gtd.exception.ParseError");
                    Class<?> UndeclaredNonTerminalException2 = loader.loadClass("org.rascalmpl.parser.gtd.exception.UndeclaredNonTerminalException");
                    Method method = clazz.getMethod("parse", String.class, URI.class, char[].class, INodeFlattener2, INodeConstructorFactory2);
                    URI inputURI = input != null ? new URI("file", input, null) : new URI("stdin", "//", null);
                    try {
                        Object invoke = method.invoke(clazz.newInstance(), startSymbol, inputURI, StandAloneParser.getInput(), DefaultNodeFlattener2.newInstance(), UPTRNodeFactory2.newInstance());
                        System.out.println(invoke);
                    }
                    catch (InvocationTargetException e) {
                        Throwable cause = e.getCause();
                        if (ParseError2.isInstance(cause)) {
                            StandAloneParser.fatal(cause.toString(), null);
                        } else if (UndeclaredNonTerminalException2.isInstance(cause)) {
                            StandAloneParser.fatal(cause.getMessage(), "(perhaps start symbol doesn't exist?)");
                        }
                        throw e.getCause();
                    }
                }
                catch (ClassNotFoundException | NoSuchMethodException e) {
                    StandAloneParser.fatal(NO_PARSER, e.getMessage());
                }
            } else {
                StandAloneParser.fatal(BAD_JAR, "Not running from a JAR file");
            }
        } else {
            StandAloneParser.fatal(BAD_JAR, "Not running from a JAR file");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static char[] getInput() {
        block9: {
            char[] cArray;
            block8: {
                InputStream inputStream = null;
                try {
                    int n;
                    inputStream = input != null ? new FileInputStream(input) : System.in;
                    StringBuilder builder = new StringBuilder();
                    char[] buffer = new char[8192];
                    InputStreamReader reader = new InputStreamReader(inputStream);
                    while ((n = reader.read(buffer)) != -1) {
                        builder.append(buffer, 0, n);
                    }
                    cArray = builder.toString().toCharArray();
                    if (inputStream == null || inputStream == System.in) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (inputStream != null && inputStream != System.in) {
                            inputStream.close();
                        }
                        throw throwable;
                    }
                    catch (FileNotFoundException e) {
                        StandAloneParser.fatal("Input file not found", input);
                        break block9;
                    }
                    catch (IOException e) {
                        StandAloneParser.fatal("I/O error reading input file", e.getMessage());
                    }
                }
                inputStream.close();
            }
            return cArray;
        }
        return null;
    }

    private static void parseOptions(String[] args) {
        int i = 0;
        block13: while (i < args.length) {
            switch (args[i]) {
                case "-r": 
                case "--rascal": {
                    if (++i < args.length) {
                        rascalPath = args[i++];
                        continue block13;
                    }
                    StandAloneParser.fatal(EXPECTED_ARG, "rascal path");
                    continue block13;
                }
                case "-s": 
                case "--start": {
                    if (++i < args.length) {
                        startSymbol = args[i++];
                        continue block13;
                    }
                    StandAloneParser.fatal(EXPECTED_ARG, "start symbol");
                    continue block13;
                }
                case "-h": 
                case "--help": {
                    System.err.println("usage: java -jar parserJarFile [options] inputFile");
                    System.err.println("options:");
                    System.err.println("    -r, --rascal PATH       give path to Rascal installation (either jar or dir)");
                    System.err.println("    -s, --start NAME        name of start symbol");
                    System.err.println("    -h, --help              print help");
                    System.exit(0);
                    continue block13;
                }
            }
            if (input != null) {
                StandAloneParser.fatal("name of input file already given", args[i]);
                continue;
            }
            input = args[i++];
        }
    }

    private static void fatal(String msg1, String msg2) {
        if (msg2 == null) {
            System.err.println(msg1);
        } else {
            System.err.println(msg1 + ": " + msg2);
        }
        System.exit(1);
    }
}

