/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.repl.http;

import com.google.gson.stream.JsonWriter;
import fi.iki.elonen.NanoHTTPD;
import io.usethesource.vallang.IBool;
import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IMap;
import io.usethesource.vallang.IMapWriter;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IString;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IValueFactory;
import io.usethesource.vallang.IWithKeywordParameters;
import io.usethesource.vallang.exceptions.FactTypeUseException;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import io.usethesource.vallang.type.TypeStore;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.function.Function;
import org.rascalmpl.library.lang.json.internal.JsonValueWriter;
import org.rascalmpl.uri.URIResolverRegistry;
import org.rascalmpl.values.ValueFactoryFactory;
import org.rascalmpl.values.functions.IFunction;

public class REPLContentServer
extends NanoHTTPD {
    private static final IValueFactory vf = ValueFactoryFactory.getValueFactory();
    private Function<IValue, IValue> callback;
    private long lastServedAt = 0L;
    private static final Map<IConstructor, NanoHTTPD.Response.Status> statusValues = new HashMap<IConstructor, NanoHTTPD.Response.Status>();
    public static final Type requestType;
    private static final Type get;
    private static final Type head;
    private static final Type delete;

    public REPLContentServer(int port, Function<IValue, IValue> callback) {
        super(port);
        this.callback = callback;
        this.lastServedAt = System.currentTimeMillis();
    }

    public void updateCallback(Function<IValue, IValue> callback) {
        this.callback = callback;
        this.lastServedAt = System.currentTimeMillis();
    }

    public long getLastServedAt() {
        return this.lastServedAt;
    }

    @Override
    public NanoHTTPD.Response serve(String uri, NanoHTTPD.Method method, Map<String, String> headers, Map<String, String> parms, Map<String, String> files) {
        try {
            this.lastServedAt = System.currentTimeMillis();
            IConstructor request = this.makeRequest(uri, method, headers, parms, files);
            IValue rascalResponse = this.callback.apply(request);
            return REPLContentServer.translateResponse(method, rascalResponse);
        }
        catch (CancellationException e) {
            this.stop();
            return REPLContentServer.newFixedLengthResponse(NanoHTTPD.Response.Status.INTERNAL_ERROR, "text/html", "Shutting down!");
        }
        catch (Throwable t2) {
            return this.handleGeneralThrowable(t2);
        }
    }

    private NanoHTTPD.Response handleGeneralThrowable(Throwable e) {
        StringWriter str = new StringWriter();
        PrintWriter print = new PrintWriter(str);
        print.append("Exception while serving content:</br>");
        print.append("<pre>");
        e.printStackTrace(print);
        print.append("</pre>");
        print.flush();
        return REPLContentServer.newFixedLengthResponse(NanoHTTPD.Response.Status.NOT_FOUND, "text/html", str.toString());
    }

    private IConstructor makeRequest(String path, NanoHTTPD.Method method, Map<String, String> headers, Map<String, String> parms, Map<String, String> files) throws FactTypeUseException, IOException {
        HashMap<String, IValue> kws = new HashMap<String, IValue>();
        kws.put("parameters", this.makeMap(parms));
        kws.put("uploads", this.makeMap(files));
        kws.put("headers", this.makeMap(headers));
        switch (method) {
            case HEAD: {
                return vf.constructor(head, new IValue[]{vf.string(path)}, kws);
            }
            case DELETE: {
                return vf.constructor(delete, new IValue[]{vf.string(path)}, kws);
            }
            case GET: {
                return vf.constructor(get, new IValue[]{vf.string(path)}, kws);
            }
        }
        throw new IOException("Unhandled request " + method);
    }

    public static NanoHTTPD.Response translateResponse(NanoHTTPD.Method method, IValue value) throws IOException {
        IConstructor cons = (IConstructor)value;
        switch (cons.getName()) {
            case "fileResponse": {
                return REPLContentServer.translateFileResponse(method, cons);
            }
            case "jsonResponse": {
                return REPLContentServer.translateJsonResponse(method, cons);
            }
            case "response": {
                return REPLContentServer.translateTextResponse(method, cons);
            }
        }
        throw new IOException("Unknown response kind: " + value);
    }

    private static NanoHTTPD.Response translateJsonResponse(NanoHTTPD.Method method, IConstructor cons) {
        IMap header = (IMap)cons.get("header");
        IValue data = cons.get("val");
        NanoHTTPD.Response.Status status = REPLContentServer.translateStatus((IConstructor)cons.get("status"));
        IWithKeywordParameters<? extends IConstructor> kws = cons.asWithKeywordParameters();
        IValue dtf = kws.getParameter("dateTimeFormat");
        IValue dai = kws.getParameter("dateTimeAsInt");
        IValue formatters = kws.getParameter("formatter");
        IValue ecn = kws.getParameter("explicitConstructorNames");
        IValue edt = kws.getParameter("explicitDataTypes");
        JsonValueWriter writer = new JsonValueWriter().setCalendarFormat(dtf != null ? ((IString)dtf).getValue() : "yyyy-MM-dd'T'HH:mm:ss'Z'").setFormatters((IFunction)formatters).setDatesAsInt(dai != null ? ((IBool)dai).getValue() : true).setExplicitConstructorNames(ecn != null ? ((IBool)ecn).getValue() : false).setExplicitDataTypes(edt != null ? ((IBool)edt).getValue() : false);
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            JsonWriter out = new JsonWriter(new OutputStreamWriter((OutputStream)baos, Charset.forName("UTF8")));
            writer.write(out, data);
            out.flush();
            out.close();
            NanoHTTPD.Response response = REPLContentServer.newFixedLengthResponse(status, "application/json", new ByteArrayInputStream(baos.toByteArray()), baos.size());
            REPLContentServer.addHeaders(response, header);
            return response;
        }
        catch (IOException e) {
            throw new RuntimeException("Could not create piped inputstream");
        }
    }

    private static NanoHTTPD.Response translateFileResponse(NanoHTTPD.Method method, IConstructor cons) {
        ISourceLocation l = (ISourceLocation)cons.get("file");
        IString mimeType = (IString)cons.get("mimeType");
        IMap header = (IMap)cons.get("header");
        try {
            NanoHTTPD.Response response = REPLContentServer.newChunkedResponse(NanoHTTPD.Response.Status.OK, mimeType.getValue(), URIResolverRegistry.getInstance().getInputStream(l));
            REPLContentServer.addHeaders(response, header);
            return response;
        }
        catch (IOException e) {
            return REPLContentServer.newFixedLengthResponse(NanoHTTPD.Response.Status.NOT_FOUND, "text/plain", l + " not found.\n" + e);
        }
    }

    private static NanoHTTPD.Response translateTextResponse(NanoHTTPD.Method method, IConstructor cons) {
        IString mimeType = (IString)cons.get("mimeType");
        IMap header = (IMap)cons.get("header");
        IString data = (IString)cons.get("content");
        NanoHTTPD.Response.Status status = REPLContentServer.translateStatus((IConstructor)cons.get("status"));
        if (method != NanoHTTPD.Method.HEAD) {
            switch (status) {
                case BAD_REQUEST: 
                case UNAUTHORIZED: 
                case NOT_FOUND: 
                case FORBIDDEN: 
                case RANGE_NOT_SATISFIABLE: 
                case INTERNAL_ERROR: {
                    if (data.length() != 0) break;
                    data = vf.string(status.getDescription());
                }
            }
        }
        try {
            NanoHTTPD.ContentType fixedContentType = new NanoHTTPD.ContentType(mimeType.getValue()).tryUTF8();
            NanoHTTPD.Response response = REPLContentServer.newChunkedResponse(status, fixedContentType.getContentTypeHeader(), REPLContentServer.toInputStream(data, Charset.forName(fixedContentType.getEncoding())));
            REPLContentServer.addHeaders(response, header);
            return response;
        }
        catch (IOException e) {
            return REPLContentServer.newFixedLengthResponse(NanoHTTPD.Response.Status.INTERNAL_ERROR, "text/html", e.getMessage());
        }
    }

    private static InputStream toInputStream(IString data, Charset encoding) throws IOException {
        return new ByteArrayInputStream(data.getValue().getBytes(encoding));
    }

    private static void addHeaders(NanoHTTPD.Response response, IMap header) {
        response.addHeader("Cache-Control", "no-cache, no-store, must-revalidate");
        response.addHeader("Pragma", "no-cache");
        response.addHeader("Expires", "0");
        for (IValue key : header) {
            response.addHeader(((IString)key).getValue(), ((IString)header.get(key)).getValue());
        }
    }

    private static NanoHTTPD.Response.Status translateStatus(IConstructor cons) {
        return statusValues.get(cons);
    }

    private IMap makeMap(Map<String, String> headers) {
        IMapWriter writer = vf.mapWriter();
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            writer.put(vf.string(entry.getKey()), vf.string(entry.getValue()));
        }
        return (IMap)writer.done();
    }

    static {
        TypeFactory tf = TypeFactory.getInstance();
        TypeStore store = new TypeStore(new TypeStore[0]);
        Type statusType = tf.abstractDataType(store, "Status", new Type[0]);
        statusValues.put(vf.constructor(tf.constructor(store, statusType, "ok", new Type[0])), NanoHTTPD.Response.Status.OK);
        statusValues.put(vf.constructor(tf.constructor(store, statusType, "created", new Type[0])), NanoHTTPD.Response.Status.CREATED);
        statusValues.put(vf.constructor(tf.constructor(store, statusType, "accepted", new Type[0])), NanoHTTPD.Response.Status.ACCEPTED);
        statusValues.put(vf.constructor(tf.constructor(store, statusType, "noContent", new Type[0])), NanoHTTPD.Response.Status.NO_CONTENT);
        statusValues.put(vf.constructor(tf.constructor(store, statusType, "partialContent", new Type[0])), NanoHTTPD.Response.Status.PARTIAL_CONTENT);
        statusValues.put(vf.constructor(tf.constructor(store, statusType, "redirect", new Type[0])), NanoHTTPD.Response.Status.REDIRECT);
        statusValues.put(vf.constructor(tf.constructor(store, statusType, "notModified", new Type[0])), NanoHTTPD.Response.Status.NOT_MODIFIED);
        statusValues.put(vf.constructor(tf.constructor(store, statusType, "badRequest", new Type[0])), NanoHTTPD.Response.Status.BAD_REQUEST);
        statusValues.put(vf.constructor(tf.constructor(store, statusType, "unauthorized", new Type[0])), NanoHTTPD.Response.Status.UNAUTHORIZED);
        statusValues.put(vf.constructor(tf.constructor(store, statusType, "forbidden", new Type[0])), NanoHTTPD.Response.Status.FORBIDDEN);
        statusValues.put(vf.constructor(tf.constructor(store, statusType, "notFound", new Type[0])), NanoHTTPD.Response.Status.NOT_FOUND);
        statusValues.put(vf.constructor(tf.constructor(store, statusType, "rangeNotSatisfiable", new Type[0])), NanoHTTPD.Response.Status.RANGE_NOT_SATISFIABLE);
        statusValues.put(vf.constructor(tf.constructor(store, statusType, "internalError", new Type[0])), NanoHTTPD.Response.Status.INTERNAL_ERROR);
        requestType = tf.abstractDataType(store, "Request", new Type[0]);
        get = tf.constructor(store, requestType, "get", tf.stringType(), "path");
        delete = tf.constructor(store, requestType, "delete", tf.stringType(), "path");
        head = tf.constructor(store, requestType, "head", tf.stringType(), "path");
    }
}

