/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.shell;

import io.usethesource.vallang.IInteger;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.io.StandardTextWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import org.rascalmpl.debug.IRascalMonitor;
import org.rascalmpl.interpreter.Evaluator;
import org.rascalmpl.shell.ShellEvaluatorFactory;
import org.rascalmpl.shell.ShellRunner;

public class ModuleRunner
implements ShellRunner {
    private final Evaluator eval;

    public ModuleRunner(Reader input, PrintWriter stdout, PrintWriter stderr, IRascalMonitor monitor) {
        this.eval = ShellEvaluatorFactory.getDefaultEvaluator(input, stdout, stderr, monitor);
    }

    @Override
    public void run(String[] args) throws IOException {
        String module = args[0];
        if (module.endsWith(".rsc")) {
            module = module.substring(0, module.length() - 4);
        }
        module = module.replaceAll("/", "::");
        this.eval.doImport(this.eval.getMonitor(), module);
        String[] realArgs = new String[args.length - 1];
        System.arraycopy(args, 1, realArgs, 0, args.length - 1);
        IValue v = this.eval.main(this.eval.getMonitor(), module, "main", realArgs);
        if (v != null && !(v instanceof IInteger)) {
            new StandardTextWriter(true).write(v, this.eval.getOutPrinter());
            this.eval.getOutPrinter().flush();
        }
        System.exit(v instanceof IInteger ? ((IInteger)v).intValue() : 0);
    }
}

