/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.shell;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;
import org.jline.utils.OSUtils;
import org.rascalmpl.debug.IRascalMonitor;
import org.rascalmpl.repl.streams.StreamUtil;
import org.rascalmpl.shell.ModuleRunner;
import org.rascalmpl.shell.REPLRunner;
import org.rascalmpl.shell.ShellRunner;

public class RascalShell {
    public static void main(String[] args) throws IOException {
        ShellRunner runner;
        RascalShell.checkIfHelp(args);
        Terminal term = RascalShell.connectToTerminal();
        if (args.length > 0) {
            IRascalMonitor monitor = IRascalMonitor.buildConsoleMonitor(term);
            PrintWriter err = monitor instanceof Writer ? StreamUtil.generateErrorStream(term, (Writer)((Object)monitor)) : new PrintWriter(System.err, true);
            PrintWriter out = monitor instanceof PrintWriter ? (PrintWriter)((Object)monitor) : new PrintWriter(System.out, false);
            runner = new ModuleRunner(term.reader(), out, err, monitor);
        } else {
            runner = new REPLRunner(term);
        }
        runner.run(args);
    }

    public static Terminal connectToTerminal() throws IOException {
        RascalShell.setupJavaProcessForREPL();
        TerminalBuilder termBuilder = TerminalBuilder.builder();
        if (OSUtils.IS_WINDOWS) {
            termBuilder.encoding(StandardCharsets.UTF_8);
        }
        termBuilder.dumb(true);
        Terminal term = termBuilder.build();
        return term;
    }

    private static void checkIfHelp(String[] args) {
        if (args.length > 0 && "--help".equals(args[0])) {
            System.err.println("Usage: java -jar rascal-version.jar [Module]");
            System.err.println("\ttry also the --help options of the respective commands.");
            System.err.println("\tjava -jar rascal-version.jar [Module]: runs the main function of the module using the interpreter");
            System.exit(0);
        }
    }

    public static void setupJavaProcessForREPL() {
        System.setProperty("org.jline.terminal.exec.redirectPipeCreationMode", "native");
        System.setProperty("apple.awt.UIElement", "true");
    }
}

