/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.tutor.lang.rascal.tutor.repl;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IMapWriter;
import io.usethesource.vallang.IString;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import io.usethesource.vallang.type.TypeStore;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Map;
import org.rascalmpl.exceptions.RuntimeExceptionFactory;
import org.rascalmpl.library.util.PathConfig;
import org.rascalmpl.tutor.lang.rascal.tutor.repl.TutorCommandExecutor;
import org.rascalmpl.values.IRascalValueFactory;
import org.rascalmpl.values.functions.IFunction;

public class TutorCommandExecutorCreator {
    private final IRascalValueFactory vf;
    private final Type resetType;
    private final Type evalType;
    private final Type promptType;
    private final Type execConstructor;

    public TutorCommandExecutorCreator(IRascalValueFactory vf, TypeFactory tf, TypeStore ts) {
        this.vf = vf;
        this.promptType = tf.functionType(tf.stringType(), tf.tupleEmpty(), tf.tupleEmpty());
        this.resetType = tf.functionType(tf.voidType(), tf.tupleEmpty(), tf.tupleEmpty());
        this.evalType = tf.functionType(tf.mapType(tf.stringType(), tf.stringType()), tf.tupleType(tf.stringType()), tf.tupleEmpty());
        this.execConstructor = ts.lookupConstructor(ts.lookupAbstractDataType("CommandExecutor"), "executor").iterator().next();
    }

    public IConstructor createExecutor(IConstructor pathConfigCons) {
        try {
            PathConfig pcfg = new PathConfig(pathConfigCons);
            TutorCommandExecutor repl = new TutorCommandExecutor(pcfg);
            return this.vf.constructor(this.execConstructor, pathConfigCons, this.prompt(repl), this.reset(repl), this.eval(repl));
        }
        catch (IOException | URISyntaxException e) {
            throw RuntimeExceptionFactory.io(this.vf.string(e.getMessage()));
        }
    }

    IFunction reset(TutorCommandExecutor exec) {
        return this.vf.function(this.resetType, (args, kwargs) -> {
            exec.reset();
            return null;
        });
    }

    IFunction prompt(TutorCommandExecutor exec) {
        return this.vf.function(this.promptType, (args, kwargs) -> this.vf.string(exec.prompt()));
    }

    IFunction eval(TutorCommandExecutor exec) {
        return this.vf.function(this.evalType, (args, kwargs) -> {
            try {
                IString command = (IString)args[0];
                Map<String, String> output = exec.eval(command.getValue());
                IMapWriter mw = this.vf.mapWriter();
                for (String mimeType : output.keySet()) {
                    mw.put(this.vf.string(mimeType), this.vf.string(output.get(mimeType)));
                }
                return mw.done();
            }
            catch (IOException | InterruptedException e) {
                throw RuntimeExceptionFactory.io(this.vf.string(e.getMessage()));
            }
        });
    }
}

