---
title: "module resource::jdbc::JDBC"
id: JDBC
slug: /Library/resource/jdbc/JDBC
---

<div class="theme-doc-version-badge badge badge--secondary">rascal-Not specified</div>

#### Usage

```rascal
import resource::jdbc::JDBC;
```

#### Dependencies
```rascal
import Type;
import Map;
import String;
import List;
import Set;
```


## function registerJDBCClass {#resource-jdbc-JDBC-registerJDBCClass}

Given the name of a JDBC driver class, register it so it can be used in connections.

```rascal
void registerJDBCClass(str className)
```

## function mysqlConnectString {#resource-jdbc-JDBC-mysqlConnectString}

Generate a MySQL connect string.

```rascal
str mysqlConnectString(map[str,str] properties)
```

## data Connection {#resource-jdbc-JDBC-Connection}
JDBC Connection type

```rascal
data Connection  
     = jdbcConnection(int id)
     ;
```

## function createConnection {#resource-jdbc-JDBC-createConnection}

Create a connection based on the given connection string.

```rascal
Connection createConnection(str connectString)
```

## function closeConnection {#resource-jdbc-JDBC-closeConnection}

Close the given connection.

```rascal
void closeConnection(Connection connection)
```

## function getTableTypes {#resource-jdbc-JDBC-getTableTypes}

Get the types of tables available through this connection.

```rascal
list[str] getTableTypes(Connection connection)
```

## data JDBCType {#resource-jdbc-JDBC-JDBCType}
The JDBC types that could be assigned to various columns.

```rascal
data JDBCType  
     = array()
     | bigInt()
     | binary()
     | bit()
     | blob()
     | boolean()
     | char()
     | clob()
     | dataLink()
     | date()
     | decimal()
     | distinct()
     | double()
     | float()
     | integer()
     | javaObject()
     | longNVarChar()
     | longVarBinary()
     | longVarChar()
     | nChar()
     | nClob()
     | null()
     | numeric()
     | nVarChar()
     | other()
     | \real()
     | ref()
     | rowId()
     | smallInt()
     | sqlXML()
     | struct()
     | time()
     | timeStamp()
     | tinyInt()
     | varBinary()
     | varChar()
     ;
```

## data Column {#resource-jdbc-JDBC-Column}
A column in a table or view

```rascal
data Column  
     = column(str columnName, JDBCType columnType, bool nullable)
     ;
```

## data Table {#resource-jdbc-JDBC-Table}
A table in a database

```rascal
data Table  
     = table(str tableName, list[Column] columns)
     ;
```

## function getTableNames {#resource-jdbc-JDBC-getTableNames}

Get the tables visible through this connection (just names).

```rascal
set[str] getTableNames(Connection connection)
```

## function getTables {#resource-jdbc-JDBC-getTables}

Get the tables visible through this connection (with column info).

```rascal
set[Table] getTables(Connection connection)
```

## function getViews {#resource-jdbc-JDBC-getViews}

Get the tables visible through this connection (with column info).

```rascal
set[Table] getViews(Connection connection)
```

## function getTable {#resource-jdbc-JDBC-getTable}

Get the Table metadata for a named table.

```rascal
Table getTable(Connection connection, str tableName)
```

## function getView {#resource-jdbc-JDBC-getView}

Get the Table metadata for a named view.

```rascal
Table getView(Connection connection, str viewName)
```

## data RuntimeException {#resource-jdbc-JDBC-RuntimeException}
An exception thrown when we try to translate (or otherwise use) a JDBC type with no Rascal equivalent.

```rascal
data RuntimeException  
     = unsupportedJDBCType(JDBCType jdbcType)
     ;
```

## function jdbc2RascalType {#resource-jdbc-JDBC-jdbc2RascalType}

Get the Rascal type (as a symbol) for the given JDBC type

```rascal
Symbol jdbc2RascalType(array())

Symbol jdbc2RascalType(bigInt())

Symbol jdbc2RascalType(binary())

Symbol jdbc2RascalType(bit())

Symbol jdbc2RascalType(blob())

Symbol jdbc2RascalType(boolean())

Symbol jdbc2RascalType(char())

Symbol jdbc2RascalType(clob())

Symbol jdbc2RascalType(dataLink())

Symbol jdbc2RascalType(date())

Symbol jdbc2RascalType(decimal())

Symbol jdbc2RascalType(distinct())

Symbol jdbc2RascalType(double())

Symbol jdbc2RascalType(float())

Symbol jdbc2RascalType(integer())

Symbol jdbc2RascalType(javaObject())

Symbol jdbc2RascalType(longNVarChar())

Symbol jdbc2RascalType(longVarBinary())

Symbol jdbc2RascalType(longVarChar())

Symbol jdbc2RascalType(nChar())

Symbol jdbc2RascalType(nClob())

Symbol jdbc2RascalType(JDBCType::null())

Symbol jdbc2RascalType(numeric())

Symbol jdbc2RascalType(nVarChar())

Symbol jdbc2RascalType(other())

Symbol jdbc2RascalType(JDBCType::\real())

Symbol jdbc2RascalType(ref())

Symbol jdbc2RascalType(rowId())

Symbol jdbc2RascalType(smallInt())

Symbol jdbc2RascalType(sqlXML())

Symbol jdbc2RascalType(struct())

Symbol jdbc2RascalType(time())

Symbol jdbc2RascalType(timeStamp())

Symbol jdbc2RascalType(tinyInt())

Symbol jdbc2RascalType(varBinary())

Symbol jdbc2RascalType(varChar())
```

## data NULLable {#resource-jdbc-JDBC-NULLable}
Represents values which may or may not be null.

```rascal
data NULLable[&T]  
     = NULL()
     | notNULL(&T item)
     ;
```

## function loadTable {#resource-jdbc-JDBC-loadTable}

Load the contents of a table.

```rascal
set[&T] loadTable(type[&T] resType, Connection connection, str tableName)
```


This will turn the contents into a set, which by its nature will remove any
duplicates and discard any order. To maintain duplicates, or the order inherent in the table,
use loadTableOrdered instead.

## function loadTable {#resource-jdbc-JDBC-loadTable}

Load the contents of a table.

```rascal
set[value] loadTable(Connection connection, str tableName)
```


This will turn the contents into a set, which by its nature will remove any
duplicates and discard any order. To maintain duplicates, or the order inherent in the table, use 
loadTableOrdered instead. This versions uses no type information, meaning that it returns a set of values.

## function loadTableOrdered {#resource-jdbc-JDBC-loadTableOrdered}

Load the contents of a table.

```rascal
list[&T] loadTableOrdered(type[&T] resType, Connection connection, str tableName)
```


This maintains order and duplicates, but does not provide access to the
relational operations provided by loadTable.

## function loadTableOrdered {#resource-jdbc-JDBC-loadTableOrdered}

Load the contents of a table.

```rascal
list[value] loadTableOrdered(Connection connection, str tableName)
```


This maintains order and duplicates, but does not provide access to the
relational operations provided by loadTable. Also, with no type information, this version returns a list
of values.

## function allTableSchemas {#resource-jdbc-JDBC-allTableSchemas}

Prints all available schemas.

```rascal
str allTableSchemas(str moduleName, loc uri)
```


The JDBC tables schema should be given as: `jdbctables+connect-string`
where `connect-string` is the database-specific information needed to connect,
encoded as a URI, for instance: `jdbctables+mysql://localhost/bugs?user=my_user_name&password=my_password`

## function tableSchema {#resource-jdbc-JDBC-tableSchema}

```rascal
str tableSchema(str moduleName, loc uri)
```

## function format {#resource-jdbc-JDBC-format}

```rascal
str format(Symbol s)
```

