/*
 * Decompiled with CFR 0.152.
 */
package engineering.swat.watch.impl.jdk;

import engineering.swat.watch.WatchEvent;
import engineering.swat.watch.impl.EventHandlingWatch;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class JDKBaseWatch
implements EventHandlingWatch {
    private final Logger logger = LogManager.getLogger();
    protected final Path path;
    protected final Executor exec;
    protected final BiConsumer<EventHandlingWatch, WatchEvent> eventHandler;
    protected final Predicate<WatchEvent> eventFilter;
    protected final AtomicBoolean started = new AtomicBoolean();

    protected JDKBaseWatch(Path path, Executor exec, BiConsumer<EventHandlingWatch, WatchEvent> eventHandler, Predicate<WatchEvent> eventFilter) {
        this.path = path;
        this.exec = exec;
        this.eventHandler = eventHandler;
        this.eventFilter = eventFilter;
    }

    public void open() throws IOException {
        try {
            if (!this.startIfFirstTime()) {
                throw new IllegalStateException("Could not restart already-started watch for: " + String.valueOf(this.path));
            }
            this.logger.debug("Started watch for: {}", (Object)this.path);
        }
        catch (Exception e) {
            throw new IOException("Could not start watch for: " + String.valueOf(this.path), e);
        }
    }

    protected abstract void start() throws IOException;

    protected boolean startIfFirstTime() throws IOException {
        if (this.started.compareAndSet(false, true)) {
            this.start();
            return true;
        }
        return false;
    }

    protected WatchEvent translate(java.nio.file.WatchEvent<?> jdkEvent) {
        WatchEvent.Kind kind = this.translate(jdkEvent.kind());
        Path rootPath = this.path;
        Path relativePath = kind == WatchEvent.Kind.OVERFLOW ? null : (Path)jdkEvent.context();
        WatchEvent event = new WatchEvent(kind, rootPath, relativePath);
        this.logger.trace("Translated: {} to {}", (Object)jdkEvent, (Object)event);
        return event;
    }

    protected WatchEvent.Kind translate(WatchEvent.Kind<?> jdkKind) {
        if (jdkKind == StandardWatchEventKinds.ENTRY_CREATE) {
            return WatchEvent.Kind.CREATED;
        }
        if (jdkKind == StandardWatchEventKinds.ENTRY_MODIFY) {
            return WatchEvent.Kind.MODIFIED;
        }
        if (jdkKind == StandardWatchEventKinds.ENTRY_DELETE) {
            return WatchEvent.Kind.DELETED;
        }
        if (jdkKind == StandardWatchEventKinds.OVERFLOW) {
            return WatchEvent.Kind.OVERFLOW;
        }
        throw new IllegalArgumentException("Unexpected watch kind: " + String.valueOf(jdkKind));
    }

    @Override
    public Path getPath() {
        return this.path;
    }

    @Override
    public void handleEvent(WatchEvent e) {
        if (this.eventFilter.test(e)) {
            this.eventHandler.accept(this, e);
        }
    }
}

