/*
 * Decompiled with CFR 0.152.
 */
package io.usethesource.vallang.type;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IValueFactory;
import io.usethesource.vallang.type.DefaultSubtypeOfValue;
import io.usethesource.vallang.type.ITypeVisitor;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import io.usethesource.vallang.type.TypeStore;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoField;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.Nullable;

public class DateTimeType
extends DefaultSubtypeOfValue {
    public static DateTimeType getInstance() {
        return InstanceKeeper.sInstance;
    }

    @Override
    public TypeFactory.TypeReifier getTypeReifier(TypeFactory.TypeValues symbols) {
        return new Info(symbols);
    }

    private static long between(Random r, ChronoField chrono) {
        return DateTimeType.between(r, chrono.range().getMinimum(), chrono.range().getMaximum());
    }

    private static long between(Random r, long a, long b) {
        return r.longs(1L, a, b).sum();
    }

    @Override
    public IValue randomValue(Random random, TypeFactory.RandomTypesConfig typesConfig, IValueFactory vf, TypeStore store, Map<Type, Type> typeParameters, int maxDepth, int maxBreadth) {
        boolean partialDateTime = "true".equals(System.getProperty("vallang.random.partialDateTime"));
        boolean zoneOffsets = "true".equals(System.getProperty("vallang.random.zoneOffsets"));
        try {
            if (partialDateTime && random.nextDouble() > 0.8) {
                LocalTime result = LocalTime.ofSecondOfDay(DateTimeType.between(random, ChronoField.SECOND_OF_DAY));
                return vf.time(result.getHour(), result.getMinute(), result.getSecond(), (int)TimeUnit.MILLISECONDS.convert(result.getNano(), TimeUnit.NANOSECONDS));
            }
            if (partialDateTime && random.nextDouble() > 0.8) {
                LocalDate result = LocalDate.ofEpochDay(DateTimeType.between(random, LocalDate.of(0, 1, 1).toEpochDay(), LocalDate.of(9999, 1, 1).toEpochDay()));
                return vf.date(result.getYear(), result.getMonthValue(), result.getDayOfMonth());
            }
            Instant result = Instant.ofEpochSecond(DateTimeType.between(random, -TimeUnit.DAYS.toSeconds(700L), Instant.now().getEpochSecond() + TimeUnit.DAYS.toSeconds(700L)), 0L);
            if (!zoneOffsets || random.nextDouble() > 0.5) {
                return vf.datetime(result.toEpochMilli());
            }
            ZoneOffset off = ZoneOffset.ofTotalSeconds((int)DateTimeType.between(random, ChronoField.OFFSET_SECONDS));
            return vf.datetime(result.toEpochMilli(), (int)TimeUnit.HOURS.convert(off.getTotalSeconds(), TimeUnit.SECONDS), (int)TimeUnit.MINUTES.convert(off.getTotalSeconds(), TimeUnit.SECONDS) % 60);
        }
        catch (DateTimeException e) {
            return this.randomValue(random, typesConfig, vf, store, typeParameters, maxDepth, maxBreadth);
        }
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        return obj == DateTimeType.getInstance();
    }

    @Override
    public boolean isDateTime() {
        return true;
    }

    @Override
    public int hashCode() {
        return 63097;
    }

    @Override
    public String toString() {
        return "datetime";
    }

    @Override
    public <T, E extends Throwable> T accept(ITypeVisitor<T, E> visitor) throws E {
        return visitor.visitDateTime(this);
    }

    @Override
    protected boolean isSupertypeOf(Type type) {
        return type.isSubtypeOfDateTime(this);
    }

    @Override
    public Type lub(Type other) {
        return other.lubWithDateTime(this);
    }

    @Override
    public Type glb(Type type) {
        return type.glbWithDateTime(this);
    }

    @Override
    protected boolean isSubtypeOfDateTime(Type type) {
        return true;
    }

    @Override
    public boolean intersects(Type other) {
        return other.intersectsWithDateTime(this);
    }

    @Override
    protected boolean intersectsWithDateTime(Type type) {
        return true;
    }

    @Override
    protected Type lubWithDateTime(Type type) {
        return this;
    }

    @Override
    protected Type glbWithDateTime(Type type) {
        return this;
    }

    public static class Info
    extends TypeFactory.TypeReifier {
        public Info(TypeFactory.TypeValues symbols) {
            super(symbols);
        }

        @Override
        public Type getSymbolConstructorType() {
            return this.symbols().typeSymbolConstructor("datetime", new Object[0]);
        }

        @Override
        public Type fromSymbol(IConstructor symbol, TypeStore store, Function<IConstructor, Set<IConstructor>> grammar) {
            return DateTimeType.getInstance();
        }

        @Override
        public Type randomInstance(BiFunction<TypeStore, TypeFactory.RandomTypesConfig, Type> next, TypeStore store, TypeFactory.RandomTypesConfig rnd) {
            return this.tf().dateTimeType();
        }
    }

    private static final class InstanceKeeper {
        public static final DateTimeType sInstance = new DateTimeType();

        private InstanceKeeper() {
        }
    }
}

