/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4j.debug;

import org.eclipse.lsp4j.debug.Source;
import org.eclipse.lsp4j.debug.StackFramePresentationHint;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.jsonrpc.util.Preconditions;
import org.eclipse.lsp4j.jsonrpc.util.ToStringBuilder;
import org.eclipse.lsp4j.jsonrpc.validation.NonNull;

public class StackFrame {
    private int id;
    @NonNull
    private String name;
    private Source source;
    private int line;
    private int column;
    private Integer endLine;
    private Integer endColumn;
    private Boolean canRestart;
    private String instructionPointerReference;
    private Either<Integer, String> moduleId;
    private StackFramePresentationHint presentationHint;

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    public void setName(@NonNull String name) {
        this.name = Preconditions.checkNotNull(name, "name");
    }

    public Source getSource() {
        return this.source;
    }

    public void setSource(Source source) {
        this.source = source;
    }

    public int getLine() {
        return this.line;
    }

    public void setLine(int line) {
        this.line = line;
    }

    public int getColumn() {
        return this.column;
    }

    public void setColumn(int column) {
        this.column = column;
    }

    public Integer getEndLine() {
        return this.endLine;
    }

    public void setEndLine(Integer endLine) {
        this.endLine = endLine;
    }

    public Integer getEndColumn() {
        return this.endColumn;
    }

    public void setEndColumn(Integer endColumn) {
        this.endColumn = endColumn;
    }

    public Boolean getCanRestart() {
        return this.canRestart;
    }

    public void setCanRestart(Boolean canRestart) {
        this.canRestart = canRestart;
    }

    public String getInstructionPointerReference() {
        return this.instructionPointerReference;
    }

    public void setInstructionPointerReference(String instructionPointerReference) {
        this.instructionPointerReference = instructionPointerReference;
    }

    public Either<Integer, String> getModuleId() {
        return this.moduleId;
    }

    public void setModuleId(Either<Integer, String> moduleId) {
        this.moduleId = moduleId;
    }

    public void setModuleId(Integer moduleId) {
        if (moduleId == null) {
            this.moduleId = null;
            return;
        }
        this.moduleId = Either.forLeft(moduleId);
    }

    public void setModuleId(String moduleId) {
        if (moduleId == null) {
            this.moduleId = null;
            return;
        }
        this.moduleId = Either.forRight(moduleId);
    }

    public StackFramePresentationHint getPresentationHint() {
        return this.presentationHint;
    }

    public void setPresentationHint(StackFramePresentationHint presentationHint) {
        this.presentationHint = presentationHint;
    }

    public String toString() {
        ToStringBuilder b = new ToStringBuilder(this);
        b.add("id", this.id);
        b.add("name", this.name);
        b.add("source", this.source);
        b.add("line", this.line);
        b.add("column", this.column);
        b.add("endLine", this.endLine);
        b.add("endColumn", this.endColumn);
        b.add("canRestart", this.canRestart);
        b.add("instructionPointerReference", this.instructionPointerReference);
        b.add("moduleId", this.moduleId);
        b.add("presentationHint", (Object)this.presentationHint);
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StackFrame other = (StackFrame)obj;
        if (other.id != this.id) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.source == null ? other.source != null : !this.source.equals(other.source)) {
            return false;
        }
        if (other.line != this.line) {
            return false;
        }
        if (other.column != this.column) {
            return false;
        }
        if (this.endLine == null ? other.endLine != null : !this.endLine.equals(other.endLine)) {
            return false;
        }
        if (this.endColumn == null ? other.endColumn != null : !this.endColumn.equals(other.endColumn)) {
            return false;
        }
        if (this.canRestart == null ? other.canRestart != null : !this.canRestart.equals(other.canRestart)) {
            return false;
        }
        if (this.instructionPointerReference == null ? other.instructionPointerReference != null : !this.instructionPointerReference.equals(other.instructionPointerReference)) {
            return false;
        }
        if (this.moduleId == null ? other.moduleId != null : !this.moduleId.equals(other.moduleId)) {
            return false;
        }
        return !(this.presentationHint == null ? other.presentationHint != null : !this.presentationHint.equals((Object)other.presentationHint));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.id;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.source == null ? 0 : this.source.hashCode());
        result = 31 * result + this.line;
        result = 31 * result + this.column;
        result = 31 * result + (this.endLine == null ? 0 : this.endLine.hashCode());
        result = 31 * result + (this.endColumn == null ? 0 : this.endColumn.hashCode());
        result = 31 * result + (this.canRestart == null ? 0 : this.canRestart.hashCode());
        result = 31 * result + (this.instructionPointerReference == null ? 0 : this.instructionPointerReference.hashCode());
        result = 31 * result + (this.moduleId == null ? 0 : this.moduleId.hashCode());
        return 31 * result + (this.presentationHint == null ? 0 : this.presentationHint.hashCode());
    }
}

