/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.ast;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.ISourceLocation;
import java.util.List;
import org.rascalmpl.ast.AbstractAST;
import org.rascalmpl.ast.IASTVisitor;
import org.rascalmpl.ast.Name;

public abstract class Target
extends AbstractAST {
    public Target(ISourceLocation src, IConstructor node) {
        super(src);
    }

    public boolean hasName() {
        return false;
    }

    public Name getName() {
        throw new UnsupportedOperationException(this.src.toString());
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean isLabeled() {
        return false;
    }

    public static class Labeled
    extends Target {
        private final Name name;

        public Labeled(ISourceLocation src, IConstructor node, Name name) {
            super(src, node);
            this.name = name;
        }

        @Override
        public boolean isLabeled() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitTargetLabeled(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.name.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.name.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Labeled)) {
                return false;
            }
            Labeled tmp = (Labeled)o;
            return tmp.name.equals(this.name);
        }

        @Override
        public int hashCode() {
            return 397 + 191 * this.name.hashCode();
        }

        @Override
        public Name getName() {
            return this.name;
        }

        @Override
        public boolean hasName() {
            return true;
        }

        @Override
        public Object clone() {
            return Labeled.newInstance(this.getClass(), this.src, null, this.clone(this.name));
        }
    }

    public static class Empty
    extends Target {
        public Empty(ISourceLocation src, IConstructor node) {
            super(src, node);
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitTargetEmpty(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Empty)) {
                return false;
            }
            Empty tmp = (Empty)o;
            return true;
        }

        @Override
        public int hashCode() {
            return 787;
        }

        @Override
        public Object clone() {
            return Empty.newInstance(this.getClass(), this.src, null);
        }
    }
}

