/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.ideservices;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.usethesource.vallang.IBool;
import io.usethesource.vallang.ICollection;
import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IDateTime;
import io.usethesource.vallang.IExternalValue;
import io.usethesource.vallang.IInteger;
import io.usethesource.vallang.INode;
import io.usethesource.vallang.INumber;
import io.usethesource.vallang.IRational;
import io.usethesource.vallang.IReal;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IString;
import io.usethesource.vallang.ITuple;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IValueFactory;
import io.usethesource.vallang.io.binary.stream.IValueInputStream;
import io.usethesource.vallang.io.binary.stream.IValueOutputStream;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import io.usethesource.vallang.type.TypeStore;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.rascalmpl.debug.IRascalMonitor;
import org.rascalmpl.interpreter.NullRascalMonitor;
import org.rascalmpl.library.lang.json.internal.JsonValueReader;
import org.rascalmpl.library.lang.json.internal.JsonValueWriter;
import org.rascalmpl.util.base64.StreamingBase64;
import org.rascalmpl.values.IRascalValueFactory;

public class GsonUtils {
    private static final JsonValueWriter writer = new JsonValueWriter();
    private static final JsonValueReader reader = new JsonValueReader(IRascalValueFactory.getInstance(), new TypeStore(new TypeStore[0]), (IRascalMonitor)new NullRascalMonitor(), null);
    private static final TypeFactory tf = TypeFactory.getInstance();
    private static final List<TypeMapping> typeMappings;

    private static boolean needsWrapping(Type type, ComplexTypeMode complexTypeMode) {
        return complexTypeMode == ComplexTypeMode.ENCODE_AS_JSON_OBJECT && type == null || type.isSubtypeOf(tf.rationalType());
    }

    public static void configureGson(GsonBuilder builder) {
        GsonUtils.configureGson(builder, ComplexTypeMode.ENCODE_AS_JSON_OBJECT);
    }

    public static void configureGson(GsonBuilder builder, final ComplexTypeMode complexTypeMode) {
        builder.registerTypeAdapterFactory(new TypeAdapterFactory(){

            @Override
            public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
                Class rawType = type.getRawType();
                if (!IValue.class.isAssignableFrom(rawType)) {
                    return null;
                }
                return typeMappings.stream().filter(m4 -> m4.supports(rawType)).findFirst().map(m4 -> m4.createAdapter(complexTypeMode)).orElse(null);
            }
        });
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static String base64Encode(IValue value) {
        StringBuilder builder = new StringBuilder();
        try (OutputStream encoder = StreamingBase64.encode(builder);){
            String string;
            try (IValueOutputStream out = new IValueOutputStream(encoder, IRascalValueFactory.getInstance());){
                out.write(value);
                string = builder.toString();
            }
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static <T extends IValue> T base64Decode(String string, TypeStore ts) {
        try (InputStream decoder = StreamingBase64.decode(string);){
            IValue iValue;
            try (IValueInputStream in = new IValueInputStream(decoder, (IValueFactory)IRascalValueFactory.getInstance(), () -> ts);){
                iValue = in.read();
            }
            return (T)iValue;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        writer.setDatesAsInt(true);
        typeMappings = List.of(new TypeMapping(IBool.class, tf.boolType()), new TypeMapping(ICollection.class), new TypeMapping(IConstructor.class), new TypeMapping(IDateTime.class, tf.dateTimeType()), new TypeMapping(IExternalValue.class), new TypeMapping(IInteger.class, tf.integerType()), new TypeMapping(INode.class), new TypeMapping(IRational.class, tf.rationalType()), new TypeMapping(IReal.class, tf.realType()), new TypeMapping(ISourceLocation.class, tf.sourceLocationType()), new TypeMapping(IString.class, tf.stringType()), new TypeMapping(ITuple.class), new TypeMapping(INumber.class, tf.numberType()), new TypeMapping(IValue.class, tf.valueType()));
    }

    private static class TypeMapping {
        private final Class<?> clazz;
        private final @Nullable Type type;
        private final boolean isPrimitive;

        public TypeMapping(Class<?> clazz) {
            this(clazz, null);
        }

        public TypeMapping(Class<?> clazz, Type type) {
            this(clazz, type, type != null);
        }

        public TypeMapping(Class<?> clazz, Type type, boolean isPrimitive) {
            this.clazz = clazz;
            this.type = type;
            this.isPrimitive = isPrimitive;
        }

        public boolean supports(Class<?> incoming) {
            return this.clazz.isAssignableFrom(incoming);
        }

        public <T> TypeAdapter<T> createAdapter(final ComplexTypeMode complexTypeMode) {
            if (this.isPrimitive) {
                return new TypeAdapter<T>(){

                    @Override
                    public void write(JsonWriter out, T value) throws IOException {
                        boolean needsWrapping = GsonUtils.needsWrapping(type, complexTypeMode);
                        if (needsWrapping) {
                            out.beginObject();
                            out.name("val");
                        }
                        writer.write(out, (IValue)value);
                        if (needsWrapping) {
                            out.endObject();
                        }
                    }

                    @Override
                    public T read(JsonReader in) throws IOException {
                        boolean needsWrapping = GsonUtils.needsWrapping(type, complexTypeMode);
                        if (needsWrapping) {
                            in.beginObject();
                            in.nextName();
                        }
                        IValue ret = reader.read(in, type);
                        if (needsWrapping) {
                            in.endObject();
                        }
                        return ret;
                    }
                };
            }
            return new TypeAdapter<T>(){

                @Override
                public void write(JsonWriter out, T value) throws IOException {
                    switch (complexTypeMode) {
                        case ENCODE_AS_JSON_OBJECT: {
                            boolean needsWrapping = GsonUtils.needsWrapping(type, complexTypeMode);
                            if (needsWrapping) {
                                out.beginObject();
                                out.name("val");
                            }
                            writer.write(out, (IValue)value);
                            if (!needsWrapping) break;
                            out.endObject();
                            break;
                        }
                        case ENCODE_AS_BASE64_STRING: {
                            out.value(GsonUtils.base64Encode((IValue)value));
                            break;
                        }
                        case ENCODE_AS_STRING: {
                            out.value(((IValue)value).toString());
                            break;
                        }
                        case NOT_SUPPORTED: {
                            throw new IOException("Cannot write complex type " + value);
                        }
                        default: {
                            throw new IllegalArgumentException("Unsupported complex type mode " + complexTypeMode);
                        }
                    }
                }

                @Override
                public T read(JsonReader in) throws IOException {
                    throw new IOException("Cannot handle complex type");
                }
            };
        }
    }

    public static enum ComplexTypeMode {
        ENCODE_AS_JSON_OBJECT,
        ENCODE_AS_BASE64_STRING,
        ENCODE_AS_STRING,
        NOT_SUPPORTED;

    }
}

