/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.interpreter;

import io.usethesource.vallang.IBool;
import io.usethesource.vallang.IString;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.rascalmpl.interpreter.Evaluator;
import org.rascalmpl.interpreter.ITestResultListener;
import org.rascalmpl.interpreter.env.ModuleEnvironment;
import org.rascalmpl.interpreter.result.AbstractFunction;
import org.rascalmpl.test.infrastructure.QuickCheck;

public class TestEvaluator {
    private final Evaluator eval;
    private final ITestResultListener testResultListener;

    public TestEvaluator(Evaluator eval, ITestResultListener testResultListener) {
        this.eval = eval;
        this.testResultListener = testResultListener;
    }

    public boolean test(String moduleName) {
        ModuleEnvironment topModule = this.eval.getHeap().getModule(moduleName);
        if (topModule != null) {
            this.runTests(topModule, topModule.getTests());
            return true;
        }
        return false;
    }

    public void test() {
        ModuleEnvironment topModule = (ModuleEnvironment)this.eval.getCurrentEnvt().getRoot();
        this.runTests(topModule, topModule.getTests());
        ArrayList<String> imports = new ArrayList<String>(topModule.getImports());
        Collections.shuffle(imports);
        for (String i : imports) {
            ModuleEnvironment mod = topModule.getImport(i);
            if (mod == null) continue;
            this.runTests(mod, mod.getTests());
        }
    }

    public static int readIntTag(AbstractFunction test, String key, int defaultVal) {
        if (test.hasTag(key)) {
            int result = Integer.parseInt(((IString)test.getTag(key)).getValue());
            if (result < 1) {
                throw new IllegalArgumentException(key + " smaller than 1");
            }
            return result;
        }
        return defaultVal;
    }

    private void runTests(ModuleEnvironment env, List<AbstractFunction> tests) {
        if (tests.size() <= 0) {
            return;
        }
        this.eval.job("Testing " + env.getName(), tests.size(), jn -> {
            this.testResultListener.start(env.getName(), tests.size());
            ArrayList theTests = new ArrayList(tests);
            Collections.shuffle(theTests);
            QuickCheck qc = new QuickCheck(new Random(), this.eval.__getVf());
            for (AbstractFunction test : theTests) {
                this.eval.jobStep((String)jn, "Running " + env.getName() + "::" + test.getName(), 1);
                if (test.hasTag("ignore") || test.hasTag("Ignore") || test.hasTag("ignoreInterpreter") || test.hasTag("IgnoreInterpreter")) {
                    this.testResultListener.ignored(test.getName(), test.getAst().getLocation());
                    continue;
                }
                try {
                    int maxDepth = TestEvaluator.readIntTag(test, "maxDepth", 5);
                    int maxWidth = TestEvaluator.readIntTag(test, "maxWidth", 5);
                    int tries = TestEvaluator.readIntTag(test, "tries", 500);
                    TypeFactory.RandomTypesConfig typesConfig = TypeFactory.RandomTypesConfig.defaultConfig(new Random()).withoutRandomAbstractDatatypes();
                    String expected = null;
                    if (test.hasTag("expected")) {
                        expected = ((IString)test.getTag("expected")).getValue();
                    }
                    QuickCheck.TestResult result = qc.test(test.getEnv().getName() + "::" + test.getName(), test.getFormals(), expected, (actuals, args) -> {
                        try {
                            Object testResult = test.call((IValue)args);
                            if (testResult instanceof IBool && ((IBool)testResult).getValue()) {
                                return QuickCheck.SUCCESS;
                            }
                            return new QuickCheck.TestResult(false, null);
                        }
                        catch (Throwable e) {
                            return new QuickCheck.UnExpectedExceptionThrownResult(test.getEnv().getName() + "::" + test.getName(), (Type[])actuals, Map.of(), (IValue[])args, e);
                        }
                    }, env.getRoot().getStore(), tries, maxDepth, maxWidth, typesConfig);
                    this.eval.getOutPrinter().flush();
                    this.eval.getErrorPrinter().flush();
                    if (!result.succeeded()) {
                        StringWriter sw = new StringWriter();
                        PrintWriter out = new PrintWriter(sw);
                        result.writeMessage(out);
                        out.flush();
                        this.testResultListener.report(false, test.getName(), test.getAst().getLocation(), sw.getBuffer().toString(), result.thrownException());
                    } else {
                        this.testResultListener.report(true, test.getName(), test.getAst().getLocation(), "test succeeded", null);
                    }
                }
                catch (Throwable e) {
                    this.testResultListener.report(false, test.getName(), test.getAst().getLocation(), e.getMessage(), e);
                }
                this.eval.getOutPrinter().flush();
                this.eval.getErrorPrinter().flush();
            }
            this.testResultListener.done();
            return true;
        });
    }
}

