/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.interpreter.env;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.exceptions.FactTypeUseException;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeStore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.rascalmpl.ast.AbstractAST;
import org.rascalmpl.ast.KeywordFormal;
import org.rascalmpl.ast.Name;
import org.rascalmpl.ast.QualifiedName;
import org.rascalmpl.debug.IRascalFrame;
import org.rascalmpl.exceptions.ImplementationError;
import org.rascalmpl.interpreter.Evaluator;
import org.rascalmpl.interpreter.env.GlobalEnvironment;
import org.rascalmpl.interpreter.env.ModuleEnvironment;
import org.rascalmpl.interpreter.env.Pair;
import org.rascalmpl.interpreter.result.AbstractFunction;
import org.rascalmpl.interpreter.result.ConstructorFunction;
import org.rascalmpl.interpreter.result.OverloadedFunction;
import org.rascalmpl.interpreter.result.Result;
import org.rascalmpl.interpreter.result.ResultFactory;
import org.rascalmpl.interpreter.utils.Names;

public class Environment
implements IRascalFrame {
    protected Map<String, Result<IValue>> variableEnvironment;
    protected Map<String, LinkedHashSet<AbstractFunction>> functionEnvironment;
    protected Map<String, NameFlags> variableFlags;
    protected Map<String, NameFlags> functionFlags;
    protected Map<Type, Type> staticTypeParameters;
    protected Map<Type, Type> dynamicTypeParameters;
    protected final Environment parent;
    protected final Environment callerScope;
    protected ISourceLocation callerLocation;
    protected final ISourceLocation loc;
    protected final String name;
    private Environment myRoot;
    private boolean isFunctionFrame;

    public boolean equals(Object obj) {
        if (obj instanceof Environment) {
            Environment o = (Environment)obj;
            if (this.callerScope != o.callerScope || !this.loc.equals(o.loc) || !this.name.equals(o.name)) {
                return false;
            }
            if (!this.equalMaps(this.variableEnvironment, o.variableEnvironment)) {
                return false;
            }
            return this.equalMaps(this.functionEnvironment, o.functionEnvironment);
        }
        return false;
    }

    private <Key, Value> boolean equalMaps(Map<Key, Value> a, Map<Key, Value> b) {
        if (b == null && a == null) {
            return true;
        }
        if (b == null || a == null) {
            return false;
        }
        if (a.size() != b.size()) {
            return false;
        }
        for (Key k : a.keySet()) {
            if (b.containsKey(k) && a.get(k).equals(b.get(k))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int code = 1331 * this.name.hashCode();
        if (this.variableEnvironment != null) {
            code += this.variableEnvironment.hashCode() * 13;
        }
        if (this.functionEnvironment != null) {
            code += this.functionEnvironment.hashCode();
        }
        return code;
    }

    public Environment(ISourceLocation loc, String name) {
        this(null, null, null, loc, name);
    }

    public Environment(Environment parent, ISourceLocation loc, String name) {
        this(parent, null, null, loc, name);
    }

    public Environment(Environment parent, Environment callerScope, ISourceLocation callerLocation, ISourceLocation loc, String name) {
        this.parent = parent;
        this.loc = loc;
        this.name = name;
        this.callerScope = callerScope;
        this.callerLocation = callerLocation;
        if (parent == this) {
            throw new ImplementationError("internal error: cyclic environment");
        }
    }

    protected Environment(Environment old) {
        this.parent = old.parent;
        this.loc = old.loc;
        this.name = old.name;
        this.callerScope = old.callerScope;
        this.callerLocation = old.callerLocation;
        this.variableEnvironment = old.variableEnvironment;
        this.functionEnvironment = old.functionEnvironment;
        this.staticTypeParameters = old.staticTypeParameters;
        this.dynamicTypeParameters = old.dynamicTypeParameters;
        this.variableFlags = old.variableFlags;
        this.functionFlags = old.functionFlags;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public ISourceLocation getLocation() {
        return this.loc;
    }

    public boolean isRootScope() {
        if (!(this instanceof ModuleEnvironment)) {
            return false;
        }
        return this.parent == null;
    }

    public boolean isRootStackFrame() {
        return this.getCallerScope() == null;
    }

    public Result<IValue> getVariable(QualifiedName name) {
        if (name.getNames().size() > 1) {
            Environment current = this;
            while (!current.isRootScope()) {
                current = current.parent;
            }
            return current.getVariable(name);
        }
        String varName = Names.name(Names.lastName(name));
        return this.getFrameVariable(varName);
    }

    public Result<IValue> getFunctionForReturnType(Type returnType, String name) {
        LinkedList<AbstractFunction> candidates = new LinkedList<AbstractFunction>();
        this.getAllFunctions(name, candidates);
        if (candidates.isEmpty()) {
            return null;
        }
        LinkedList<AbstractFunction> filtered = new LinkedList<AbstractFunction>();
        for (AbstractFunction candidate : candidates) {
            if (!candidate.getReturnType().isAbstractData() || candidate.getReturnType() != returnType) continue;
            filtered.add(candidate);
        }
        if (filtered.isEmpty()) {
            return null;
        }
        return new OverloadedFunction(name, filtered);
    }

    public Result<IValue> getVariable(Name name) {
        return this.getFrameVariable(Names.name(name));
    }

    public void storeVariable(QualifiedName name, Result<IValue> result) {
        if (name.getNames().size() > 1) {
            if (!this.isRootScope()) {
                this.parent.storeVariable(name, result);
            }
        } else {
            String varName = Names.name(Names.lastName(name));
            this.storeVariable(varName, result);
        }
    }

    public Result<IValue> getSimpleVariable(QualifiedName name) {
        if (name.getNames().size() > 1) {
            Environment current = this;
            while (!current.isRootScope()) {
                current = current.parent;
            }
            return current.getSimpleVariable(name);
        }
        String varName = Names.name(Names.lastName(name));
        return this.getSimpleVariable(varName);
    }

    @Override
    public Result<IValue> getFrameVariable(String name) {
        Result<IValue> t2 = this.getSimpleVariable(name);
        if (t2 != null) {
            return t2;
        }
        LinkedList<AbstractFunction> funcs = new LinkedList<AbstractFunction>();
        this.getAllFunctions(name, funcs);
        if (funcs.isEmpty()) {
            return null;
        }
        if (funcs.size() == 1) {
            return (Result)funcs.get(0);
        }
        return new OverloadedFunction(name, funcs);
    }

    public Result<IValue> getSimpleVariable(Name name) {
        return this.getSimpleVariable(Names.name(name));
    }

    public Result<IValue> getSimpleVariable(String name) {
        Result<IValue> t2 = null;
        if (this.variableEnvironment != null) {
            t2 = this.variableEnvironment.get(name);
        }
        if (t2 != null) {
            return t2;
        }
        if (!this.isRootScope()) {
            return this.parent.getSimpleVariable(name);
        }
        return null;
    }

    public void unsetSimpleVariable(Name name) {
        this.unsetSimpleVariable(Names.name(name));
    }

    public void unsetSimpleVariable(String name) {
        if (this.variableEnvironment != null) {
            this.variableEnvironment.remove(name);
        }
    }

    public void getAllFunctions(String name, List<AbstractFunction> collection) {
        LinkedHashSet<AbstractFunction> locals;
        if (this.functionEnvironment != null && (locals = this.functionEnvironment.get(name)) != null) {
            collection.addAll(locals);
        }
        if (this.parent != null) {
            this.parent.getAllFunctions(name, collection);
        }
    }

    public ConstructorFunction getConstructorFunction(Type constructorType) {
        LinkedList<AbstractFunction> list = new LinkedList<AbstractFunction>();
        this.getAllFunctions(constructorType.getAbstractDataType(), constructorType.getName(), list);
        for (AbstractFunction candidate : list) {
            ConstructorFunction func;
            if (!(candidate instanceof ConstructorFunction) || !(func = (ConstructorFunction)candidate).getName().equals(constructorType.getName()) || !constructorType.isSubtypeOf(func.getConstructorType())) continue;
            return func;
        }
        return null;
    }

    public void getAllFunctions(Type returnType, String name, List<AbstractFunction> collection) {
        LinkedHashSet<AbstractFunction> locals;
        if (this.functionEnvironment != null && (locals = this.functionEnvironment.get(name)) != null) {
            for (AbstractFunction func : locals) {
                if (!func.getReturnType().comparable(returnType)) continue;
                collection.add(func);
            }
        }
        if (this.parent != null) {
            this.parent.getAllFunctions(returnType, name, collection);
        }
    }

    protected boolean isVariableFlagged(QualifiedName name, Predicate<NameFlags> tester) {
        if (name.getNames().size() > 1) {
            Environment current = this;
            while (!current.isRootScope()) {
                current = current.parent;
            }
            return current.isVariableFlagged(name, tester);
        }
        String simpleName = Names.name(Names.lastName(name));
        return this.isVariableFlagged(simpleName, tester);
    }

    protected boolean isFunctionFlagged(QualifiedName name, Predicate<NameFlags> tester) {
        if (name.getNames().size() > 1) {
            Environment current = this;
            while (!current.isRootScope()) {
                current = current.parent;
            }
            return current.isVariableFlagged(name, tester);
        }
        String simpleName = Names.name(Names.lastName(name));
        return this.isFunctionFlagged(simpleName, tester);
    }

    protected boolean isFunctionFlagged(String name, Predicate<NameFlags> tester) {
        Environment flaggingEnvironment = this.getFunctionFlagsEnvironment(name);
        if (flaggingEnvironment == null) {
            return false;
        }
        return flaggingEnvironment.functionFlags.containsKey(name) && tester.test(flaggingEnvironment.functionFlags.get(name));
    }

    public boolean isFunctionFinal(QualifiedName name) {
        return this.isFunctionFlagged(name, NameFlags::isFinal);
    }

    public boolean isFunctionPrivate(String name) {
        return this.isFunctionFlagged(name, NameFlags::isPrivate);
    }

    public boolean isFunctionPrivate(QualifiedName name) {
        return this.isFunctionFlagged(name, NameFlags::isPrivate);
    }

    public boolean isFunctionOverloadable(String name) {
        return this.isFunctionFlagged(name, NameFlags::isOverloadable);
    }

    public boolean isFunctionOverloadable(QualifiedName name) {
        return this.isFunctionFlagged(name, NameFlags::isOverloadable);
    }

    protected boolean isVariableFlagged(String name, Predicate<NameFlags> tester) {
        Environment flaggingEnvironment = this.getVariableFlagsEnvironment(name);
        if (flaggingEnvironment == null) {
            return false;
        }
        return flaggingEnvironment.variableFlags.containsKey(name) && tester.test(flaggingEnvironment.variableFlags.get(name));
    }

    public boolean isVariableFinal(QualifiedName name) {
        return this.isVariableFlagged(name, NameFlags::isFinal);
    }

    public boolean isVariablePrivate(String name) {
        return this.isVariableFlagged(name, NameFlags::isPrivate);
    }

    public boolean isVariablePrivate(QualifiedName name) {
        return this.isVariableFlagged(name, NameFlags::isPrivate);
    }

    public boolean isVariableOverloadable(String name) {
        return this.isVariableFlagged(name, NameFlags::isOverloadable);
    }

    public boolean isVariableOverloadable(QualifiedName name) {
        return this.isVariableFlagged(name, NameFlags::isOverloadable);
    }

    protected void flagVariableName(QualifiedName name, NameFlags flags) {
        if (name.getNames().size() > 1) {
            Environment current = this;
            while (!current.isRootScope()) {
                current = current.parent;
            }
            current.flagVariableName(name, flags);
        }
        String simpleName = Names.name(Names.lastName(name));
        this.flagVariableName(simpleName, flags);
    }

    protected void flagFunctionName(QualifiedName name, NameFlags flags) {
        if (name.getNames().size() > 1) {
            Environment current = this;
            while (!current.isRootScope()) {
                current = current.parent;
            }
            current.flagFunctionName(name, flags);
        }
        String simpleName = Names.name(Names.lastName(name));
        this.flagFunctionName(simpleName, flags);
    }

    protected void flagVariableName(String name, NameFlags flags) {
        if (this.variableFlags == null) {
            this.variableFlags = new HashMap<String, NameFlags>();
        }
        if (this.variableFlags.containsKey(name)) {
            this.variableFlags.put(name, this.variableFlags.get(name).merge(flags));
        } else {
            this.variableFlags.put(name, flags);
        }
    }

    protected void flagFunctionName(String name, NameFlags flags) {
        if (this.functionFlags == null) {
            this.functionFlags = new HashMap<String, NameFlags>();
        }
        if (this.functionFlags.containsKey(name)) {
            this.functionFlags.put(name, this.functionFlags.get(name).merge(flags));
        } else {
            this.functionFlags.put(name, flags);
        }
    }

    public void markVariableNameFinal(QualifiedName name) {
        this.flagVariableName(name, new NameFlags().makeFinal());
    }

    public void markFunctionNameFinal(String name) {
        this.flagFunctionName(name, new NameFlags().makeFinal());
    }

    public void markFunctionNameFinal(QualifiedName name) {
        this.flagFunctionName(name, new NameFlags().makeFinal());
    }

    public void markVariableNamePrivate(QualifiedName name) {
        this.flagVariableName(name, new NameFlags().makePrivate());
    }

    public void markVariableNamePrivate(String name) {
        this.flagVariableName(name, new NameFlags().makePrivate());
    }

    public void markFunctionNamePrivate(QualifiedName name) {
        this.flagVariableName(name, new NameFlags().makePrivate());
    }

    public void markFunctionNamePrivate(String name) {
        this.flagFunctionName(name, new NameFlags().makePrivate());
    }

    public void markVariableNameOverloadable(QualifiedName name) {
        this.flagVariableName(name, new NameFlags().makeOverloadable());
    }

    public void markVariableNameOverloadable(String name) {
        this.flagVariableName(name, new NameFlags().makeOverloadable());
    }

    public void markFunctionNameOverloadable(String name) {
        this.flagFunctionName(name, new NameFlags().makeOverloadable());
    }

    public void markFunctionNameOverloadable(QualifiedName name) {
        this.flagFunctionName(name, new NameFlags().makeOverloadable());
    }

    public void markNameOverloadable(String name) {
        this.flagFunctionName(name, new NameFlags().makeOverloadable());
    }

    public void storeStaticParameterType(Type par, Type type) {
        if (this.staticTypeParameters == null) {
            this.staticTypeParameters = new HashMap<Type, Type>();
        }
        this.staticTypeParameters.put(par, type);
    }

    public void storeDynamicParameterType(Type par, Type type) {
        if (this.dynamicTypeParameters == null) {
            this.dynamicTypeParameters = new HashMap<Type, Type>();
        }
        this.dynamicTypeParameters.put(par, type);
    }

    public Type getStaticParameterType(Type par) {
        if (this.staticTypeParameters != null) {
            return this.staticTypeParameters.get(par);
        }
        return null;
    }

    public Type getDynamicParameterType(Type par) {
        if (this.dynamicTypeParameters != null) {
            return this.dynamicTypeParameters.get(par);
        }
        return null;
    }

    protected Map<String, Result<IValue>> getVariableDefiningEnvironment(String name) {
        Result<IValue> r;
        if (this.variableEnvironment != null && (r = this.variableEnvironment.get(name)) != null) {
            return this.variableEnvironment;
        }
        return this.parent == null ? null : this.parent.getVariableDefiningEnvironment(name);
    }

    private Map<String, Result<IValue>> getLocalVariableDefiningEnvironment(String name) {
        Result<IValue> r;
        if (this.variableEnvironment != null && (r = this.variableEnvironment.get(name)) != null) {
            return this.variableEnvironment;
        }
        if (this.parent == null || this.parent.isRootScope()) {
            return this.variableEnvironment;
        }
        return this.parent.getLocalVariableDefiningEnvironment(name);
    }

    public void storeVariable(String name, Result<IValue> value) {
        Map<String, Result<IValue>> env = this.getVariableDefiningEnvironment(name);
        if (env == null) {
            if (this.variableEnvironment == null) {
                this.variableEnvironment = new HashMap<String, Result<IValue>>();
            }
            this.variableEnvironment.put(name, value);
            if (value != null) {
                value.setInferredType(true);
            }
        } else {
            env.put(name, value);
        }
    }

    public void declareAndStoreInferredInnerScopeVariable(String name, Result<IValue> value) {
        this.declareVariable(value.getStaticType(), name);
        value.setInferredType(true);
        this.variableEnvironment.put(name, value);
    }

    public void storeLocalVariable(String name, Result<IValue> value) {
        Map<String, Result<IValue>> env = this.getLocalVariableDefiningEnvironment(name);
        if (env == null) {
            throw new ImplementationError("storeVariable should always find a scope");
        }
        Result<IValue> old = env.get(name);
        if (old == null) {
            value.setInferredType(true);
        }
        env.put(name, value);
    }

    public void storeVariable(Name name, Result<IValue> r) {
        this.storeVariable(Names.name(name), r);
    }

    public void storeFunction(String name, AbstractFunction function) {
        LinkedHashSet<AbstractFunction> list = null;
        if (this.functionEnvironment != null) {
            list = this.functionEnvironment.get(name);
        }
        if (list == null || !this.isFunctionOverloadable(name)) {
            list = new LinkedHashSet(1);
            if (this.functionEnvironment == null) {
                this.functionEnvironment = new HashMap<String, LinkedHashSet<AbstractFunction>>();
            }
            this.functionEnvironment.put(name, list);
        }
        if (!list.contains(function)) {
            list.add(function);
            this.functionEnvironment.put(name, list);
            if (function.hasResourceScheme() && this.getRoot() instanceof ModuleEnvironment) {
                ((ModuleEnvironment)this.getRoot()).addResourceImporter(function);
            }
            if (function.hasResolverScheme()) {
                this.getRoot().getHeap().registerSourceResolver(function.getResolverScheme(), function);
            }
        }
    }

    public boolean declareVariable(Type type, Name name) {
        return this.declareVariable(type, Names.name(name));
    }

    public boolean declareVariable(Type type, String name) {
        if (this.variableEnvironment != null && this.variableEnvironment.get(name) != null) {
            return false;
        }
        if (this.variableEnvironment == null) {
            this.variableEnvironment = new HashMap<String, Result<IValue>>();
        }
        this.variableEnvironment.put(name, ResultFactory.nothing(type));
        return true;
    }

    public Map<Type, Type> getStaticTypeBindings() {
        Environment env = this;
        HashMap<Type, Type> result = null;
        while (env != null) {
            if (env.staticTypeParameters != null) {
                for (Type key : env.staticTypeParameters.keySet()) {
                    if (result == null) {
                        result = new HashMap<Type, Type>();
                    }
                    if (result.containsKey(key)) continue;
                    result.put(key, env.staticTypeParameters.get(key));
                }
            }
            env = env.parent;
        }
        if (result == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(result);
    }

    public Map<Type, Type> getDynamicTypeBindings() {
        Environment env = this;
        HashMap<Type, Type> result = null;
        while (env != null) {
            if (env.dynamicTypeParameters != null) {
                for (Type key : env.dynamicTypeParameters.keySet()) {
                    if (result == null) {
                        result = new HashMap<Type, Type>();
                    }
                    if (result.containsKey(key)) continue;
                    result.put(key, env.dynamicTypeParameters.get(key));
                }
            }
            env = env.parent;
        }
        if (result == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(result);
    }

    public void storeStaticTypeBindings(Map<Type, Type> bindings) {
        if (this.staticTypeParameters == null) {
            this.staticTypeParameters = new HashMap<Type, Type>();
        }
        this.staticTypeParameters.putAll(bindings);
    }

    public void storeDynamicTypeBindings(Map<Type, Type> bindings) {
        if (this.dynamicTypeParameters == null) {
            this.dynamicTypeParameters = new HashMap<Type, Type>();
        }
        this.dynamicTypeParameters.putAll(bindings);
    }

    public String toString() {
        StringBuffer res = new StringBuffer();
        if (this.functionEnvironment != null) {
            for (String name : this.functionEnvironment.keySet()) {
                res.append(name).append(": ").append(this.functionEnvironment.get(name)).append("\n");
            }
        }
        if (this.variableEnvironment != null) {
            for (String name : this.variableEnvironment.keySet()) {
                res.append(name).append(": ").append(this.variableEnvironment.get(name)).append("\n");
            }
        }
        return res.toString();
    }

    public ModuleEnvironment getImport(String moduleName) {
        return this.getRoot().getImport(moduleName);
    }

    public boolean isTreeConstructorName(QualifiedName name, Type signature) {
        return this.getRoot().isTreeConstructorName(name, signature);
    }

    public Environment getRoot() {
        if (this.isRootScope()) {
            return this;
        }
        if (this.myRoot == null) {
            this.myRoot = this.parent.getRoot();
        }
        return this.myRoot;
    }

    public GlobalEnvironment getHeap() {
        return this.getRoot().getHeap();
    }

    public Type getConstructor(Type sort, String cons, Type args) {
        return this.getRoot().getConstructor(sort, cons, args);
    }

    public Type getConstructor(String cons, Type args) {
        return this.getRoot().getConstructor(cons, args);
    }

    public Type getAbstractDataType(String sort) {
        return this.getRoot().getAbstractDataType(sort);
    }

    public Type lookupAbstractDataType(String name) {
        return this.getRoot().lookupAbstractDataType(name);
    }

    public Type lookupConcreteSyntaxType(String name) {
        return this.getRoot().lookupConcreteSyntaxType(name);
    }

    public Type lookupAlias(String name) {
        return this.getRoot().lookupAlias(name);
    }

    public Set<Type> lookupAlternatives(Type adt) {
        return this.getRoot().lookupAlternatives(adt);
    }

    public Type lookupConstructor(Type adt, String cons, Type args) {
        return this.getRoot().lookupConstructor(adt, cons, args);
    }

    public Set<Type> lookupConstructor(Type adt, String constructorName) throws FactTypeUseException {
        return this.getRoot().lookupConstructor(adt, constructorName);
    }

    public Set<Type> lookupConstructors(String constructorName) {
        return this.getRoot().lookupConstructors(constructorName);
    }

    public Type lookupFirstConstructor(String cons, Type args) {
        return this.getRoot().lookupFirstConstructor(cons, args);
    }

    public boolean declaresAnnotation(Type type, String label) {
        return this.getRoot().declaresAnnotation(type, label);
    }

    public Type getAnnotationType(Type type, String label) {
        return this.getRoot().getAnnotationType(type, label);
    }

    public void declareAnnotation(Type onType, String label, Type valueType) {
        this.getRoot().declareAnnotation(onType, label, valueType);
    }

    public Type abstractDataType(String name, Type ... parameters) {
        return this.getRoot().abstractDataType(name, parameters);
    }

    public void unsetConcreteSyntaxType(String name) {
        this.getRoot().unsetConcreteSyntaxType(name);
    }

    public Type concreteSyntaxType(String name, IConstructor symbol) {
        return this.getRoot().concreteSyntaxType(name, symbol);
    }

    public ConstructorFunction constructorFromTuple(AbstractAST ast, Evaluator eval, Type adt, String name, Type tupleType, List<KeywordFormal> initializers) {
        return this.getRoot().constructorFromTuple(ast, eval, adt, name, tupleType, initializers);
    }

    public Type aliasType(String name, Type aliased, Type ... parameters) {
        return this.getRoot().aliasType(name, aliased, parameters);
    }

    public TypeStore getStore() {
        return this.getRoot().getStore();
    }

    public Map<String, Result<IValue>> getVariables() {
        HashMap<String, Result<IValue>> vars = new HashMap<String, Result<IValue>>();
        if (this.parent != null) {
            vars.putAll(this.parent.getVariables());
        }
        if (this.variableEnvironment != null) {
            vars.putAll(this.variableEnvironment);
        }
        return vars;
    }

    public List<Pair<String, LinkedHashSet<AbstractFunction>>> getFunctions() {
        ArrayList<Pair<String, LinkedHashSet<AbstractFunction>>> functions = new ArrayList<Pair<String, LinkedHashSet<AbstractFunction>>>();
        if (this.parent != null) {
            functions.addAll(this.parent.getFunctions());
        }
        if (this.functionEnvironment != null) {
            for (Map.Entry<String, LinkedHashSet<AbstractFunction>> entry : this.functionEnvironment.entrySet()) {
                functions.add(new Pair<String, LinkedHashSet<AbstractFunction>>(entry.getKey(), entry.getValue()));
            }
        }
        return functions;
    }

    public void unsetAllFunctions(String name) {
        if (this.functionEnvironment != null) {
            this.functionEnvironment.remove(name);
        }
    }

    public Environment getParent() {
        return this.parent;
    }

    public Environment getCallerScope() {
        if (this.callerScope != null) {
            return this.callerScope;
        }
        if (this.parent != null) {
            return this.parent.getCallerScope();
        }
        return null;
    }

    @Override
    public ISourceLocation getCallerLocation() {
        if (this.callerLocation != null) {
            return this.callerLocation;
        }
        if (this.parent != null) {
            return this.parent.getCallerLocation();
        }
        return null;
    }

    @Override
    public Set<String> getImports() {
        return this.getRoot().getImports();
    }

    public void reset() {
        this.variableEnvironment = null;
        this.functionEnvironment = null;
        this.staticTypeParameters = null;
        this.functionFlags = null;
        this.variableFlags = null;
        this.myRoot = null;
    }

    protected void extendNameFlags(Environment other) {
        NameFlags flags;
        if (other.variableFlags != null) {
            if (this.variableFlags == null) {
                this.variableFlags = new HashMap<String, NameFlags>();
            }
            for (String name : other.variableFlags.keySet()) {
                flags = this.variableFlags.get(name);
                if (flags != null) {
                    this.variableFlags.put(name, flags.merge(other.variableFlags.get(name)));
                    continue;
                }
                this.variableFlags.put(name, other.variableFlags.get(name));
            }
        }
        if (other.functionFlags != null) {
            if (this.functionFlags == null) {
                this.functionFlags = new HashMap<String, NameFlags>();
            }
            for (String name : other.functionFlags.keySet()) {
                flags = this.functionFlags.get(name);
                if (flags != null) {
                    this.functionFlags.put(name, flags.merge(other.functionFlags.get(name)));
                    continue;
                }
                this.functionFlags.put(name, other.functionFlags.get(name));
            }
        }
    }

    public void extend(Environment other) {
        this.extendNameFlags(other);
        this.extendVariableEnv(other);
        this.extendFunctionEnv(other);
        this.extendTypeParams(other);
    }

    protected void extendTypeParams(Environment other) {
        if (other.staticTypeParameters != null) {
            if (this.staticTypeParameters == null) {
                this.staticTypeParameters = new HashMap<Type, Type>();
            }
            this.staticTypeParameters.putAll(other.staticTypeParameters);
        }
    }

    protected void extendFunctionEnv(Environment other) {
        if (other.functionEnvironment != null) {
            if (this.functionEnvironment == null) {
                this.functionEnvironment = new HashMap<String, LinkedHashSet<AbstractFunction>>();
            }
            for (String name : other.functionEnvironment.keySet()) {
                LinkedHashSet<AbstractFunction> otherFunctions = other.functionEnvironment.get(name);
                if (otherFunctions == null) continue;
                for (AbstractFunction function : otherFunctions) {
                    this.storeFunction(name, (AbstractFunction)function.cloneInto(this));
                }
            }
        }
    }

    protected void extendVariableEnv(Environment other) {
        if (other.variableEnvironment != null) {
            if (this.variableEnvironment == null) {
                this.variableEnvironment = new HashMap<String, Result<IValue>>();
            }
            this.variableEnvironment.putAll(other.variableEnvironment);
        }
    }

    protected Environment getVariableFlagsEnvironment(String name) {
        if (this.variableEnvironment != null && this.variableEnvironment.get(name) != null) {
            if (this.variableFlags != null && this.variableFlags.get(name) != null) {
                return this;
            }
            return null;
        }
        if (!this.isRootScope()) {
            return this.parent.getVariableFlagsEnvironment(name);
        }
        return null;
    }

    protected Environment getFunctionFlagsEnvironment(String name) {
        if (this.functionEnvironment != null && this.functionEnvironment.get(name) != null) {
            if (this.functionFlags != null && this.functionFlags.get(name) != null) {
                return this;
            }
            return null;
        }
        if (!this.isRootScope()) {
            return this.parent.getFunctionFlagsEnvironment(name);
        }
        return null;
    }

    public void declareConstructorKeywordParameter(Type onType, String label, Type valueType) {
        this.getRoot().declareConstructorKeywordParameter(onType, label, valueType);
    }

    public Set<ModuleEnvironment.GenericKeywordParameters> lookupGenericKeywordParameters(Type adt) {
        return this.getRoot().lookupGenericKeywordParameters(adt);
    }

    public void declareGenericKeywordParameters(Type adt, Type kwTypes, List<KeywordFormal> formals) {
        this.getRoot().declareGenericKeywordParameters(adt, kwTypes, formals);
    }

    public Map<String, Type> getKeywordParameterTypes(Type ontype) {
        return this.getRoot().getKeywordParameterTypes(ontype);
    }

    @Override
    public Set<String> getFrameVariables() {
        return this.getVariables().keySet();
    }

    public void markAsFunctionFrame() {
        this.isFunctionFrame = true;
    }

    public boolean isFunctionFrame() {
        return this.isFunctionFrame;
    }

    protected static class NameFlags {
        public static final int FINAL_NAME = 1;
        public static final int OVERLOADABLE_NAME = 2;
        public static final int PRIVATE_NAME = 4;
        private final int flags;

        public NameFlags() {
            this.flags = 0;
        }

        private NameFlags(int flags) {
            this.flags = flags;
        }

        public NameFlags merge(NameFlags other) {
            return new NameFlags(this.flags | other.flags);
        }

        public NameFlags makeFinal() {
            return new NameFlags(this.flags | 1);
        }

        public NameFlags makePrivate() {
            return new NameFlags(this.flags | 4);
        }

        public NameFlags makeOverloadable() {
            return new NameFlags(this.flags | 2);
        }

        boolean isFinal() {
            return (this.flags & 1) != 0;
        }

        boolean isPrivate() {
            return (this.flags & 4) != 0;
        }

        boolean isOverloadable() {
            return (this.flags & 2) != 0;
        }
    }
}

