/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.interpreter.env;

import io.usethesource.capsule.Map;
import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IMap;
import io.usethesource.vallang.IMapWriter;
import io.usethesource.vallang.ISetWriter;
import io.usethesource.vallang.ITuple;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IValueFactory;
import io.usethesource.vallang.exceptions.FactTypeUseException;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import io.usethesource.vallang.type.TypeStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.rascalmpl.ast.AbstractAST;
import org.rascalmpl.ast.KeywordFormal;
import org.rascalmpl.ast.Name;
import org.rascalmpl.ast.QualifiedName;
import org.rascalmpl.interpreter.Evaluator;
import org.rascalmpl.interpreter.env.Environment;
import org.rascalmpl.interpreter.env.GlobalEnvironment;
import org.rascalmpl.interpreter.result.AbstractFunction;
import org.rascalmpl.interpreter.result.ConstructorFunction;
import org.rascalmpl.interpreter.result.OverloadedFunction;
import org.rascalmpl.interpreter.result.Result;
import org.rascalmpl.interpreter.staticErrors.UndeclaredModule;
import org.rascalmpl.interpreter.utils.Names;
import org.rascalmpl.types.NonTerminalType;
import org.rascalmpl.types.RascalTypeFactory;
import org.rascalmpl.uri.URIUtil;
import org.rascalmpl.values.RascalValueFactory;
import org.rascalmpl.values.ValueFactoryFactory;

public class ModuleEnvironment
extends Environment {
    protected final GlobalEnvironment heap;
    protected Map<String, Optional<ModuleEnvironment>> importedModules;
    protected Set<String> extended;
    protected TypeStore typeStore;
    protected Set<IValue> productions;
    protected Map<Type, List<KeywordFormal>> generalKeywordParameters;
    protected Map<String, NonTerminalType> concreteSyntaxTypes;
    private boolean initialized;
    private boolean syntaxDefined;
    private boolean bootstrap;
    private String deprecated;
    protected Map<String, AbstractFunction> resourceImporters;
    protected Map<Type, Set<GenericKeywordParameters>> cachedGeneralKeywordParameters;
    protected Map<String, List<AbstractFunction>> cachedPublicFunctions;
    protected static final TypeFactory TF = TypeFactory.getInstance();
    public static final String SHELL_MODULE = "$";
    private Iterable<ModuleEnvironment> importedModulesResolved = () -> new Iterator<ModuleEnvironment>(){
        Iterator iterator;
        {
            this.iterator = ModuleEnvironment.this.importedModules.entrySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public ModuleEnvironment next() {
            Map.Entry entry = (Map.Entry)this.iterator.next();
            Optional<ModuleEnvironment> result = (Optional<ModuleEnvironment>)entry.getValue();
            if (result.isEmpty()) {
                result = Optional.ofNullable(ModuleEnvironment.this.heap.getModule((String)entry.getKey()));
                entry.setValue(result);
            }
            return result.orElse(null);
        }
    };

    public ModuleEnvironment(String name, GlobalEnvironment heap) {
        super(ValueFactoryFactory.getValueFactory().sourceLocation(URIUtil.assumeCorrect("main", "", "/" + name.replaceAll("::", "/").replaceAll("\\$", "_dollar_"))), name);
        this.heap = heap;
        this.importedModules = new HashMap<String, Optional<ModuleEnvironment>>();
        this.concreteSyntaxTypes = new HashMap<String, NonTerminalType>();
        this.productions = new HashSet<IValue>();
        this.generalKeywordParameters = new HashMap<Type, List<KeywordFormal>>();
        this.typeStore = new TypeStore(new TypeStore[0]);
        this.initialized = false;
        this.syntaxDefined = false;
        this.bootstrap = false;
        this.resourceImporters = new HashMap<String, AbstractFunction>();
        this.cachedGeneralKeywordParameters = null;
        this.cachedPublicFunctions = null;
    }

    protected ModuleEnvironment(ModuleEnvironment env) {
        super(env);
        this.heap = env.heap;
        this.importedModules = env.importedModules;
        this.concreteSyntaxTypes = env.concreteSyntaxTypes;
        this.productions = env.productions;
        this.typeStore = env.typeStore;
        this.initialized = env.initialized;
        this.syntaxDefined = env.syntaxDefined;
        this.bootstrap = env.bootstrap;
        this.resourceImporters = env.resourceImporters;
        this.cachedGeneralKeywordParameters = null;
        this.cachedPublicFunctions = null;
        this.deprecated = env.deprecated;
    }

    @Override
    public void reset() {
        super.reset();
        this.importedModules = new HashMap<String, Optional<ModuleEnvironment>>();
        this.concreteSyntaxTypes = new HashMap<String, NonTerminalType>();
        this.typeStore = new TypeStore(new TypeStore[0]);
        this.productions = new HashSet<IValue>();
        this.initialized = false;
        this.syntaxDefined = false;
        this.bootstrap = false;
        this.extended = new HashSet<String>();
        this.deprecated = null;
        this.generalKeywordParameters = new HashMap<Type, List<KeywordFormal>>();
        this.cachedGeneralKeywordParameters = null;
        this.cachedPublicFunctions = null;
    }

    public void clearLookupCaches() {
        this.importedModules.replaceAll((k, v) -> Optional.empty());
        this.cachedGeneralKeywordParameters = null;
        this.cachedPublicFunctions = null;
    }

    public void extend(ModuleEnvironment other) {
        this.extendNameFlags(other);
        if (other.importedModules != null) {
            if (this.importedModules == null) {
                this.importedModules = new HashMap<String, Optional<ModuleEnvironment>>();
            }
            this.importedModules.putAll(other.importedModules);
        }
        if (other.concreteSyntaxTypes != null) {
            if (this.concreteSyntaxTypes == null) {
                this.concreteSyntaxTypes = new HashMap<String, NonTerminalType>();
            }
            this.concreteSyntaxTypes.putAll(other.concreteSyntaxTypes);
        }
        if (other.typeStore != null) {
            if (this.typeStore == null) {
                this.typeStore = new TypeStore(new TypeStore[0]);
            }
            this.typeStore.extendStore(other.typeStore);
        }
        if (other.productions != null) {
            if (this.productions == null) {
                this.productions = new HashSet<IValue>();
            }
            this.productions.addAll(other.productions);
        }
        if (other.extended != null) {
            if (this.extended == null) {
                this.extended = new HashSet<String>();
            }
            this.extended.addAll(other.extended);
        }
        if (other.generalKeywordParameters != null) {
            if (this.generalKeywordParameters == null) {
                this.generalKeywordParameters = new HashMap<Type, List<KeywordFormal>>();
            }
            for (Map.Entry<Type, List<KeywordFormal>> e : other.generalKeywordParameters.entrySet()) {
                this.generalKeywordParameters.compute(e.getKey(), (k, current) -> {
                    if (current == null) {
                        return new ArrayList((Collection)e.getValue());
                    }
                    return this.mergeKeywords((List)e.getValue(), (List<KeywordFormal>)current);
                });
            }
        }
        this.extendTypeParams(other);
        this.extendVariableEnv(other);
        this.extendFunctionEnv(other);
        this.initialized &= other.initialized;
        this.syntaxDefined |= other.syntaxDefined;
        this.bootstrap |= other.bootstrap;
        this.addExtend(other.getName());
    }

    private List<KeywordFormal> mergeKeywords(List<KeywordFormal> a, List<KeywordFormal> b) {
        ArrayList<KeywordFormal> result = new ArrayList<KeywordFormal>(a.size() + b.size());
        result.addAll(a);
        for (KeywordFormal k : b) {
            if (this.keywordFormalExists(result, k)) continue;
            result.add(k);
        }
        return result;
    }

    @Override
    public GlobalEnvironment getHeap() {
        return this.heap;
    }

    public boolean isSyntaxDefined() {
        return this.syntaxDefined;
    }

    public void setSyntaxDefined(boolean val) {
        this.syntaxDefined = val;
    }

    public void declareProduction(IConstructor sd) {
        this.productions.add(sd);
    }

    public void clearProductions() {
        if (this.productions != null) {
            this.productions.clear();
        }
    }

    public boolean definesSyntax() {
        ModuleEnvironment env;
        if (!this.productions.isEmpty()) {
            return true;
        }
        for (String mod : this.getExtendsTransitive()) {
            env = this.heap.getModule(mod);
            if (env == null || env.productions.isEmpty()) continue;
            return true;
        }
        for (String mod : this.getImportsTransitive()) {
            env = this.heap.getModule(mod);
            if (env == null || env.productions.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public IMap getSyntaxDefinition() {
        LinkedList<Object> todo = new LinkedList<Object>();
        HashSet<String> done = new HashSet<String>();
        todo.add(this.getName());
        IValueFactory VF = ValueFactoryFactory.getValueFactory();
        IMapWriter result = VF.mapWriter();
        while (!todo.isEmpty()) {
            IValue def;
            Object impname2;
            Object extendWriter;
            ISetWriter importWriter;
            ModuleEnvironment env;
            String m4 = (String)todo.get(0);
            todo.remove(0);
            if (done.contains(m4)) continue;
            done.add(m4);
            ModuleEnvironment moduleEnvironment = env = m4.equals(this.getName()) ? this : this.heap.getModule(m4);
            if (env != null) {
                importWriter = VF.setWriter();
                for (String string : env.getImports()) {
                    if (!done.contains(string)) {
                        todo.add(string);
                    }
                    importWriter.insert(VF.string(string));
                }
                extendWriter = VF.setWriter();
                for (Object impname2 : env.getExtends()) {
                    if (!done.contains(impname2)) {
                        todo.add(impname2);
                    }
                    extendWriter.insert(VF.string((String)impname2));
                }
                ISetWriter iSetWriter = VF.setWriter();
                impname2 = env.productions.iterator();
                while (impname2.hasNext()) {
                    def = (IValue)impname2.next();
                    iSetWriter.insert(def);
                }
                ITuple t2 = VF.tuple(new IValue[]{importWriter.done(), extendWriter.done(), iSetWriter.done()});
                result.put(VF.string(m4), t2);
                continue;
            }
            if (!m4.equals(this.getName())) continue;
            importWriter = VF.setWriter();
            for (String string : this.importedModules.keySet()) {
                if (!done.contains(string)) {
                    todo.add(string);
                }
                importWriter.insert(VF.string(string));
            }
            extendWriter = VF.setWriter();
            for (Object impname2 : this.getExtends()) {
                if (!done.contains(impname2)) {
                    todo.add(impname2);
                }
                extendWriter.insert(VF.string((String)impname2));
            }
            ISetWriter iSetWriter = VF.setWriter();
            impname2 = this.productions.iterator();
            while (impname2.hasNext()) {
                def = impname2.next();
                iSetWriter.insert(def);
            }
            ITuple t2 = VF.tuple(new IValue[]{importWriter.done(), extendWriter.done(), iSetWriter.done()});
            result.put(VF.string(m4), t2);
        }
        return (IMap)result.done();
    }

    public boolean isModuleEnvironment() {
        return true;
    }

    public void addImport(String name, ModuleEnvironment env) {
        assert (this.heap.getModule(name).equals(env));
        this.importedModules.put(name, Optional.ofNullable(env));
        this.typeStore.importStore(env.typeStore);
        this.cachedGeneralKeywordParameters = null;
        this.cachedPublicFunctions = null;
    }

    void removeModule(String name) {
        this.importedModules.computeIfPresent(name, (k, v) -> Optional.empty());
        this.cachedGeneralKeywordParameters = null;
        this.cachedPublicFunctions = null;
    }

    public void addExtend(String name) {
        if (this.extended == null) {
            this.extended = new HashSet<String>();
        }
        this.extended.add(name);
        this.cachedGeneralKeywordParameters = null;
        this.cachedPublicFunctions = null;
    }

    public List<AbstractFunction> getTests() {
        LinkedList<AbstractFunction> result = new LinkedList<AbstractFunction>();
        if (this.functionEnvironment != null) {
            for (LinkedHashSet f : this.functionEnvironment.values()) {
                for (AbstractFunction c : f) {
                    if (!c.isTest()) continue;
                    result.add(c);
                }
            }
        }
        return result;
    }

    @Override
    public Set<String> getImports() {
        return Collections.unmodifiableSet(this.importedModules.keySet());
    }

    public Set<String> getImportsTransitive() {
        LinkedList<String> todo = new LinkedList<String>();
        HashSet<String> done = new HashSet<String>();
        HashSet<String> result = new HashSet<String>();
        todo.add(this.getName());
        GlobalEnvironment heap = this.getHeap();
        while (!todo.isEmpty()) {
            String mod = (String)todo.remove(0);
            done.add(mod);
            ModuleEnvironment env = mod.equals(this.getName()) ? this : heap.getModule(mod);
            if (env == null) continue;
            for (String e : env.getImports()) {
                result.add(e);
                if (done.contains(e)) continue;
                todo.add(e);
            }
        }
        return result;
    }

    public void unImport(String moduleName) {
        Optional<ModuleEnvironment> old = this.importedModules.remove(moduleName);
        if (old != null && old.isPresent()) {
            this.typeStore.unimportStores(old.get().getStore());
        }
        this.cachedGeneralKeywordParameters = null;
        this.cachedPublicFunctions = null;
    }

    public void unExtend(String moduleName) {
        this.extended.remove(moduleName);
        this.cachedGeneralKeywordParameters = null;
        this.cachedPublicFunctions = null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public TypeStore getStore() {
        return this.typeStore;
    }

    @Override
    public Result<IValue> getVariable(QualifiedName name) {
        String modulename = Names.moduleName(name);
        String cons = Names.name(Names.lastName(name));
        Type adt = this.getAbstractDataType(modulename);
        if (adt != null) {
            LinkedList<AbstractFunction> result = new LinkedList<AbstractFunction>();
            this.getAllFunctions(adt, cons, result);
            if (result.isEmpty()) {
                return null;
            }
            if (result.size() == 1) {
                return (Result)result.get(0);
            }
            return new OverloadedFunction(cons, result);
        }
        if (modulename != null) {
            if (modulename.equals(this.getName())) {
                return this.getFrameVariable(cons);
            }
            ModuleEnvironment imported = this.getImport(modulename);
            if (imported == null) {
                throw new UndeclaredModule(modulename, name);
            }
            return imported.getVariable(name);
        }
        return this.getFrameVariable(cons);
    }

    @Override
    public void storeVariable(String name, Result<IValue> value) {
        Result<IValue> result = super.getFrameVariable(name);
        if (result != null) {
            super.storeVariable(name, value);
        } else {
            for (ModuleEnvironment module : this.importedModulesResolved) {
                result = module.getLocalPublicVariable(name);
                if (result == null) continue;
                module.storeVariable(name, value);
                return;
            }
            super.storeVariable(name, value);
        }
    }

    @Override
    public Result<IValue> getSimpleVariable(String name) {
        Result<IValue> var = super.getSimpleVariable(name);
        if (var != null) {
            return var;
        }
        for (ModuleEnvironment mod : this.importedModulesResolved) {
            if (mod != null) {
                var = mod.getLocalPublicVariable(name);
            }
            if (var == null) continue;
            return var;
        }
        return null;
    }

    @Override
    protected Map<String, Result<IValue>> getVariableDefiningEnvironment(String name) {
        Result r;
        if (this.variableEnvironment != null && (r = (Result)this.variableEnvironment.get(name)) != null) {
            return this.variableEnvironment;
        }
        for (ModuleEnvironment mod : this.importedModulesResolved) {
            Result r2 = null;
            if (mod != null && mod.variableEnvironment != null) {
                r2 = (Result)mod.variableEnvironment.get(name);
            }
            if (r2 == null || mod.isVariablePrivate(name)) continue;
            return mod.variableEnvironment;
        }
        return null;
    }

    @Override
    public void getAllFunctions(String name, List<AbstractFunction> collection) {
        collection.addAll(this.lookupCachedFunctions(name));
    }

    private List<AbstractFunction> lookupCachedFunctions(String name) {
        if (this.cachedPublicFunctions == null) {
            this.cachedPublicFunctions = Map.Transient.of();
        }
        return this.cachedPublicFunctions.computeIfAbsent(name, n -> {
            ArrayList<AbstractFunction> result = new ArrayList<AbstractFunction>();
            super.getAllFunctions((String)n, (List<AbstractFunction>)result);
            for (ModuleEnvironment mod : this.importedModulesResolved) {
                if (mod == null) continue;
                mod.getLocalPublicFunctions((String)n, (List<AbstractFunction>)result);
            }
            return result;
        });
    }

    @Override
    public void getAllFunctions(Type returnType, String name, List<AbstractFunction> collection) {
        for (AbstractFunction function : this.lookupCachedFunctions(name)) {
            if (!function.getReturnType().comparable(returnType)) continue;
            collection.add(function);
        }
    }

    private Result<IValue> getLocalPublicVariable(String name) {
        Result var = null;
        if (this.variableEnvironment != null) {
            var = (Result)this.variableEnvironment.get(name);
        }
        if (var != null && !this.isVariablePrivate(name)) {
            return var;
        }
        return null;
    }

    private void getLocalPublicFunctions(String name, List<AbstractFunction> collection) {
        LinkedHashSet lst;
        if (this.functionEnvironment != null && (lst = (LinkedHashSet)this.functionEnvironment.get(name)) != null && !this.isFunctionPrivate(name)) {
            collection.addAll(lst);
        }
    }

    @Override
    public Type abstractDataType(String name, Type ... parameters) {
        return TF.abstractDataType(this.typeStore, name, parameters);
    }

    @Override
    public Type concreteSyntaxType(String name, IConstructor symbol) {
        NonTerminalType sort = (NonTerminalType)RascalTypeFactory.getInstance().nonTerminalType(symbol);
        this.concreteSyntaxTypes.put(name, sort);
        return sort;
    }

    @Override
    public void unsetConcreteSyntaxType(String name) {
        this.concreteSyntaxTypes.remove(name);
    }

    private Type makeTupleType(Type adt, String name, Type tupleType) {
        return TF.constructorFromTuple(this.typeStore, adt, name, tupleType);
    }

    @Override
    public ConstructorFunction constructorFromTuple(AbstractAST ast, Evaluator eval, Type adt, String name, Type tupleType, List<KeywordFormal> initializers) {
        Type cons = this.makeTupleType(adt, name, tupleType);
        ConstructorFunction function = new ConstructorFunction(ast, eval, this, cons, initializers);
        this.storeFunction(name, function);
        this.markFunctionNameFinal(name);
        this.markFunctionNameOverloadable(name);
        return function;
    }

    @Override
    public Type aliasType(String name, Type aliased, Type ... parameters) {
        return TF.aliasType(this.typeStore, name, aliased, parameters);
    }

    @Override
    public void declareAnnotation(Type onType, String label, Type valueType) {
        if (RascalValueFactory.isLegacySourceLocationAnnotation(onType, label)) {
            label = "src";
        }
        this.typeStore.declareKeywordParameter(onType, label, valueType);
    }

    private boolean keywordFormalExists(List<KeywordFormal> haystack, KeywordFormal needle) {
        String label = ((Name.Lexical)needle.getName()).getString();
        for (KeywordFormal candidate : haystack) {
            if (!((Name.Lexical)candidate.getName()).getString().equals(label)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void declareGenericKeywordParameters(Type adt, Type kwTypes, List<KeywordFormal> formals) {
        List<KeywordFormal> list = this.generalKeywordParameters.get(adt);
        if (list == null) {
            list = new ArrayList<KeywordFormal>();
            this.generalKeywordParameters.put(adt, list);
        }
        for (KeywordFormal f : formals) {
            if (this.keywordFormalExists(list, f)) continue;
            list.add(f);
        }
        for (String label : kwTypes.getFieldNames()) {
            this.typeStore.declareKeywordParameter(adt, label, kwTypes.getFieldType(label));
        }
    }

    @Override
    public Map<String, Type> getKeywordParameterTypes(Type ontype) {
        return this.typeStore.getKeywordParameters(ontype);
    }

    @Override
    public Set<GenericKeywordParameters> lookupGenericKeywordParameters(Type adt) {
        Set<GenericKeywordParameters> result;
        if (this.cachedGeneralKeywordParameters != null) {
            result = this.cachedGeneralKeywordParameters.get(adt);
            if (result != null) {
                return result;
            }
        } else {
            this.cachedGeneralKeywordParameters = Map.Transient.of();
        }
        result = new HashSet<GenericKeywordParameters>();
        List<KeywordFormal> list = this.generalKeywordParameters.get(adt);
        if (list != null) {
            result.add(new GenericKeywordParameters(this, list, this.getStore().getKeywordParameters(adt)));
        }
        for (ModuleEnvironment mod : this.importedModulesResolved) {
            list = mod.generalKeywordParameters.get(adt);
            if (list == null) continue;
            result.add(new GenericKeywordParameters(mod, list, mod.getStore().getKeywordParameters(adt)));
        }
        this.cachedGeneralKeywordParameters.put(adt, result);
        return result;
    }

    @Override
    public void declareConstructorKeywordParameter(Type onType, String label, Type valueType) {
        this.typeStore.declareKeywordParameter(onType, label, valueType);
    }

    @Override
    public Type getAnnotationType(Type type, String label) {
        Type anno = this.typeStore.getKeywordParameterType(type, label);
        if (anno == null && type instanceof NonTerminalType) {
            return this.typeStore.getKeywordParameterType(RascalValueFactory.Tree, label);
        }
        return anno;
    }

    public Collection<Type> getAbstractDatatypes() {
        return this.typeStore.getAbstractDataTypes();
    }

    public Collection<Type> getAliases() {
        return this.typeStore.getAliases();
    }

    public Map<Type, Map<String, Type>> getAnnotations() {
        return this.typeStore.getKeywordParameters();
    }

    @Override
    public Type getAbstractDataType(String sort) {
        return this.typeStore.lookupAbstractDataType(sort);
    }

    @Override
    public Type getConstructor(String cons, Type args) {
        return this.typeStore.lookupFirstConstructor(cons, args);
    }

    @Override
    public Type getConstructor(Type sort, String cons, Type args) {
        return this.typeStore.lookupConstructor(sort, cons, args);
    }

    @Override
    public boolean isTreeConstructorName(QualifiedName name, Type signature) {
        String cons;
        String cons2;
        String sort;
        Type sortType;
        List<Name> names = name.getNames();
        return names.size() > 1 ? (sortType = this.getAbstractDataType(sort = Names.sortName(name))) != null && this.getConstructor(sortType, cons2 = Names.consName(name), signature) != null : this.getConstructor(cons = Names.consName(name), signature) != null;
    }

    @Override
    public String toString() {
        return "Environment [ " + this.getName() + ", imports: " + (this.importedModules != null ? this.importedModules : "") + ", extends: " + (this.extended != null ? this.extended : "") + "]";
    }

    @Override
    public ModuleEnvironment getImport(String moduleName) {
        Optional result = this.importedModules.computeIfPresent(moduleName, (m4, c) -> c.isPresent() ? c : Optional.ofNullable(this.heap.getModule((String)m4)));
        if (result == null || result.isEmpty()) {
            return null;
        }
        return (ModuleEnvironment)result.get();
    }

    @Override
    public void storeVariable(QualifiedName name, Result<IValue> result) {
        String modulename = Names.moduleName(name);
        if (modulename != null) {
            if (modulename.equals(this.getName())) {
                this.storeVariable(Names.name(Names.lastName(name)), result);
                return;
            }
            ModuleEnvironment imported = this.getImport(modulename);
            if (imported == null) {
                throw new UndeclaredModule(modulename, name);
            }
            imported.storeVariable(name, result);
            return;
        }
        super.storeVariable(name, result);
    }

    @Override
    public boolean declaresAnnotation(Type type, String label) {
        return this.typeStore.getKeywordParameterType(type, label) != null;
    }

    @Override
    public Type lookupAbstractDataType(String name) {
        return this.typeStore.lookupAbstractDataType(name);
    }

    @Override
    public Type lookupConcreteSyntaxType(String name) {
        Type type = this.concreteSyntaxTypes.get(name);
        if (type == null) {
            for (ModuleEnvironment mod : this.importedModulesResolved) {
                if (mod == null || (type = (Type)mod.concreteSyntaxTypes.get(name)) == null) continue;
                return type;
            }
        }
        return type;
    }

    @Override
    public Type lookupAlias(String name) {
        return this.typeStore.lookupAlias(name);
    }

    @Override
    public Set<Type> lookupAlternatives(Type adt) {
        return this.typeStore.lookupAlternatives(adt);
    }

    @Override
    public Type lookupConstructor(Type adt, String cons, Type args) {
        return this.typeStore.lookupConstructor(adt, cons, args);
    }

    @Override
    public Set<Type> lookupConstructor(Type adt, String constructorName) throws FactTypeUseException {
        return this.typeStore.lookupConstructor(adt, constructorName);
    }

    @Override
    public Set<Type> lookupConstructors(String constructorName) {
        return this.typeStore.lookupConstructors(constructorName);
    }

    @Override
    public Type lookupFirstConstructor(String cons, Type args) {
        return this.typeStore.lookupFirstConstructor(cons, args);
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void setInitialized() {
        this.initialized = true;
    }

    public void setInitialized(boolean init) {
        this.initialized = init;
    }

    public void setBootstrap(boolean needBootstrapParser) {
        this.bootstrap = needBootstrapParser;
    }

    public boolean getBootstrap() {
        return this.bootstrap;
    }

    @Override
    protected boolean isVariableFlagged(QualifiedName name, Predicate<Environment.NameFlags> tester) {
        String modulename = Names.moduleName(name);
        String cons = Names.name(Names.lastName(name));
        if (modulename != null) {
            if (modulename.equals(this.getName())) {
                return this.isVariableFlagged(cons, tester);
            }
            ModuleEnvironment imported = this.getImport(modulename);
            if (imported == null) {
                return false;
            }
            return imported.isVariableFlagged(cons, tester);
        }
        return this.isVariableFlagged(cons, tester);
    }

    @Override
    protected boolean isFunctionFlagged(QualifiedName name, Predicate<Environment.NameFlags> tester) {
        String modulename = Names.moduleName(name);
        String cons = Names.name(Names.lastName(name));
        if (modulename != null) {
            if (modulename.equals(this.getName())) {
                return this.isFunctionFlagged(cons, tester);
            }
            ModuleEnvironment imported = this.getImport(modulename);
            if (imported == null) {
                return false;
            }
            return imported.isFunctionFlagged(cons, tester);
        }
        return this.isFunctionFlagged(cons, tester);
    }

    @Override
    protected void flagVariableName(QualifiedName name, Environment.NameFlags flags) {
        String modulename = Names.moduleName(name);
        String cons = Names.name(Names.lastName(name));
        if (modulename != null) {
            ModuleEnvironment imported;
            if (modulename.equals(this.getName())) {
                this.flagVariableName(cons, flags);
            }
            if ((imported = this.getImport(modulename)) == null) {
                throw new UndeclaredModule(modulename, name);
            }
            imported.flagVariableName(cons, flags);
        }
        this.flagVariableName(cons, flags);
    }

    @Override
    protected void flagFunctionName(QualifiedName name, Environment.NameFlags flags) {
        String modulename = Names.moduleName(name);
        String cons = Names.name(Names.lastName(name));
        if (modulename != null) {
            ModuleEnvironment imported;
            if (modulename.equals(this.getName())) {
                this.flagFunctionName(cons, flags);
            }
            if ((imported = this.getImport(modulename)) == null) {
                throw new UndeclaredModule(modulename, name);
            }
            imported.flagFunctionName(cons, flags);
        }
        this.flagFunctionName(cons, flags);
    }

    @Override
    protected Environment getVariableFlagsEnvironment(String name) {
        Environment env = super.getVariableFlagsEnvironment(name);
        if (env != null) {
            return env;
        }
        for (ModuleEnvironment mod : this.importedModulesResolved) {
            if (mod == null) {
                throw new RuntimeException("getFlagsEnvironment");
            }
            env = mod.getLocalVariableFlagsEnvironment(name);
            if (env == null) continue;
            return env;
        }
        return null;
    }

    @Override
    protected Environment getFunctionFlagsEnvironment(String name) {
        Environment env = super.getFunctionFlagsEnvironment(name);
        if (env != null) {
            return env;
        }
        for (ModuleEnvironment mod : this.importedModulesResolved) {
            if (mod == null) {
                throw new RuntimeException("getFlagsEnvironment");
            }
            env = mod.getLocalFunctionFlagsEnvironment(name);
            if (env == null) continue;
            return env;
        }
        return null;
    }

    private Environment getLocalVariableFlagsEnvironment(String name) {
        if (this.variableFlags != null && this.variableFlags.get(name) != null) {
            return this;
        }
        return null;
    }

    private Environment getLocalFunctionFlagsEnvironment(String name) {
        if (this.functionFlags != null && this.functionFlags.get(name) != null) {
            return this;
        }
        return null;
    }

    public Set<String> getExtends() {
        if (this.extended != null) {
            return Collections.unmodifiableSet(this.extended);
        }
        return Collections.emptySet();
    }

    public Set<String> getExtendsTransitive() {
        LinkedList<String> todo = new LinkedList<String>();
        HashSet<String> done = new HashSet<String>();
        HashSet<String> result = new HashSet<String>();
        todo.add(this.getName());
        GlobalEnvironment heap = this.getHeap();
        while (!todo.isEmpty()) {
            String mod = (String)todo.remove(0);
            done.add(mod);
            ModuleEnvironment env = heap.getModule(mod);
            if (env == null) continue;
            for (String e : env.getExtends()) {
                result.add(e);
                if (done.contains(e)) continue;
                todo.add(e);
            }
        }
        return result;
    }

    public void removeExtend(String name) {
        this.extended.remove(name);
    }

    public void setDeprecatedMessage(String deprecatedMessage) {
        this.deprecated = deprecatedMessage;
    }

    public boolean isDeprecated() {
        return this.deprecated != null;
    }

    public String getDeprecatedMessage() {
        return this.deprecated;
    }

    public boolean hasImporterForResource(String resourceScheme) {
        return this.resourceImporters.containsKey(resourceScheme);
    }

    public void addResourceImporter(AbstractFunction fun) {
        this.resourceImporters.put(fun.getResourceScheme(), fun);
    }

    public AbstractFunction getResourceImporter(String resourceScheme) {
        if (this.hasImporterForResource(resourceScheme)) {
            return this.resourceImporters.get(resourceScheme);
        }
        return null;
    }

    public void resetProductions() {
        this.productions = new HashSet<IValue>(this.productions.size());
    }

    public Set<IValue> getProductions() {
        return this.productions;
    }

    public static class GenericKeywordParameters {
        final List<KeywordFormal> formals;
        final ModuleEnvironment env;
        final Map<String, Type> types;

        public GenericKeywordParameters(ModuleEnvironment env, List<KeywordFormal> formals, Map<String, Type> types) {
            this.env = env;
            this.formals = Collections.unmodifiableList(formals);
            this.types = types;
        }

        public Map<String, Type> getTypes() {
            return this.types;
        }

        public ModuleEnvironment getEnv() {
            return this.env;
        }

        public List<KeywordFormal> getFormals() {
            return this.formals;
        }
    }
}

