/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.interpreter.result;

import com.ibm.icu.util.Calendar;
import io.usethesource.vallang.IBool;
import io.usethesource.vallang.IDateTime;
import io.usethesource.vallang.IInteger;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IValueFactory;
import io.usethesource.vallang.exceptions.InvalidDateTimeException;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import io.usethesource.vallang.type.TypeStore;
import java.util.Iterator;
import org.rascalmpl.exceptions.RuntimeExceptionFactory;
import org.rascalmpl.interpreter.IEvaluatorContext;
import org.rascalmpl.interpreter.result.ElementResult;
import org.rascalmpl.interpreter.result.LessThanOrEqualResult;
import org.rascalmpl.interpreter.result.ListRelationResult;
import org.rascalmpl.interpreter.result.RelationResult;
import org.rascalmpl.interpreter.result.Result;
import org.rascalmpl.interpreter.result.ResultFactory;
import org.rascalmpl.interpreter.staticErrors.InvalidDateTimeComparison;
import org.rascalmpl.interpreter.staticErrors.UndeclaredField;
import org.rascalmpl.interpreter.staticErrors.UnexpectedType;
import org.rascalmpl.interpreter.staticErrors.UnsupportedOperation;
import org.rascalmpl.values.ValueFactoryFactory;

public class DateTimeResult
extends ElementResult<IDateTime> {
    private static TypeFactory TF = TypeFactory.getInstance();
    private static IValueFactory VF = ValueFactoryFactory.getValueFactory();
    public static final TypeStore TS = new TypeStore(new TypeStore[0]);
    public static final Type Duration = TF.abstractDataType(TS, "Duration", new Type[0]);
    public static final Type duration = TF.constructor(TS, Duration, "duration", TF.integerType(), "years", TF.integerType(), "months", TF.integerType(), "days", TF.integerType(), "hours", TF.integerType(), "minutes", TF.integerType(), "seconds", TF.integerType(), "milliseconds");

    public DateTimeResult(Type type, IDateTime value, IEvaluatorContext ctx) {
        super(type, value, ctx);
    }

    public DateTimeResult(Type type, IDateTime value, Iterator<Result<IValue>> iter, IEvaluatorContext ctx) {
        super(type, value, iter, ctx);
    }

    @Override
    public <V extends IValue> Result<IBool> equals(Result<V> that) {
        return that.equalToDateTime(this);
    }

    @Override
    protected Result<IBool> equalToDateTime(DateTimeResult that) {
        this.checkDateTimeComparison(that);
        return ResultFactory.bool(((IDateTime)that.value).getInstant() == ((IDateTime)this.value).getInstant(), this.ctx);
    }

    @Override
    public <V extends IValue> Result<IBool> nonEquals(Result<V> that) {
        return that.nonEqualToDateTime(this);
    }

    @Override
    protected Result<IBool> nonEqualToDateTime(DateTimeResult that) {
        this.checkDateTimeComparison(that);
        return ResultFactory.bool(((IDateTime)that.value).getInstant() != ((IDateTime)this.value).getInstant(), this.ctx);
    }

    @Override
    public <U extends IValue> Result<U> fieldAccess(String name, TypeStore store) {
        IValueFactory vf = this.getValueFactory();
        IDateTime dt = (IDateTime)this.getValue();
        try {
            if (name.equals("year")) {
                if (!dt.isTime()) {
                    return ResultFactory.makeResult(this.getTypeFactory().integerType(), vf.integer(dt.getYear()), this.ctx);
                }
                throw new UnsupportedOperation("Can not retrieve the year on a time value", this.ctx.getCurrentAST());
            }
            if (name.equals("month")) {
                if (!dt.isTime()) {
                    return ResultFactory.makeResult(this.getTypeFactory().integerType(), vf.integer(((IDateTime)this.getValue()).getMonthOfYear()), this.ctx);
                }
                throw new UnsupportedOperation("Can not retrieve the month on a time value", this.ctx.getCurrentAST());
            }
            if (name.equals("day")) {
                if (!dt.isTime()) {
                    return ResultFactory.makeResult(this.getTypeFactory().integerType(), vf.integer(((IDateTime)this.getValue()).getDayOfMonth()), this.ctx);
                }
                throw new UnsupportedOperation("Can not retrieve the day on a time value", this.ctx.getCurrentAST());
            }
            if (name.equals("hour")) {
                if (!dt.isDate()) {
                    return ResultFactory.makeResult(this.getTypeFactory().integerType(), vf.integer(((IDateTime)this.getValue()).getHourOfDay()), this.ctx);
                }
                throw new UnsupportedOperation("Can not retrieve the hour on a date value", this.ctx.getCurrentAST());
            }
            if (name.equals("minute")) {
                if (!dt.isDate()) {
                    return ResultFactory.makeResult(this.getTypeFactory().integerType(), vf.integer(((IDateTime)this.getValue()).getMinuteOfHour()), this.ctx);
                }
                throw new UnsupportedOperation("Can not retrieve the minute on a date value", this.ctx.getCurrentAST());
            }
            if (name.equals("second")) {
                if (!dt.isDate()) {
                    return ResultFactory.makeResult(this.getTypeFactory().integerType(), vf.integer(((IDateTime)this.getValue()).getSecondOfMinute()), this.ctx);
                }
                throw new UnsupportedOperation("Can not retrieve the second on a date value", this.ctx.getCurrentAST());
            }
            if (name.equals("millisecond")) {
                if (!dt.isDate()) {
                    return ResultFactory.makeResult(this.getTypeFactory().integerType(), vf.integer(((IDateTime)this.getValue()).getMillisecondsOfSecond()), this.ctx);
                }
                throw new UnsupportedOperation("Can not retrieve the millisecond on a date value", this.ctx.getCurrentAST());
            }
            if (name.equals("timezoneOffsetHours")) {
                if (!dt.isDate()) {
                    return ResultFactory.makeResult(this.getTypeFactory().integerType(), vf.integer(((IDateTime)this.getValue()).getTimezoneOffsetHours()), this.ctx);
                }
                throw new UnsupportedOperation("Can not retrieve the timezone offset hours on a date value", this.ctx.getCurrentAST());
            }
            if (name.equals("timezoneOffsetMinutes")) {
                if (!dt.isDate()) {
                    return ResultFactory.makeResult(this.getTypeFactory().integerType(), vf.integer(((IDateTime)this.getValue()).getTimezoneOffsetMinutes()), this.ctx);
                }
                throw new UnsupportedOperation("Can not retrieve the timezone offset minutes on a date value", this.ctx.getCurrentAST());
            }
            if (name.equals("century")) {
                if (!dt.isTime()) {
                    return ResultFactory.makeResult(this.getTypeFactory().integerType(), vf.integer(((IDateTime)this.getValue()).getCentury()), this.ctx);
                }
                throw new UnsupportedOperation("Can not retrieve the century on a time value", this.ctx.getCurrentAST());
            }
            if (name.equals("isDate")) {
                return ResultFactory.makeResult(this.getTypeFactory().boolType(), vf.bool(((IDateTime)this.getValue()).isDate()), this.ctx);
            }
            if (name.equals("isTime")) {
                return ResultFactory.makeResult(this.getTypeFactory().boolType(), vf.bool(((IDateTime)this.getValue()).isTime()), this.ctx);
            }
            if (name.equals("isDateTime")) {
                return ResultFactory.makeResult(this.getTypeFactory().boolType(), vf.bool(((IDateTime)this.getValue()).isDateTime()), this.ctx);
            }
            if (name.equals("justDate")) {
                if (!dt.isTime()) {
                    return ResultFactory.makeResult(this.getTypeFactory().dateTimeType(), vf.date(dt.getYear(), dt.getMonthOfYear(), dt.getDayOfMonth()), this.ctx);
                }
                throw new UnsupportedOperation("Can not retrieve the date component of a time value", this.ctx.getCurrentAST());
            }
            if (name.equals("justTime")) {
                if (!dt.isDate()) {
                    return ResultFactory.makeResult(this.getTypeFactory().dateTimeType(), vf.time(dt.getHourOfDay(), dt.getMinuteOfHour(), dt.getSecondOfMinute(), dt.getMillisecondsOfSecond(), dt.getTimezoneOffsetHours(), dt.getTimezoneOffsetMinutes()), this.ctx);
                }
                throw new UnsupportedOperation("Can not retrieve the time component of a date value", this.ctx.getCurrentAST());
            }
        }
        catch (InvalidDateTimeException e) {
            throw RuntimeExceptionFactory.illegalArgument((IValue)dt, e.getMessage(), this.ctx.getCurrentAST(), null);
        }
        throw new UndeclaredField(name, this.getTypeFactory().dateTimeType(), this.ctx.getCurrentAST());
    }

    @Override
    public <U extends IValue, V extends IValue> Result<U> fieldUpdate(String name, Result<V> repl, TypeStore store) {
        Type replType = repl.getStaticType();
        V replValue = repl.getValue();
        IDateTime dt = (IDateTime)this.getValue();
        int year = dt.getYear();
        int month = dt.getMonthOfYear();
        int day = dt.getDayOfMonth();
        int hour = dt.getHourOfDay();
        int minute = dt.getMinuteOfHour();
        int second = dt.getSecondOfMinute();
        int milli = dt.getMillisecondsOfSecond();
        int tzOffsetHour = dt.getTimezoneOffsetHours();
        int tzOffsetMin = dt.getTimezoneOffsetMinutes();
        try {
            if (name.equals("year")) {
                if (dt.isTime()) {
                    throw new UnsupportedOperation("Can not update the year on a time value", this.ctx.getCurrentAST());
                }
                if (!replType.isInteger()) {
                    throw new UnexpectedType(this.getTypeFactory().integerType(), replType, this.ctx.getCurrentAST());
                }
                year = ((IInteger)replValue).intValue();
            } else if (name.equals("month")) {
                if (dt.isTime()) {
                    throw new UnsupportedOperation("Can not update the month on a time value", this.ctx.getCurrentAST());
                }
                if (!replType.isInteger()) {
                    throw new UnexpectedType(this.getTypeFactory().integerType(), replType, this.ctx.getCurrentAST());
                }
                month = ((IInteger)replValue).intValue();
            } else if (name.equals("day")) {
                if (dt.isTime()) {
                    throw new UnsupportedOperation("Can not update the day on a time value", this.ctx.getCurrentAST());
                }
                if (!replType.isInteger()) {
                    throw new UnexpectedType(this.getTypeFactory().integerType(), replType, this.ctx.getCurrentAST());
                }
                day = ((IInteger)replValue).intValue();
            } else if (name.equals("hour")) {
                if (dt.isDate()) {
                    throw new UnsupportedOperation("Can not update the hour on a date value", this.ctx.getCurrentAST());
                }
                if (!replType.isInteger()) {
                    throw new UnexpectedType(this.getTypeFactory().integerType(), replType, this.ctx.getCurrentAST());
                }
                hour = ((IInteger)replValue).intValue();
            } else if (name.equals("minute")) {
                if (dt.isDate()) {
                    throw new UnsupportedOperation("Can not update the minute on a date value", this.ctx.getCurrentAST());
                }
                if (!replType.isInteger()) {
                    throw new UnexpectedType(this.getTypeFactory().integerType(), replType, this.ctx.getCurrentAST());
                }
                minute = ((IInteger)replValue).intValue();
            } else if (name.equals("second")) {
                if (dt.isDate()) {
                    throw new UnsupportedOperation("Can not update the second on a date value", this.ctx.getCurrentAST());
                }
                if (!replType.isInteger()) {
                    throw new UnexpectedType(this.getTypeFactory().integerType(), replType, this.ctx.getCurrentAST());
                }
                second = ((IInteger)replValue).intValue();
            } else if (name.equals("millisecond")) {
                if (dt.isDate()) {
                    throw new UnsupportedOperation("Can not update the millisecond on a date value", this.ctx.getCurrentAST());
                }
                if (!replType.isInteger()) {
                    throw new UnexpectedType(this.getTypeFactory().integerType(), replType, this.ctx.getCurrentAST());
                }
                milli = ((IInteger)replValue).intValue();
            } else if (name.equals("timezoneOffsetHours")) {
                if (dt.isDate()) {
                    throw new UnsupportedOperation("Can not update the timezone offset hours on a date value", this.ctx.getCurrentAST());
                }
                if (!replType.isInteger()) {
                    throw new UnexpectedType(this.getTypeFactory().integerType(), replType, this.ctx.getCurrentAST());
                }
                tzOffsetHour = ((IInteger)replValue).intValue();
            } else if (name.equals("timezoneOffsetMinutes")) {
                if (dt.isDate()) {
                    throw new UnsupportedOperation("Can not update the timezone offset minutes on a date value", this.ctx.getCurrentAST());
                }
                if (!replType.isInteger()) {
                    throw new UnexpectedType(this.getTypeFactory().integerType(), replType, this.ctx.getCurrentAST());
                }
                tzOffsetMin = ((IInteger)replValue).intValue();
            } else {
                throw new UndeclaredField(name, this.getTypeFactory().dateTimeType(), this.ctx.getCurrentAST());
            }
            IDateTime newdt = null;
            newdt = dt.isDate() ? this.getValueFactory().date(year, month, day) : (dt.isTime() ? this.getValueFactory().time(hour, minute, second, milli, tzOffsetHour, tzOffsetMin) : this.getValueFactory().datetime(year, month, day, hour, minute, second, milli, tzOffsetHour, tzOffsetMin));
            return ResultFactory.makeResult(this.getStaticType(), newdt, this.ctx);
        }
        catch (IllegalArgumentException e) {
            throw RuntimeExceptionFactory.illegalArgument(repl.getValue(), "Cannot update field " + name + ", this would generate an invalid datetime value", this.ctx.getCurrentAST(), null);
        }
        catch (InvalidDateTimeException e) {
            throw RuntimeExceptionFactory.illegalArgument(repl.getValue(), e.getMessage(), this.ctx.getCurrentAST(), null);
        }
    }

    private void checkDateTimeComparison(DateTimeResult that) {
        if (((IDateTime)that.getValue()).isDate()) {
            if (((IDateTime)this.getValue()).isTime()) {
                throw new InvalidDateTimeComparison("date", "time", this.ctx.getCurrentAST());
            }
            if (((IDateTime)this.getValue()).isDateTime()) {
                throw new InvalidDateTimeComparison("date", "datetime", this.ctx.getCurrentAST());
            }
        } else if (((IDateTime)that.getValue()).isTime()) {
            if (((IDateTime)this.getValue()).isDate()) {
                throw new InvalidDateTimeComparison("time", "date", this.ctx.getCurrentAST());
            }
            if (((IDateTime)this.getValue()).isDateTime()) {
                throw new InvalidDateTimeComparison("time", "datetime", this.ctx.getCurrentAST());
            }
        } else {
            if (((IDateTime)this.getValue()).isDate()) {
                throw new InvalidDateTimeComparison("datetime", "date", this.ctx.getCurrentAST());
            }
            if (((IDateTime)this.getValue()).isTime()) {
                throw new InvalidDateTimeComparison("datetime", "time", this.ctx.getCurrentAST());
            }
        }
    }

    @Override
    public <V extends IValue> Result<IBool> greaterThan(Result<V> that) {
        return that.greaterThanDateTime(this);
    }

    @Override
    protected Result<IBool> greaterThanDateTime(DateTimeResult that) {
        this.checkDateTimeComparison(that);
        return ResultFactory.bool(((IDateTime)that.value).getInstant() > ((IDateTime)this.value).getInstant(), this.ctx);
    }

    @Override
    public <V extends IValue> Result<IBool> greaterThanOrEqual(Result<V> that) {
        return that.greaterThanOrEqualDateTime(this);
    }

    @Override
    protected Result<IBool> greaterThanOrEqualDateTime(DateTimeResult that) {
        this.checkDateTimeComparison(that);
        return ResultFactory.bool(((IDateTime)that.value).getInstant() >= ((IDateTime)this.value).getInstant(), this.ctx);
    }

    @Override
    public <V extends IValue> Result<IBool> lessThan(Result<V> that) {
        return that.lessThanDateTime(this);
    }

    @Override
    protected Result<IBool> lessThanDateTime(DateTimeResult that) {
        this.checkDateTimeComparison(that);
        return ResultFactory.bool(((IDateTime)that.value).getInstant() < ((IDateTime)this.value).getInstant(), this.ctx);
    }

    @Override
    public <V extends IValue> LessThanOrEqualResult lessThanOrEqual(Result<V> that) {
        return that.lessThanOrEqualDateTime(this);
    }

    @Override
    protected LessThanOrEqualResult lessThanOrEqualDateTime(DateTimeResult that) {
        this.checkDateTimeComparison(that);
        return new LessThanOrEqualResult(((IDateTime)that.value).getInstant() < ((IDateTime)this.value).getInstant(), ((IDateTime)that.value).getInstant() == ((IDateTime)this.value).getInstant(), this.ctx);
    }

    @Override
    public <U extends IValue, V extends IValue> Result<U> subtract(Result<V> that) {
        return that.subtractDateTime(this);
    }

    @Override
    protected <U extends IValue> Result<U> subtractDateTime(DateTimeResult that) {
        IDateTime dStart = (IDateTime)this.getValue();
        Calendar startCal = Calendar.getInstance();
        startCal.setTimeInMillis(dStart.getInstant());
        IDateTime dEnd = (IDateTime)that.getValue();
        Calendar endCal = Calendar.getInstance();
        endCal.setTimeInMillis(dEnd.getInstant());
        if (dStart.isDate()) {
            if (dEnd.isDate()) {
                return ResultFactory.makeResult(Duration, VF.constructor(duration, VF.integer(startCal.fieldDifference(endCal.getTime(), 1)), VF.integer(startCal.fieldDifference(endCal.getTime(), 2)), VF.integer(startCal.fieldDifference(endCal.getTime(), 5)), VF.integer(0), VF.integer(0), VF.integer(0), VF.integer(0)), this.ctx);
            }
            if (dEnd.isTime()) {
                throw RuntimeExceptionFactory.invalidUseOfTimeException("Cannot determine the duration between a date with no time and a time with no date.", this.ctx.getCurrentAST(), null);
            }
            throw RuntimeExceptionFactory.invalidUseOfDateTimeException("Cannot determine the duration between a date with no time and a datetime.", this.ctx.getCurrentAST(), null);
        }
        if (dStart.isTime()) {
            if (dEnd.isTime()) {
                return ResultFactory.makeResult(Duration, VF.constructor(duration, VF.integer(0), VF.integer(0), VF.integer(0), VF.integer(startCal.fieldDifference(endCal.getTime(), 11)), VF.integer(startCal.fieldDifference(endCal.getTime(), 12)), VF.integer(startCal.fieldDifference(endCal.getTime(), 13)), VF.integer(startCal.fieldDifference(endCal.getTime(), 14))), this.ctx);
            }
            if (dEnd.isDate()) {
                throw RuntimeExceptionFactory.invalidUseOfDateException("Cannot determine the duration between a time with no date and a date with no time.", this.ctx.getCurrentAST(), null);
            }
            throw RuntimeExceptionFactory.invalidUseOfDateTimeException("Cannot determine the duration between a time with no date and a datetime.", this.ctx.getCurrentAST(), null);
        }
        if (dEnd.isDateTime()) {
            return ResultFactory.makeResult(Duration, VF.constructor(duration, VF.integer(startCal.fieldDifference(endCal.getTime(), 1)), VF.integer(startCal.fieldDifference(endCal.getTime(), 2)), VF.integer(startCal.fieldDifference(endCal.getTime(), 5)), VF.integer(startCal.fieldDifference(endCal.getTime(), 11)), VF.integer(startCal.fieldDifference(endCal.getTime(), 12)), VF.integer(startCal.fieldDifference(endCal.getTime(), 13)), VF.integer(startCal.fieldDifference(endCal.getTime(), 14))), this.ctx);
        }
        if (dEnd.isDate()) {
            throw RuntimeExceptionFactory.invalidUseOfDateException("Cannot determine the duration between a datetime and a date with no time.", this.ctx.getCurrentAST(), null);
        }
        throw RuntimeExceptionFactory.invalidUseOfTimeException("Cannot determine the duration between a datetime and a time with no date.", this.ctx.getCurrentAST(), null);
    }

    @Override
    protected <U extends IValue> Result<U> addListRelation(ListRelationResult that) {
        return that.addDateTime(this);
    }

    @Override
    protected <U extends IValue> Result<U> addRelation(RelationResult that) {
        return that.addDateTime(this);
    }
}

