/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.interpreter.utils;

import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import java.util.List;
import org.rascalmpl.ast.TypeArg;
import org.rascalmpl.interpreter.env.Environment;
import org.rascalmpl.interpreter.staticErrors.PartiallyLabeledFields;
import org.rascalmpl.interpreter.staticErrors.RedeclaredField;
import org.rascalmpl.interpreter.utils.Names;

public final class TypeUtils {
    private static TypeFactory TF = TypeFactory.getInstance();

    public static Type typeOf(List<TypeArg> args, Environment env, boolean noVoid) {
        Type[] fieldTypes = new Type[args.size()];
        String[] fieldLabels = new String[args.size()];
        int i = 0;
        boolean allLabeled = true;
        boolean someLabeled = false;
        for (TypeArg arg : args) {
            fieldTypes[i] = arg.getType().typeOf(env, null, false);
            if (noVoid && fieldTypes[i].isBottom()) {
                return fieldTypes[i];
            }
            if (arg.isNamed()) {
                fieldLabels[i] = Names.name(arg.getName());
                someLabeled = true;
            } else {
                fieldLabels[i] = null;
                allLabeled = false;
            }
            ++i;
        }
        if (someLabeled && !allLabeled) {
            throw new PartiallyLabeledFields(args.get(0));
        }
        if (!allLabeled) {
            return TF.tupleType(fieldTypes);
        }
        for (int j = 0; j < fieldLabels.length - 1; ++j) {
            for (int k = j + 1; k < fieldLabels.length; ++k) {
                if (!fieldLabels[j].equals(fieldLabels[k])) continue;
                throw new RedeclaredField(fieldLabels[j], args.get(k));
            }
        }
        return TF.tupleType(fieldTypes, fieldLabels);
    }
}

