/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.library.util;

import java.util.Scanner;
import java.util.regex.Pattern;

public class SemVer {
    private int major = 0;
    private int minor = 0;
    private int patch = 0;
    private String prerelease = "";
    private String build = "";
    static final Pattern wildCard = Pattern.compile("[xX\\*]");
    static final Pattern number = Pattern.compile("0|([1-9][0-9]*)");
    static final Pattern part = Pattern.compile("(0|([1-9][0-9]*))|[-0-9A-Za-z]+");
    static final Pattern or = Pattern.compile("\\s*\\|\\|\\s*");
    static final Pattern spaces = Pattern.compile("\\s+");
    static final Pattern hyphen = Pattern.compile(" - ");
    static final Pattern startVersion = Pattern.compile("[xX\\*]|([0-9]+)");
    static final String rangeTokens = "((\\s+\\-\\s+)|\\+|\\-|\\~|\\^|<|>|=|(\\s+\\|\\|\\s+)|\\s)";
    static final String versionTokens = "(\\+|\\-)";
    static final String digits = "[0-9]+";
    static final String delimiter = "\\.";

    SemVer(int major, int minor, int patch, String prerelease, String build) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.prerelease = prerelease;
        this.build = build;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPatch() {
        return this.patch;
    }

    public String getPrerelease() {
        return this.prerelease;
    }

    public String getBuild() {
        return this.build;
    }

    public SemVer(String version) {
        this(new Scanner(version.replaceAll(versionTokens, ".$1.")), false);
    }

    private SemVer(Scanner s2) {
        this(s2, true);
    }

    private SemVer(Scanner s2, boolean isPattern) {
        if (!isPattern && s2.hasNext("[=v]")) {
            s2.next("[=v]");
        }
        s2.useDelimiter(delimiter);
        if (!s2.hasNext(startVersion)) {
            throw new RuntimeException("Invalid version string");
        }
        this.major = this.hasNextXorN(s2) ? this.nextXorN(s2) : -1;
        this.minor = this.hasNextXorN(s2) ? this.nextXorN(s2) : -1;
        this.patch = this.hasNextXorN(s2) ? this.nextXorN(s2) : -1;
        this.prerelease = s2.hasNext("\\-") ? this.nextParts(s2) : "";
        String string = this.build = s2.hasNext("\\+") ? this.nextParts(s2) : "";
        if (isPattern) {
            if (s2.hasNext() && !s2.hasNext(spaces) && !s2.hasNext(hyphen) && !s2.hasNext(or)) {
                throw new RuntimeException("Invalid version pattern");
            }
        } else {
            if (s2.hasNext()) {
                throw new RuntimeException("Invalid version string");
            }
            s2.close();
        }
    }

    public SemVer incMajor() {
        return new SemVer(this.major + 1, 0, 0, "", "");
    }

    public SemVer incMinor() {
        return new SemVer(this.major, this.minor + 1, 0, "", "");
    }

    public SemVer incPatch() {
        return new SemVer(this.major, this.minor, this.patch + 1, "", "");
    }

    private boolean hasNextXorN(Scanner s2) {
        return s2.hasNext(wildCard) || s2.hasNext(number);
    }

    private int nextXorN(Scanner s2) {
        if (s2.hasNext(wildCard)) {
            s2.next();
            return -1;
        }
        if (s2.hasNext(number)) {
            return Integer.valueOf(s2.next());
        }
        throw new RuntimeException("Expected nextXorN");
    }

    private boolean hasNextPart(Scanner s2) {
        return s2.hasNext(part);
    }

    private String nextPart(Scanner s2) {
        return s2.next(part);
    }

    private String nextParts(Scanner s2) {
        s2.next();
        Object parts = this.nextPart(s2);
        while (this.hasNextPart(s2)) {
            parts = (String)parts + "." + this.nextPart(s2);
        }
        return parts;
    }

    public boolean equivalentVersion(SemVer other) {
        return this.equal(this.major, other.major) && this.equal(this.minor, other.minor) && this.equal(this.patch, other.patch) && this.prerelease.equals(other.prerelease);
    }

    public boolean equalVersion(SemVer other) {
        return this.equivalentVersion(other) && this.build.equals(other.build);
    }

    private boolean matchEqualTo(SemVer other) {
        return this.matchEqual(this.major, other.major) && this.matchEqual(this.minor, other.minor) && this.matchEqual(this.patch, other.patch);
    }

    private boolean matchEqual(int n, int m4) {
        return n >= 0 ? m4 < 0 || n == m4 : true;
    }

    private boolean equal(int n, int m4) {
        return n >= 0 && m4 >= 0 && n == m4;
    }

    private boolean less(int n, int m4) {
        return n >= 0 ? m4 >= 0 && n < m4 : false;
    }

    private boolean greater(int n, int m4) {
        return n >= 0 ? m4 >= 0 && n > m4 : false;
    }

    public boolean lessVersion(SemVer other) {
        return this.less(this.major, other.major) || this.less(this.minor, other.minor) || this.less(this.patch, other.patch) || !this.prerelease.equals(other.prerelease) && this.lessPrerelease(other);
    }

    public boolean greaterVersion(SemVer other) {
        return this.greater(this.major, other.major) || this.greater(this.minor, other.minor) || this.greater(this.patch, other.patch) || !this.prerelease.equals(other.prerelease) && !this.lessPrerelease(other);
    }

    public boolean lessEqualVersion(SemVer other) {
        return this.lessVersion(other) || this.equalVersion(other);
    }

    public boolean greaterEqualVersion(SemVer other) {
        return this.greaterVersion(other) || this.equalVersion(other);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean lessPrerelease(SemVer other) {
        String[] pre1 = this.prerelease.split(delimiter);
        String[] pre2 = other.prerelease.split(delimiter);
        int n = Integer.min(pre1.length, pre2.length);
        for (int i = 0; i < n; ++i) {
            String id1 = pre1[i];
            String id2 = pre2[i];
            if (!id1.isEmpty() && id2.isEmpty()) {
                return true;
            }
            if (id1.matches(digits)) {
                if (!id2.matches(digits)) return true;
                if (Integer.valueOf(id1) < Integer.valueOf(id2)) {
                    return true;
                }
            } else if (id2.matches(digits)) {
                return true;
            }
            if (id1.compareTo(id2) >= 0) continue;
            return true;
        }
        if (pre1.length >= pre2.length) return false;
        return true;
    }

    public boolean satisfiesVersion(String rangeSet) {
        try (Scanner s2 = new Scanner(this.insertDelimiters(rangeSet));){
            s2.useDelimiter(delimiter);
            if (this.satisfiesRange(s2)) {
                if (!s2.hasNext() || s2.hasNext(or)) {
                    boolean bl = true;
                    return bl;
                }
                throw new RuntimeException("Invalid range string");
            }
            while (s2.hasNext(or)) {
                s2.next(or);
                if (!this.satisfiesRange(s2)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    private String insertDelimiters(String input) {
        return input.replaceAll(rangeTokens, ".$1.").replaceAll("\\.\\.", delimiter);
    }

    private SemVer setWildCardsToZero() {
        if (this.major < 0) {
            this.major = 0;
        }
        if (this.minor < 0) {
            this.minor = 0;
        }
        if (this.patch < 0) {
            this.patch = 0;
        }
        return this;
    }

    private boolean satisfiesCaret(SemVer pat) {
        if (this.matchEqualTo(pat)) {
            return true;
        }
        if (pat.major > 0) {
            return this.greaterEqualVersion(pat) && this.lessVersion(pat.incMajor());
        }
        if (pat.minor > 0) {
            return this.greaterEqualVersion(pat) && this.lessVersion(pat.incMinor());
        }
        if (pat.patch > 0) {
            return this.greaterEqualVersion(pat) && this.lessVersion(pat.incPatch());
        }
        return false;
    }

    private boolean satisfiesSimple(Scanner s2) {
        s2.skip("\\s*");
        if (s2.hasNext("~")) {
            s2.next();
            SemVer pat = new SemVer(s2);
            if (pat.minor >= 0) {
                pat.setWildCardsToZero();
                return this.greaterEqualVersion(pat) && this.lessVersion(pat.incMinor());
            }
            pat.setWildCardsToZero();
            return this.greaterEqualVersion(pat) && this.lessVersion(pat.incMajor());
        }
        if (s2.hasNext("\\^")) {
            s2.next();
            return this.satisfiesCaret(new SemVer(s2));
        }
        if (s2.hasNext(">")) {
            s2.next();
            if (s2.hasNext("=")) {
                s2.next();
                return this.greaterEqualVersion(new SemVer(s2));
            }
            return this.greaterVersion(new SemVer(s2));
        }
        if (s2.hasNext("<")) {
            s2.next();
            if (s2.hasNext("=")) {
                s2.next();
                return this.lessEqualVersion(new SemVer(s2));
            }
            return this.lessVersion(new SemVer(s2));
        }
        if (s2.hasNext("=")) {
            s2.next();
            return this.equalVersion(new SemVer(s2));
        }
        if (s2.hasNext("[xX\\*]|[0-9]")) {
            return this.equalVersion(new SemVer(s2));
        }
        throw new RuntimeException("Invalid range string");
    }

    private boolean satisfiesRange(Scanner s2) {
        if (s2.hasNext("\\s*[\\<\\=\\>\\^\\~]")) {
            while (s2.hasNext("\\s*[\\<\\=\\>\\^\\~]")) {
                if (!this.satisfiesSimple(s2)) {
                    if (s2.hasNext() && !s2.hasNext(spaces)) {
                        throw new RuntimeException("Invalid range string");
                    }
                    return false;
                }
                if (!s2.hasNext(spaces)) continue;
                s2.next(spaces);
            }
            return true;
        }
        SemVer from = new SemVer(s2);
        if (s2.hasNext(hyphen)) {
            s2.next(hyphen);
            from.setWildCardsToZero();
            SemVer to = new SemVer(s2).setWildCardsToZero();
            return this.greaterEqualVersion(from) && this.lessEqualVersion(to);
        }
        return this.matchEqualTo(from);
    }

    public String toString() {
        return this.vnum(this.major) + "." + this.vnum(this.minor) + "." + this.vnum(this.patch) + (String)(this.prerelease.isEmpty() ? "" : "-" + this.prerelease) + (String)(this.build.isEmpty() ? "" : "+" + this.build);
    }

    private String vnum(int n) {
        return n < 0 ? "*" : String.valueOf(n);
    }
}

