/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.parser.gtd.location;

public class PositionStore {
    private static final int LINE_FEED_CHAR = 10;
    private static final int CARRIAGE_RETURN_CHAR = 13;
    private static final int DEFAULT_SIZE = 8;
    private int[] offsets = new int[8];
    private int endOfFile;
    private int size;
    private int cursor;

    public void enlarge() {
        int[] oldOffsets = this.offsets;
        this.offsets = new int[this.size << 1];
        System.arraycopy(oldOffsets, 0, this.offsets, 0, this.size);
    }

    public void index(int[] input) {
        this.add(0);
        this.endOfFile = input.length;
        boolean encounteredCarriageReturn = false;
        for (int i = 0; i < this.endOfFile; ++i) {
            int character = input[i];
            if (character == 13) {
                encounteredCarriageReturn = true;
                continue;
            }
            if (character == 10) {
                this.add(i + 1);
                encounteredCarriageReturn = false;
                continue;
            }
            if (!encounteredCarriageReturn) continue;
            this.add(i);
            encounteredCarriageReturn = false;
        }
    }

    private void add(int offset) {
        if (this.size == this.offsets.length) {
            this.enlarge();
        }
        this.offsets[this.size++] = offset;
    }

    public void resetCursor() {
        this.cursor = 0;
    }

    public void setCursorTo(int index) {
        this.cursor = index;
    }

    public int findLine(int offset) {
        int line = this.cursor;
        if (this.offsets[line] <= offset) {
            ++line;
            while (line < this.size && this.offsets[line] <= offset) {
                ++line;
            }
            this.cursor = line - 1;
        } else {
            while (line > 0 && this.offsets[line] > offset) {
                --line;
            }
            this.cursor = line;
        }
        return this.cursor;
    }

    public int getColumn(int offset, int line) {
        return offset - this.offsets[line];
    }

    public boolean startsLine(int offset) {
        return this.isAtColumn(offset, 0);
    }

    public boolean endsLine(int offset) {
        return offset == this.endOfFile || this.isAtColumn(offset + 1, 0);
    }

    public boolean isAtColumn(int offset, int column) {
        return offset - this.offsets[this.findLine(offset)] == column;
    }

    public void clear() {
        int length = this.offsets.length;
        this.offsets = new int[length];
        this.size = 0;
    }

    public void dirtyClear() {
        this.size = 0;
    }
}

