/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.parser.gtd.stack.filter.match;

import org.rascalmpl.parser.gtd.location.PositionStore;
import org.rascalmpl.parser.gtd.stack.filter.ICompletionFilter;

public class StringMatchRestriction
implements ICompletionFilter {
    private final int[] string;

    public StringMatchRestriction(int[] string) {
        this.string = string;
    }

    @Override
    public boolean isFiltered(int[] input, int start, int end, PositionStore positionStore) {
        if (end - start != this.string.length) {
            return false;
        }
        for (int i = this.string.length - 1; i >= 0; --i) {
            if (input[start + i] == this.string[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEqual(ICompletionFilter otherCompletionFilter) {
        if (!(otherCompletionFilter instanceof StringMatchRestriction)) {
            return false;
        }
        StringMatchRestriction otherStringMatchFilter = (StringMatchRestriction)otherCompletionFilter;
        int[] otherString = otherStringMatchFilter.string;
        if (this.string.length != otherString.length) {
            return false;
        }
        for (int i = this.string.length - 1; i >= 0; --i) {
            if (this.string[i] == otherString[i]) continue;
            return false;
        }
        return true;
    }
}

