/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.uri.zip;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.util.zip.ZipEntry;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.rascalmpl.uri.fs.FSEntry;

public class IndexedFSEntry
extends FSEntry {
    final int offset;

    public IndexedFSEntry(long created, long lastModified, int offset, long size) {
        super(created, lastModified, size);
        this.offset = offset;
    }

    public IndexedFSEntry(@Nullable FileTime created, long lastModified, int offset, long size) {
        this(created == null ? lastModified : created.toMillis(), lastModified, offset, size);
    }

    public IndexedFSEntry(long created, long lastModified, long size) {
        this(created, lastModified, -1, size);
    }

    public IndexedFSEntry(FSEntry e) {
        this(e.getCreated(), e.getLastModified(), e.getSize());
    }

    public IndexedFSEntry(ZipEntry ze, int offset) {
        this(ze.getCreationTime(), ze.getTime(), offset, ze.getSize());
    }

    public static IndexedFSEntry forFile(File file) {
        return IndexedFSEntry.forFile(file.toPath());
    }

    public static IndexedFSEntry forFile(Path file) {
        return new IndexedFSEntry(FSEntry.forFile(file));
    }
}

