/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.util.base64;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Base64;
import org.rascalmpl.util.base64.ByteReader;

public class Base64DecodingInputStream
extends InputStream {
    private static final int DEC_INPUT_SIZE = 4096;
    private static final int DEC_OUTPUT_SIZE = 3072;
    private final Base64.Decoder decoder = Base64.getDecoder();
    private final ByteReader source;
    private final byte[] buffer = new byte[3072];
    private int consumed = 0;
    private int limit = 0;
    private boolean lastBlock = false;

    public Base64DecodingInputStream(ByteReader source) {
        this.source = source;
    }

    @Override
    public int available() throws IOException {
        if (this.consumed == this.limit && !this.lastBlock) {
            byte[] readBuffer = new byte[4096];
            int read = this.source.fillBuffer(readBuffer);
            if (read != readBuffer.length) {
                this.lastBlock = true;
                if (read == -1) {
                    read = 0;
                } else {
                    readBuffer = Arrays.copyOf(readBuffer, read);
                }
            }
            this.limit = read > 0 ? this.decoder.decode(readBuffer, this.buffer) : 0;
            this.consumed = 0;
        }
        return this.limit - this.consumed;
    }

    @Override
    public int read() throws IOException {
        if (this.available() == 0) {
            return -1;
        }
        return Byte.toUnsignedInt(this.buffer[this.consumed++]);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int remaining = this.available();
        if (remaining == 0) {
            return -1;
        }
        int toRead = Math.min(remaining, len);
        System.arraycopy(this.buffer, this.consumed, b, off, toRead);
        this.consumed += toRead;
        return toRead;
    }

    @Override
    public void close() throws IOException {
        this.source.close();
    }

    public static void direct(ByteReader source, OutputStream target) throws IOException {
        int read;
        Base64.Decoder decoder = Base64.getDecoder();
        byte[] inputBuffer = new byte[4096];
        byte[] outputBuffer = new byte[3072];
        do {
            if ((read = source.fillBuffer(inputBuffer)) == -1) {
                return;
            }
            if (read != inputBuffer.length) {
                inputBuffer = Arrays.copyOf(inputBuffer, read);
            }
            int toWrite = decoder.decode(inputBuffer, outputBuffer);
            target.write(outputBuffer, 0, toWrite);
        } while (read == inputBuffer.length);
    }
}

