/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.util.base64;

import java.io.IOException;
import java.io.Reader;

@FunctionalInterface
public interface ByteReader
extends AutoCloseable {
    public int fillBuffer(byte[] var1) throws IOException;

    @Override
    default public void close() throws IOException {
    }

    public static ByteReader fromLatin(final String source) {
        return new ByteReader(){
            int pos = 0;

            @Override
            public int fillBuffer(byte[] buffer) {
                if (this.pos == source.length()) {
                    return -1;
                }
                int toWrite = Math.min(buffer.length, source.length() - this.pos);
                for (int i = 0; i < toWrite; ++i) {
                    buffer[i] = (byte)(source.charAt(i + this.pos) & 0xFF);
                }
                this.pos += toWrite;
                return toWrite;
            }
        };
    }

    public static ByteReader fromLatin(final Reader source) {
        final char[] intermediateBuffer = new char[4096];
        return new ByteReader(){

            @Override
            public int fillBuffer(byte[] buffer) throws IOException {
                int toRead;
                int read;
                int filled = 0;
                int remaining = buffer.length;
                while (filled < buffer.length && (read = source.read(intermediateBuffer, 0, toRead = Math.min(remaining, intermediateBuffer.length))) != -1) {
                    for (int i = 0; i < read; ++i) {
                        buffer[filled + i] = (byte)(intermediateBuffer[i] & 0xFF);
                    }
                    filled += read;
                    remaining -= read;
                }
                if (filled == 0) {
                    return -1;
                }
                return filled;
            }
        };
    }

    public static ByteReader fromBytes(final byte[] source) {
        return new ByteReader(){
            int pos = 0;

            @Override
            public int fillBuffer(byte[] buffer) throws IOException {
                if (this.pos == source.length) {
                    return -1;
                }
                int toRead = Math.min(source.length - this.pos, buffer.length);
                System.arraycopy(source, this.pos, buffer, 0, toRead);
                this.pos += toRead;
                return toRead;
            }
        };
    }
}

