/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.util.maven;

import java.net.http.HttpClient;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.repository.metadata.Metadata;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Repository;
import org.apache.maven.model.building.FileModelSource;
import org.apache.maven.model.building.ModelSource;
import org.apache.maven.model.resolution.InvalidRepositoryException;
import org.apache.maven.model.resolution.ModelResolver;
import org.apache.maven.model.resolution.UnresolvableModelException;
import org.apache.maven.settings.Mirror;
import org.apache.maven.settings.Server;
import org.rascalmpl.util.maven.ArtifactCoordinate;
import org.rascalmpl.util.maven.MirrorRepo;
import org.rascalmpl.util.maven.Repo;
import org.rascalmpl.util.maven.RepositoryDownloader;
import org.rascalmpl.util.maven.RepositoryDownloaderFactory;

class SimpleResolver
implements ModelResolver {
    private static final String MAVEN_CENTRAL_ID = "central";
    private static final String MAVEN_CENTRAL_URL = "https://repo.maven.apache.org/maven2";
    private static RepositoryDownloaderFactory downloaderFactory;
    private final List<RepositoryDownloader> availableRepostories = new ArrayList<RepositoryDownloader>();
    private final Path rootRepository;
    private final HttpClient client;
    private final Map<String, Mirror> mirrors;
    private final Map<String, Server> servers;
    private final SimpleResolver parentResolver;

    public static SimpleResolver createRootResolver(Path rootRepository, HttpClient client, Map<String, Mirror> mirrors, Map<String, Server> servers) {
        SimpleResolver rootResolver = new SimpleResolver(rootRepository, client, mirrors, servers, null);
        Repository repo = new Repository();
        repo.setId(MAVEN_CENTRAL_ID);
        repo.setUrl(MAVEN_CENTRAL_URL);
        try {
            rootResolver.addRepository(repo);
            return rootResolver;
        }
        catch (InvalidRepositoryException e) {
            throw new RuntimeException("Invalid repository: " + repo.getId() + " at " + repo.getUrl(), e);
        }
    }

    private SimpleResolver(Path rootRepository, HttpClient client, Map<String, Mirror> mirrors, Map<String, Server> servers, SimpleResolver parentResolver) {
        this.rootRepository = rootRepository;
        this.client = client;
        this.mirrors = Map.copyOf(mirrors);
        this.servers = Map.copyOf(servers);
        downloaderFactory = new RepositoryDownloaderFactory(client);
        this.parentResolver = parentResolver;
    }

    public SimpleResolver createChildResolver() {
        return new SimpleResolver(this.rootRepository, this.client, this.mirrors, this.servers, this);
    }

    public Path calculatePomPath(ArtifactCoordinate coordinate) {
        return this.calculatePomPath(coordinate.getGroupId(), coordinate.getArtifactId(), coordinate.getVersion());
    }

    public Path calculatePomPath(String groupId, String artifactId, String version) {
        Path result = this.rootRepository;
        for (String path : groupId.split("\\.")) {
            result = result.resolve(path);
        }
        result = result.resolve(artifactId);
        result = result.resolve(version);
        return result.resolve(String.format("%s-%s.pom", artifactId, version));
    }

    private Path calculateJarPath(ArtifactCoordinate coordinate) {
        return this.calculateJarPath(coordinate.getGroupId(), coordinate.getArtifactId(), coordinate.getVersion(), coordinate.getClassifier());
    }

    private Path calculateJarPath(String groupId, String artifactId, String version, String classifier) {
        Path pomLocation = this.calculatePomPath(groupId, artifactId, version);
        String fileName = artifactId + "-" + version;
        if (!classifier.isEmpty()) {
            fileName = fileName + "-" + classifier;
        }
        return pomLocation.resolveSibling(fileName + ".jar");
    }

    private Path calculateMetadataPath(String groupId, String artifactId) {
        Path result = this.rootRepository;
        for (String path : groupId.split("\\.")) {
            result = result.resolve(path);
        }
        result = result.resolve(artifactId);
        return result.resolve("maven-metadata.xml");
    }

    private Metadata downloadArtifactMetadata(String groupId, String artifactId, String versionSpec) throws UnresolvableModelException {
        Path metadataPath = this.calculateMetadataPath(groupId, artifactId);
        String url = String.format("/%s/%s/%s", groupId.replace('.', '/'), artifactId, metadataPath.getFileName().toString());
        for (RepositoryDownloader repoDownloader : this.availableRepostories) {
            Metadata metadata;
            if (repoDownloader.getRepo().getLayout().equals("legacy") || (metadata = repoDownloader.downloadMetadata(url, metadataPath)) == null) continue;
            return metadata;
        }
        if (this.parentResolver != null) {
            return this.parentResolver.downloadArtifactMetadata(groupId, artifactId, versionSpec);
        }
        throw new UnresolvableModelException("Could not download artifact metadata from available repositories", groupId, artifactId, versionSpec);
    }

    public String findLatestMatchingVersion(String groupId, String artifactId, String versionSpec) throws UnresolvableModelException {
        Metadata metadata = this.downloadArtifactMetadata(groupId, artifactId, versionSpec);
        try {
            VersionRange versionRange = VersionRange.createFromVersionSpec(versionSpec);
            return metadata.getVersioning().getVersions().stream().map(version -> new DefaultArtifactVersion((String)version)).filter(version -> versionRange.containsVersion((ArtifactVersion)version)).max((v1, v2) -> v1.compareTo((ArtifactVersion)v2)).orElseThrow(() -> new UnresolvableModelException("No version found in range", groupId, artifactId, versionSpec)).toString();
        }
        catch (InvalidVersionSpecificationException e) {
            throw new UnresolvableModelException("Invalid version range specification", groupId, artifactId, versionSpec, e);
        }
    }

    @Override
    public ModelSource resolveModel(String groupId, String artifactId, String version) throws UnresolvableModelException {
        Path local = this.calculatePomPath(groupId, artifactId, version);
        if (!Files.exists(local, new LinkOption[0])) {
            this.downloadPom(local, groupId, artifactId, version);
        }
        return new FileModelSource(local.toFile());
    }

    @Override
    public ModelSource resolveModel(Parent parent) throws UnresolvableModelException {
        return this.resolveModel(parent.getGroupId(), parent.getArtifactId(), parent.getVersion());
    }

    @Override
    public ModelSource resolveModel(Dependency dependency) throws UnresolvableModelException {
        return this.resolveModel(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion());
    }

    public ModelSource resolveModel(ArtifactCoordinate coordinate) throws UnresolvableModelException {
        return this.resolveModel(coordinate.getGroupId(), coordinate.getArtifactId(), coordinate.getVersion());
    }

    @Override
    public void addRepository(Repository repository) throws InvalidRepositoryException {
        this.addRepository(repository, false);
    }

    @Override
    public void addRepository(Repository repository, boolean replace) throws InvalidRepositoryException {
        Mirror mirror;
        if (replace) {
            this.availableRepostories.removeIf(r -> r.getRepo().getId().equals(repository.getId()));
        }
        Repo repo = (mirror = this.mirrors.get(repository.getId())) == null ? new Repo(repository) : new MirrorRepo(mirror, repository);
        this.availableRepostories.add(downloaderFactory.createDownloader(repo, this.servers.get(repo.getId())));
    }

    public void addDownloaders(SimpleResolver originalResolver) {
        for (RepositoryDownloader downloader : originalResolver.availableRepostories) {
            this.availableRepostories.add(downloader);
        }
    }

    @Override
    public ModelResolver newCopy() {
        SimpleResolver result = new SimpleResolver(this.rootRepository, this.client, this.mirrors, this.servers, this.parentResolver);
        result.availableRepostories.addAll(this.availableRepostories);
        return result;
    }

    private void downloadPom(Path local, String groupId, String artifactId, String version) throws UnresolvableModelException {
        if (version.endsWith("-SNAPSHOT")) {
            throw new UnresolvableModelException("No downloading & updating logic of SNAPSHOTs yet", groupId, artifactId, version);
        }
        this.downloadArtifact(local, groupId, artifactId, version, false);
    }

    private void downloadJar(Path local, String groupId, String artifactId, String version) throws UnresolvableModelException {
        if (version.endsWith("-SNAPSHOT")) {
            throw new UnresolvableModelException("No downloading & updating logic of SNAPSHOTs yet", groupId, artifactId, version);
        }
        this.downloadArtifact(local, groupId, artifactId, version, false);
    }

    private void downloadArtifact(Path local, String groupId, String artifactId, String version, boolean force) throws UnresolvableModelException {
        String url = this.getUrl(local, groupId, artifactId, version);
        for (RepositoryDownloader repoDownloader : this.availableRepostories) {
            if (repoDownloader.getRepo().getLayout().equals("legacy") || !repoDownloader.download(url, local, force)) continue;
            return;
        }
        if (this.parentResolver != null) {
            this.parentResolver.downloadArtifact(local, groupId, artifactId, version, force);
            return;
        }
        throw new UnresolvableModelException("Could not download artifact from available repositories", groupId, artifactId, version);
    }

    private String getUrl(Path local, String groupId, String artifactId, String version) {
        return String.format("/%s/%s/%s/%s", groupId.replace('.', '/'), artifactId, version, local.getFileName().toString());
    }

    public Path resolveJar(ArtifactCoordinate coordinate) throws UnresolvableModelException {
        Path jarPath = this.calculateJarPath(coordinate);
        if (Files.notExists(jarPath, new LinkOption[0])) {
            this.downloadJar(jarPath, coordinate.getGroupId(), coordinate.getArtifactId(), coordinate.getVersion());
        }
        return jarPath;
    }
}

