/*
 * Decompiled with CFR 0.152.
 */
package engineering.swat.watch.impl.mac;

import engineering.swat.watch.impl.mac.NativeEventHandler;
import engineering.swat.watch.impl.mac.NativeLibrary;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.Path;

class NativeEventStream
implements Closeable {
    private final Path path;
    private final NativeEventHandler handler;
    private volatile boolean closed;
    private volatile long nativeWatch;

    public NativeEventStream(Path path, NativeEventHandler handler) throws IOException {
        this.path = path.toRealPath(new LinkOption[0]);
        this.handler = handler;
        this.closed = true;
    }

    public synchronized void open() {
        if (!this.closed) {
            return;
        }
        this.closed = false;
        this.nativeWatch = NativeLibrary.start(this.path.toString(), this.handler);
    }

    @Override
    public synchronized void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        NativeLibrary.stop(this.nativeWatch);
    }

    static {
        NativeLibrary.load();
    }
}

