/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.ast;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.ISourceLocation;
import java.util.List;
import org.rascalmpl.ast.AbstractAST;
import org.rascalmpl.ast.IASTVisitor;
import org.rascalmpl.ast.KeywordFormal;
import org.rascalmpl.ast.OptionalComma;

public abstract class KeywordFormals
extends AbstractAST {
    public KeywordFormals(ISourceLocation src, IConstructor node) {
        super(src);
    }

    public boolean hasKeywordFormalList() {
        return false;
    }

    public List<KeywordFormal> getKeywordFormalList() {
        throw new UnsupportedOperationException(this.src.toString());
    }

    public boolean hasOptionalComma() {
        return false;
    }

    public OptionalComma getOptionalComma() {
        throw new UnsupportedOperationException(this.src.toString());
    }

    public boolean isDefault() {
        return false;
    }

    public boolean isNone() {
        return false;
    }

    public static class None
    extends KeywordFormals {
        public None(ISourceLocation src, IConstructor node) {
            super(src, node);
        }

        @Override
        public boolean isNone() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitKeywordFormalsNone(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof None)) {
                return false;
            }
            None tmp = (None)o;
            return true;
        }

        @Override
        public int hashCode() {
            return 631;
        }

        @Override
        public Object clone() {
            return None.newInstance(this.getClass(), this.src, null);
        }
    }

    public static class Default
    extends KeywordFormals {
        private final OptionalComma optionalComma;
        private final List<KeywordFormal> keywordFormalList;

        public Default(ISourceLocation src, IConstructor node, OptionalComma optionalComma, List<KeywordFormal> keywordFormalList) {
            super(src, node);
            this.optionalComma = optionalComma;
            this.keywordFormalList = keywordFormalList;
        }

        @Override
        public boolean isDefault() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitKeywordFormalsDefault(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.optionalComma.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.optionalComma.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            for (AbstractAST abstractAST : this.keywordFormalList) {
                $l = abstractAST.getLocation();
                if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                    abstractAST.addForLineNumber($line, $result);
                }
                if ($l.getBeginLine() <= $line) continue;
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Default)) {
                return false;
            }
            Default tmp = (Default)o;
            return tmp.optionalComma.equals(this.optionalComma) && tmp.keywordFormalList.equals(this.keywordFormalList);
        }

        @Override
        public int hashCode() {
            return 941 + 307 * this.optionalComma.hashCode() + 941 * this.keywordFormalList.hashCode();
        }

        @Override
        public OptionalComma getOptionalComma() {
            return this.optionalComma;
        }

        @Override
        public boolean hasOptionalComma() {
            return true;
        }

        @Override
        public List<KeywordFormal> getKeywordFormalList() {
            return this.keywordFormalList;
        }

        @Override
        public boolean hasKeywordFormalList() {
            return true;
        }

        @Override
        public Object clone() {
            return Default.newInstance(this.getClass(), this.src, null, this.clone(this.optionalComma), this.clone(this.keywordFormalList));
        }
    }
}

