/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.dap.variable;

import io.usethesource.vallang.IValue;
import io.usethesource.vallang.type.Type;
import org.rascalmpl.dap.variable.RascalVariableUtils;
import org.rascalmpl.ideservices.IDEServices;
import org.rascalmpl.values.RascalValueFactory;

public class RascalVariable {
    private int referenceID = -1;
    private final Type type;
    private final String name;
    private final IValue value;
    private final String displayValue;
    private int namedVariables = 0;
    private int indexedVariables = 0;

    public RascalVariable(Type type, String name, IValue value, IDEServices services) {
        this.type = type;
        this.name = name;
        this.value = value;
        this.displayValue = RascalVariableUtils.getDisplayString(value, services);
    }

    public void setNamedVariables(int namedVariables) {
        this.namedVariables = namedVariables;
    }

    public void setIndexedVariables(int indexedVariables) {
        this.indexedVariables = indexedVariables;
    }

    public int getReferenceID() {
        return this.referenceID;
    }

    public Type getType() {
        return this.type;
    }

    public void setReferenceID(int referenceID) {
        this.referenceID = referenceID;
    }

    public String getName() {
        return this.name;
    }

    public IValue getValue() {
        return this.value;
    }

    public String getDisplayValue() {
        return this.displayValue;
    }

    public boolean hasSubFields() {
        if (this.type == null) {
            return false;
        }
        return this.type.isList() || this.type.isMap() || this.type.isSet() || this.type.isAliased() || this.type.isNode() || this.type.isConstructor() || this.type.isRelation() || this.type.isTuple() || this.type.isDateTime() || this.type.isExternalType() && this.type.equals(RascalValueFactory.Tree);
    }

    public int getNamedVariables() {
        return this.namedVariables;
    }

    public int getIndexedVariables() {
        return this.indexedVariables;
    }
}

