/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.interpreter.result;

import io.usethesource.vallang.IBool;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.type.Type;
import java.util.Iterator;
import org.rascalmpl.interpreter.IEvaluatorContext;
import org.rascalmpl.interpreter.result.ElementResult;
import org.rascalmpl.interpreter.result.LessThanOrEqualResult;
import org.rascalmpl.interpreter.result.ListRelationResult;
import org.rascalmpl.interpreter.result.RelationResult;
import org.rascalmpl.interpreter.result.Result;
import org.rascalmpl.interpreter.result.ResultFactory;

public class BoolResult
extends ElementResult<IBool> {
    public BoolResult(Type type, IBool bool, IEvaluatorContext ctx) {
        this(type, bool, (Iterator<Result<IValue>>)null, ctx);
    }

    public BoolResult(Type type, IBool bool, Iterator<Result<IValue>> iter, IEvaluatorContext ctx) {
        super(type, bool, iter, ctx);
    }

    @Override
    public <V extends IValue> Result<IBool> equals(Result<V> that) {
        return that.equalToBool(this);
    }

    @Override
    public <V extends IValue> Result<IBool> nonEquals(Result<V> that) {
        return that.nonEqualToBool(this);
    }

    @Override
    public <V extends IValue> Result<IBool> lessThan(Result<V> result) {
        return result.lessThanBool(this);
    }

    @Override
    public <V extends IValue> LessThanOrEqualResult lessThanOrEqual(Result<V> result) {
        return result.lessThanOrEqualBool(this);
    }

    @Override
    public <V extends IValue> Result<IBool> greaterThan(Result<V> result) {
        return result.greaterThanBool(this);
    }

    @Override
    public <V extends IValue> Result<IBool> greaterThanOrEqual(Result<V> result) {
        return result.greaterThanOrEqualBool(this);
    }

    @Override
    public Result<IBool> negate() {
        return ResultFactory.bool(((IBool)this.getValue()).not().getValue(), this.ctx);
    }

    @Override
    public Result<IValue> ifThenElse(Result<IValue> then, Result<IValue> _else) {
        if (this.isTrue()) {
            return then;
        }
        return _else;
    }

    @Override
    protected Result<IBool> equalToBool(BoolResult that) {
        return that.equalityBoolean(this);
    }

    @Override
    protected Result<IBool> nonEqualToBool(BoolResult that) {
        return that.nonEqualityBoolean(this);
    }

    @Override
    protected LessThanOrEqualResult lessThanOrEqualBool(BoolResult that) {
        if (that.isTrue()) {
            return new LessThanOrEqualResult(false, this.isTrue(), this.ctx);
        }
        return new LessThanOrEqualResult(this.isTrue(), !this.isTrue(), this.ctx);
    }

    @Override
    protected Result<IBool> lessThanBool(BoolResult that) {
        return ResultFactory.bool(!that.isTrue() && this.isTrue(), this.ctx);
    }

    @Override
    protected Result<IBool> greaterThanBool(BoolResult that) {
        return that.lessThanBool(this);
    }

    @Override
    protected Result<IBool> greaterThanOrEqualBool(BoolResult that) {
        LessThanOrEqualResult r = that.lessThanOrEqualBool(this);
        return r;
    }

    @Override
    public boolean isTrue() {
        return ((IBool)this.getValue()).getValue();
    }

    @Override
    protected <U extends IValue> Result<U> addListRelation(ListRelationResult that) {
        return that.addBool(this);
    }

    @Override
    protected <U extends IValue> Result<U> addRelation(RelationResult that) {
        return that.addBool(this);
    }
}

