/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.interpreter.result;

import io.usethesource.vallang.IBool;
import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IInteger;
import io.usethesource.vallang.IList;
import io.usethesource.vallang.ISet;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeStore;
import org.rascalmpl.ast.Name;
import org.rascalmpl.exceptions.RuntimeExceptionFactory;
import org.rascalmpl.exceptions.Throw;
import org.rascalmpl.interpreter.IEvaluatorContext;
import org.rascalmpl.interpreter.result.ConstructorResult;
import org.rascalmpl.interpreter.result.ListResult;
import org.rascalmpl.interpreter.result.Result;
import org.rascalmpl.interpreter.result.ResultFactory;
import org.rascalmpl.interpreter.result.StringResult;
import org.rascalmpl.interpreter.staticErrors.UnexpectedType;
import org.rascalmpl.interpreter.staticErrors.UnsupportedOperation;
import org.rascalmpl.interpreter.utils.Names;
import org.rascalmpl.types.RascalTypeFactory;
import org.rascalmpl.values.RascalValueFactory;
import org.rascalmpl.values.parsetrees.ITree;
import org.rascalmpl.values.parsetrees.ProductionAdapter;
import org.rascalmpl.values.parsetrees.SymbolAdapter;
import org.rascalmpl.values.parsetrees.TreeAdapter;

public class ConcreteSyntaxResult
extends ConstructorResult {
    public ConcreteSyntaxResult(Type type, IConstructor cons, IEvaluatorContext ctx) {
        super(type, cons, ctx);
    }

    @Override
    public Result<IBool> is(Name name) {
        String consName;
        ITree tree = (ITree)this.getValue();
        if (TreeAdapter.isAppl(tree) && !TreeAdapter.isError(tree) && (consName = TreeAdapter.getConstructorName((ITree)this.getValue())) != null) {
            return ResultFactory.bool(Names.name(name).equals(consName), this.ctx);
        }
        return ResultFactory.bool(false, this.ctx);
    }

    @Override
    public <U extends IValue, V extends IValue> Result<U> subscript(Result<?>[] subscripts) {
        ITree t2 = (ITree)this.getValue();
        if (TreeAdapter.isList(t2)) {
            return new ListResult(this.getTypeFactory().listType(RascalValueFactory.Tree), TreeAdapter.getListASTArgs(t2), this.ctx).subscript(subscripts);
        }
        try {
            return new ListResult(this.getTypeFactory().listType(RascalValueFactory.Tree), TreeAdapter.getASTArgs(t2), this.ctx).subscript(subscripts);
        }
        catch (Throw e) {
            if (TreeAdapter.isError(t2)) {
                IConstructor prod = ProductionAdapter.getErrorProduction(TreeAdapter.getProduction(t2));
                int arity = ProductionAdapter.getAstArgCount(prod);
                int index = ((IInteger)subscripts[0].getValue()).intValue();
                if (index < arity) {
                    throw RuntimeExceptionFactory.parseErrorRecovery(e.getException(), TreeAdapter.getLocation(t2));
                }
            }
            throw e;
        }
    }

    @Override
    public <U extends IValue> Result<U> fieldAccess(String name, TypeStore store) {
        ITree tree = (ITree)this.getValue();
        TreeAdapter.FieldResult field = TreeAdapter.getLabeledField(tree, name);
        if (field == null) {
            return new ConstructorResult(RascalValueFactory.Tree, tree, this.ctx).fieldAccess(name, store);
        }
        Type symbolType = RascalTypeFactory.getInstance().nonTerminalType(field.symbol);
        return ResultFactory.makeResult(symbolType, field.tree, this.ctx);
    }

    @Override
    public <U extends IValue, V extends IValue> Result<U> fieldUpdate(String name, Result<V> repl, TypeStore store) {
        ITree tree = (ITree)this.getValue();
        TreeAdapter.FieldResult field = TreeAdapter.getLabeledField(tree, name);
        if (field != null) {
            Type symbolType = RascalTypeFactory.getInstance().nonTerminalType(field.symbol);
            if (!repl.getStaticType().isSubtypeOf(symbolType)) {
                throw new UnexpectedType(symbolType, repl.getStaticType(), this.ctx.getCurrentAST());
            }
            ITree result = TreeAdapter.putLabeledField(tree, name, (ITree)repl.getValue());
            if (result != null) {
                return ResultFactory.makeResult(result.getType(), result, this.ctx);
            }
        }
        if (TreeAdapter.isAppl(tree)) {
            if (RascalValueFactory.Tree_Appl.hasField(name)) {
                Type fieldType = RascalValueFactory.Tree_Appl.getFieldType(name);
                if (repl.getStaticType().isSubtypeOf(fieldType)) {
                    throw new UnsupportedOperation("changing " + name + " in concrete tree", this.ctx.getCurrentAST());
                }
                throw new UnexpectedType(fieldType, repl.getStaticType(), this.ctx.getCurrentAST());
            }
            if (this.ctx.getCurrentEnvt().getStore().getKeywordParameterType(RascalValueFactory.Tree, name) != null) {
                if (this.getValue().mayHaveKeywordParameters()) {
                    return ResultFactory.makeResult(this.getStaticType(), this.getValue().asWithKeywordParameters().setParameter(name, (IValue)repl.getValue()), this.ctx);
                }
                throw RuntimeExceptionFactory.illegalArgument(this.getValueFactory().string("Can not set a keyword parameter on a tree which already has annotations"), this.ctx.getCurrentAST(), this.ctx.getStackTrace());
            }
            throw RuntimeExceptionFactory.noSuchField(name, this.ctx.getCurrentAST(), this.ctx.getStackTrace());
        }
        return super.fieldUpdate(name, repl, store);
    }

    private static boolean hasField(IConstructor prod, Name field) {
        IList syms = ProductionAdapter.getSymbols(prod);
        if (syms == null) {
            return false;
        }
        int index = SymbolAdapter.indexOfLabel(syms, Names.name(field));
        return index >= 0;
    }

    private static boolean errorHasFieldBeforeDot(IConstructor errorProd, Name field) {
        int dot = ProductionAdapter.getErrorDot(errorProd);
        IList syms = ProductionAdapter.getSymbols(ProductionAdapter.getErrorProduction(errorProd));
        int index = SymbolAdapter.indexOfLabel(syms, Names.name(field));
        return index >= 0 && index < dot;
    }

    @Override
    public Result<IBool> has(Name name) {
        int index;
        IConstructor prod;
        if (TreeAdapter.isAppl((ITree)this.getValue()) && (ProductionAdapter.isDefault(prod = TreeAdapter.getProduction((ITree)this.getValue())) ? (index = SymbolAdapter.indexOfLabel(ProductionAdapter.getSymbols(prod), Names.name(name))) >= 0 : ProductionAdapter.isError(prod) && ConcreteSyntaxResult.errorHasFieldBeforeDot(prod, name))) {
            return ResultFactory.bool(true, this.ctx);
        }
        return super.has(name);
    }

    @Override
    public Result<IBool> isDefined(Name name) {
        IConstructor prod;
        if (TreeAdapter.isAppl((ITree)this.getValue()) && (ProductionAdapter.isError(prod = TreeAdapter.getProduction((ITree)this.getValue())) ? ConcreteSyntaxResult.errorHasFieldBeforeDot(prod, name) : ConcreteSyntaxResult.hasField(prod, name))) {
            return ResultFactory.bool(true, this.ctx);
        }
        return super.isDefined(name);
    }

    @Override
    public <V extends IValue> Result<IBool> equals(Result<V> that) {
        return that.equalToConcreteSyntax(this);
    }

    @Override
    public <V extends IValue> Result<IBool> nonEquals(Result<V> that) {
        return that.nonEqualToConcreteSyntax(this);
    }

    @Override
    protected Result<IBool> nonEqualToConcreteSyntax(ConcreteSyntaxResult that) {
        return this.equalToConcreteSyntax(that).negate();
    }

    @Override
    protected Result<IBool> equalToConcreteSyntax(ConcreteSyntaxResult that) {
        IConstructor leftCons = this.getValue();
        IConstructor rightCons = that.getValue();
        if (leftCons.mayHaveKeywordParameters() && !rightCons.mayHaveKeywordParameters() || !leftCons.mayHaveKeywordParameters() && rightCons.mayHaveKeywordParameters()) {
            return ResultFactory.bool(false, this.ctx);
        }
        if (leftCons.mayHaveKeywordParameters() && rightCons.mayHaveKeywordParameters() && !leftCons.asWithKeywordParameters().equalParameters(rightCons.asWithKeywordParameters())) {
            return ResultFactory.bool(false, this.ctx);
        }
        ITree left = this.getTreeWithoutKeywordParameters(leftCons);
        ITree right = this.getTreeWithoutKeywordParameters(rightCons);
        if (TreeAdapter.isLayout(left) && TreeAdapter.isLayout(right)) {
            return ResultFactory.bool(true, this.ctx);
        }
        if (TreeAdapter.isAppl(left) && TreeAdapter.isAppl(right)) {
            IConstructor p2;
            IConstructor p1 = TreeAdapter.getProduction(left);
            if (!p1.equals(p2 = TreeAdapter.getProduction(right))) {
                return ResultFactory.bool(false, this.ctx);
            }
            IList l1 = TreeAdapter.getArgs(left);
            IList l2 = TreeAdapter.getArgs(right);
            if (l1.length() != l2.length()) {
                return ResultFactory.bool(false, this.ctx);
            }
            for (int i = 0; i < l1.length(); ++i) {
                IValue kid1 = l1.get(i);
                IValue kid2 = l2.get(i);
                Result<IBool> result = ResultFactory.makeResult(kid1.getType(), kid1, this.ctx).equals(ResultFactory.makeResult(kid2.getType(), kid2, this.ctx));
                if (!result.getValue().getValue()) {
                    return ResultFactory.bool(false, this.ctx);
                }
                if (!TreeAdapter.isContextFree(left)) continue;
                ++i;
            }
            return ResultFactory.bool(true, this.ctx);
        }
        if (TreeAdapter.isChar(left) && TreeAdapter.isChar(right)) {
            return ResultFactory.bool(TreeAdapter.getCharacter(left) == TreeAdapter.getCharacter(right), this.ctx);
        }
        if (TreeAdapter.isAmb(left) && TreeAdapter.isAmb(right)) {
            ISet alts1 = TreeAdapter.getAlternatives(left);
            ISet alts2 = TreeAdapter.getAlternatives(right);
            if (alts1.size() != alts2.size()) {
                return ResultFactory.bool(false, this.ctx);
            }
            block1: for (IValue alt1 : alts1) {
                for (IValue alt2 : alts2) {
                    Result<IBool> result = ResultFactory.makeResult(alt1.getType(), alt1, this.ctx).equals(ResultFactory.makeResult(alt2.getType(), alt2, this.ctx));
                    if (!result.getValue().getValue()) continue;
                    continue block1;
                }
                return ResultFactory.bool(false, this.ctx);
            }
            return ResultFactory.bool(true, this.ctx);
        }
        if (TreeAdapter.isCycle(left) && TreeAdapter.isCycle(right)) {
            IConstructor type1 = TreeAdapter.getCycleType(left);
            IConstructor type2 = TreeAdapter.getCycleType(right);
            int length1 = TreeAdapter.getCycleLength(left);
            int length2 = TreeAdapter.getCycleLength(right);
            return ResultFactory.bool(type1.equals(type2) && length1 == length2, this.ctx);
        }
        return ResultFactory.bool(false, this.ctx);
    }

    private ITree getTreeWithoutKeywordParameters(IConstructor leftCons) {
        return (ITree)(leftCons.mayHaveKeywordParameters() && !leftCons.asWithKeywordParameters().getParameters().isEmpty() ? leftCons.asWithKeywordParameters().unsetAll() : leftCons);
    }

    @Override
    protected <U extends IValue> Result<U> addString(StringResult that) {
        return ResultFactory.makeResult(that.getStaticType(), that.getValue().concat(this.ctx.getValueFactory().string(TreeAdapter.yield(this.getValue()))), this.ctx);
    }

    @Override
    public String toString() {
        return super.toString() + "\n" + TreeAdapter.yield(this.getValue());
    }
}

