/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.interpreter.utils;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import org.rascalmpl.interpreter.utils.ClassLoaderImpl;
import org.rascalmpl.interpreter.utils.JavaCompiler;
import org.rascalmpl.interpreter.utils.JavaFileObjectImpl;

final class FileManagerImpl
extends ForwardingJavaFileManager<JavaFileManager> {
    private final ClassLoaderImpl classLoader;
    private final Map<URI, JavaFileObject> fileObjects = new HashMap<URI, JavaFileObject>();

    public FileManagerImpl(JavaFileManager fileManager, ClassLoaderImpl classLoader) {
        super(fileManager);
        this.classLoader = classLoader;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public Map<JavaFileObjectImpl, byte[]> getAllClassBytes() {
        HashMap<JavaFileObjectImpl, byte[]> result = new HashMap<JavaFileObjectImpl, byte[]>();
        for (JavaFileObjectImpl e : this.classLoader.files()) {
            if (e.getKind() != JavaFileObject.Kind.CLASS) continue;
            result.put(e, e.getByteCode());
        }
        return result;
    }

    @Override
    public FileObject getFileForInput(JavaFileManager.Location location, String packageName, String relativeName) throws IOException {
        FileObject o = this.fileObjects.get(this.uri(location, packageName, relativeName));
        if (o != null) {
            return o;
        }
        return super.getFileForInput(location, packageName, relativeName);
    }

    public void putFileForInput(StandardLocation location, String packageName, String relativeName, JavaFileObject file) {
        this.fileObjects.put(this.uri(location, packageName, relativeName), file);
    }

    private URI uri(JavaFileManager.Location location, String packageName, String relativeName) {
        return JavaCompiler.toURI(location.getName() + "/" + packageName + "/" + relativeName);
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String qualifiedName, JavaFileObject.Kind kind, FileObject outputFile) throws IOException {
        try {
            JavaFileObjectImpl file = new JavaFileObjectImpl(qualifiedName, kind);
            this.classLoader.add(qualifiedName, file);
            return file;
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    @Override
    public ClassLoader getClassLoader(JavaFileManager.Location location) {
        return this.classLoader;
    }

    @Override
    public String inferBinaryName(JavaFileManager.Location loc, JavaFileObject file) {
        String result = file instanceof JavaFileObjectImpl ? file.getName() : super.inferBinaryName(loc, file);
        return result;
    }

    @Override
    public Iterable<JavaFileObject> list(JavaFileManager.Location location, String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse) throws IOException {
        Iterable<JavaFileObject> result = super.list(location, packageName, kinds, recurse);
        ArrayList<JavaFileObject> files = new ArrayList<JavaFileObject>();
        if (location == StandardLocation.CLASS_PATH && kinds.contains((Object)JavaFileObject.Kind.CLASS)) {
            for (JavaFileObject file : this.fileObjects.values()) {
                if (file.getKind() != JavaFileObject.Kind.CLASS || !file.getName().startsWith(packageName)) continue;
                files.add(file);
            }
            files.addAll(this.classLoader.files());
        } else if (location == StandardLocation.SOURCE_PATH && kinds.contains((Object)JavaFileObject.Kind.SOURCE)) {
            for (JavaFileObject file : this.fileObjects.values()) {
                if (file.getKind() != JavaFileObject.Kind.SOURCE || !file.getName().startsWith(packageName)) continue;
                files.add(file);
            }
        }
        for (JavaFileObject file : result) {
            files.add(file);
        }
        return files;
    }
}

