/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.parser.gtd.util;

public class BitSet {
    public static final int OFF = 0;
    public static final int ON = 1;
    private static final int BLOCK_SHIFT = 5;
    private static final int BLOCK_MASK = 31;
    private int[] bits;

    public BitSet() {
        this.bits = new int[1];
    }

    public BitSet(int size) {
        int nrOfBlocks = (size >> 5) + ((size & 0x1F) != 0 ? 1 : 0);
        this.bits = new int[nrOfBlocks];
    }

    public void enlargeTo(int size) {
        int[] oldBits;
        int oldNrOfBlocks;
        int newNrOfBlocks = (size >> 5) + ((size & 0x1F) != 0 ? 1 : 0);
        if (newNrOfBlocks > (oldNrOfBlocks = (oldBits = this.bits).length)) {
            this.bits = new int[newNrOfBlocks];
            System.arraycopy(oldBits, 0, this.bits, 0, oldNrOfBlocks);
        }
    }

    public void set(int index) {
        int n = index >> 5;
        this.bits[n] = this.bits[n] | 1 << (index & 0x1F);
    }

    public void unset(int index) {
        int n = index >> 5;
        this.bits[n] = this.bits[n] & ~(1 << (index & 0x1F));
    }

    public void flip(int index) {
        int n = index >> 5;
        this.bits[n] = this.bits[n] ^ 1 << (index & 0x1F);
    }

    public void or(int index, int bit) {
        int n = index >> 5;
        this.bits[n] = this.bits[n] | bit << (index & 0x1F);
    }

    public void and(int index, int bit) {
        int n = index >> 5;
        this.bits[n] = this.bits[n] & bit << (index & 0x1F);
    }

    public void xor(int index, int bit) {
        int n = index >> 5;
        this.bits[n] = this.bits[n] ^ bit << (index & 0x1F);
    }

    public int get(int index) {
        return this.bits[index >> 5] >> (index & 0x1F) & 1;
    }

    public boolean isSet(int index) {
        return (this.bits[index >> 5] >> (index & 0x1F) & 1) == 1;
    }

    public void clear() {
        this.bits = new int[1];
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        sb.append(this.get(0));
        for (int i = 1; i < this.bits.length << 5; ++i) {
            sb.append(',');
            sb.append(this.get(i));
        }
        sb.append(']');
        return sb.toString();
    }
}

