/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.runtime;

import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.type.TypeFactory;
import io.usethesource.vallang.type.TypeStore;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.URISyntaxException;
import org.rascalmpl.debug.IRascalMonitor;
import org.rascalmpl.ideservices.BasicIDEServices;
import org.rascalmpl.ideservices.IDEServices;
import org.rascalmpl.interpreter.load.RascalSearchPath;
import org.rascalmpl.interpreter.load.SourceLocationListContributor;
import org.rascalmpl.interpreter.utils.RascalManifest;
import org.rascalmpl.library.util.PathConfig;
import org.rascalmpl.runtime.$RascalModule;
import org.rascalmpl.runtime.ModuleStore;
import org.rascalmpl.runtime.RascalRuntimeValueFactory;
import org.rascalmpl.runtime.traverse.Traverse;
import org.rascalmpl.types.RascalTypeFactory;
import org.rascalmpl.uri.URIResolverRegistry;
import org.rascalmpl.uri.URIUtil;
import org.rascalmpl.uri.project.ProjectURIResolver;
import org.rascalmpl.uri.project.TargetURIResolver;
import org.rascalmpl.values.IRascalValueFactory;

public class RascalExecutionContext
implements IRascalMonitor {
    private String currentModuleName = "UNDEFINED";
    private $RascalModule module;
    private final IRascalValueFactory $RVF;
    private final Reader inReader;
    private final PrintWriter outwriter;
    private final PrintWriter errwriter;
    private final PathConfig pcfg;
    private final IDEServices ideServices;
    private final Traverse $TRAVERSE;
    private final ModuleStore mstore;
    private final TypeStore $TS;
    private final TypeFactory $TF;
    private final RascalTypeFactory $RTF;
    private RascalSearchPath rascalSearchPath;

    public RascalExecutionContext(Reader inReader, PrintWriter outwriter, PrintWriter errwriter, PathConfig pcfg, IDEServices ideServices, Class<?> clazz) {
        this.inReader = inReader;
        this.outwriter = outwriter;
        this.errwriter = errwriter;
        this.pcfg = pcfg == null ? new PathConfig() : pcfg;
        ISourceLocation projectRoot = RascalExecutionContext.inferProjectRoot(clazz);
        this.ideServices = ideServices == null ? new BasicIDEServices(errwriter, this, null, projectRoot) : ideServices;
        this.$RVF = new RascalRuntimeValueFactory(this);
        this.$TF = TypeFactory.getInstance();
        this.$RTF = RascalTypeFactory.getInstance();
        this.$TRAVERSE = new Traverse(this.$RVF);
        this.mstore = new ModuleStore();
        this.$TS = new TypeStore(new TypeStore[0]);
        this.rascalSearchPath = new RascalSearchPath();
        URIResolverRegistry reg = URIResolverRegistry.getInstance();
        String projectName = new RascalManifest().getProjectName(projectRoot);
        if (!projectName.isEmpty()) {
            reg.registerLogical(new ProjectURIResolver(projectRoot, projectName));
            reg.registerLogical(new TargetURIResolver(projectRoot, projectName));
        }
        String projectPath = projectRoot.getPath();
        String projectsDirPath = projectPath.substring(0, projectPath.length() - projectName.length() - 1);
        try {
            ISourceLocation projectsDir = this.$RVF.sourceLocation(projectRoot.getScheme(), projectRoot.getAuthority(), projectsDirPath);
            String[] entries = URIResolverRegistry.getInstance().listEntries(projectsDir);
            if (entries != null) {
                for (String entryName : entries) {
                    if (entryName.charAt(0) == '.' || entryName.equals("pom-parent") || entryName.equals("bin") || entryName.equals("src") || entryName.equals("META-INF")) continue;
                    ISourceLocation entryRoot = this.$RVF.sourceLocation(projectsDir.getScheme(), projectsDir.getAuthority(), projectsDir.getPath() + "/" + entryName);
                    if (!URIResolverRegistry.getInstance().isDirectory(entryRoot)) continue;
                    reg.registerLogical(new ProjectURIResolver(entryRoot, entryName));
                    reg.registerLogical(new TargetURIResolver(entryRoot, entryName));
                    this.rascalSearchPath.addPathContributor(new SourceLocationListContributor(entryName, this.$RVF.list(entryRoot)));
                }
            }
        }
        catch (IOException e) {
            return;
        }
        catch (URISyntaxException e) {
            return;
        }
    }

    IRascalValueFactory getRascalRuntimeValueFactory() {
        return this.$RVF;
    }

    public Traverse getTraverse() {
        return this.$TRAVERSE;
    }

    public Reader getInReader() {
        return this.inReader;
    }

    public PrintWriter getOutWriter() {
        return this.outwriter;
    }

    public PrintWriter getErrWriter() {
        return this.errwriter;
    }

    public PathConfig getPathConfig() {
        return this.pcfg;
    }

    public void setModule($RascalModule module) {
        this.module = module;
    }

    public $RascalModule getModule() {
        return this.module;
    }

    public String getFullModuleName() {
        return this.currentModuleName;
    }

    public String getFullModuleNameAsPath() {
        return this.currentModuleName.replaceAll("::", "/") + ".rsc";
    }

    public void setFullModuleName(String moduleName) {
        this.currentModuleName = moduleName;
    }

    public ModuleStore getModuleStore() {
        return this.mstore;
    }

    public TypeStore getTypeStore() {
        return this.$TS;
    }

    public TypeFactory getTypeFactory() {
        return this.$TF;
    }

    public RascalTypeFactory getRascalTypeFactory() {
        return this.$RTF;
    }

    public RascalSearchPath getRascalSearchPath() {
        return this.rascalSearchPath;
    }

    @Override
    public int jobEnd(String name, boolean succeeded) {
        this.errwriter.println(name + " ends");
        return 0;
    }

    @Override
    public void jobStep(String name, String message, int worked) {
    }

    @Override
    public void jobStart(String name, int workShare, int totalWork) {
        this.errwriter.println(name + " starts");
    }

    @Override
    public void jobTodo(String name, int work) {
    }

    @Override
    public boolean jobIsCanceled(String name) {
        this.errwriter.println(name + " canceled");
        return true;
    }

    @Override
    public void warning(String message, ISourceLocation src) {
        this.errwriter.println(message);
    }

    public static ISourceLocation inferProjectRoot(Class<?> clazz) {
        try {
            String file = clazz.getProtectionDomain().getCodeSource().getLocation().getPath();
            if (file.endsWith(".jar")) {
                throw new IllegalArgumentException("can not run Rascal JUnit tests from within a jar file");
            }
            File current = new File(file);
            while (current != null && current.exists() && current.isDirectory()) {
                if (new File(current, "META-INF/RASCAL.MF").exists()) {
                    if (current.getName().equals("classes") && current.getParentFile().getName().equals("target")) {
                        current = current.getParentFile().getParentFile();
                        continue;
                    }
                    return URIUtil.createFileLocation(current.getAbsolutePath());
                }
                current = current.getParentFile();
            }
        }
        catch (URISyntaxException e) {
            System.err.println("[ERROR] can not infer project root:" + e);
            return null;
        }
        return null;
    }

    @Override
    public void endAllJobs() {
        this.ideServices.endAllJobs();
    }
}

