/*
 * Decompiled with CFR 0.152.
 */
package io.usethesource.vallang.io.binary.util;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.Deque;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.checkerframework.checker.initialization.qual.UnknownInitialization;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class CacheFactory<T> {
    private final Map<Integer, SoftPool<T>> caches = new ConcurrentHashMap<Integer, SoftPool<T>>();
    private final Function<T, T> cleaner;
    private final long expireNanos;
    private static final ConcurrentLinkedQueue<WeakReference<CacheFactory<?>>> CLEANUP_CACHES = new ConcurrentLinkedQueue();

    public CacheFactory(int expireAfter, TimeUnit unit, Function<T, T> clearer) {
        this.expireNanos = unit.toNanos(expireAfter);
        this.cleaner = clearer;
        CacheFactory.registerInstance(this);
    }

    private void cleanup() {
        long cleanBefore = System.nanoTime() - this.expireNanos;
        for (SoftPool<T> v : this.caches.values()) {
            LastUsedTracker<T> current;
            Iterator<LastUsedTracker<T>> it = v.descendingIterator();
            while (it.hasNext() && (current = it.next()).clearIfOlderThan(cleanBefore)) {
                it.remove();
            }
            v.performHouseKeeping();
        }
    }

    public @NonNull T get(int size, Function<Integer, @NonNull T> computeNew) {
        SoftReference tracker;
        SoftPool reads = this.caches.computeIfAbsent(size, i -> new SoftPool());
        while ((tracker = reads.poll()) != null) {
            Object result = tracker.get();
            if (result == null) continue;
            return result;
        }
        return computeNew.apply(size);
    }

    public void put(int size, T returned) {
        if (returned != null) {
            returned = this.cleaner.apply(returned);
            SoftPool entries = this.caches.computeIfAbsent(size, i -> new SoftPool());
            entries.push(returned);
        }
    }

    private static void registerInstance(@UnknownInitialization CacheFactory<?> cache) {
        CLEANUP_CACHES.add(new WeakReference(cache));
    }

    private static void cleanupRunner() {
        CompletableFuture.delayedExecutor(1L, TimeUnit.SECONDS).execute(CacheFactory::cleanupRunner);
        try {
            Iterator<WeakReference<CacheFactory<?>>> it = CLEANUP_CACHES.iterator();
            while (it.hasNext()) {
                CacheFactory cur = (CacheFactory)it.next().get();
                if (cur == null) {
                    it.remove();
                    continue;
                }
                cur.cleanup();
            }
        }
        catch (Throwable e) {
            System.err.println("Cleanup thread failed with: " + e.getMessage());
            e.printStackTrace(System.err);
        }
    }

    static {
        CacheFactory.cleanupRunner();
    }

    private static final class SoftPool<T> {
        private final Deque<LastUsedTracker<T>> dequeue = new ConcurrentLinkedDeque<LastUsedTracker<T>>();
        private final ReferenceQueue<T> references = new ReferenceQueue();

        private SoftPool() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void performHouseKeeping() {
            ReferenceQueue<T> referenceQueue = this.references;
            synchronized (referenceQueue) {
                Reference<T> cleared;
                while ((cleared = this.references.poll()) != null) {
                    this.dequeue.removeLastOccurrence(cleared);
                }
            }
        }

        public @Nullable SoftReference<T> poll() {
            return this.dequeue.poll();
        }

        public void push(T o) {
            this.dequeue.push(new LastUsedTracker<T>(o, this.references));
        }

        public Iterator<LastUsedTracker<T>> descendingIterator() {
            return this.dequeue.descendingIterator();
        }
    }

    private static final class LastUsedTracker<T>
    extends SoftReference<T> {
        private final long lastUsed = System.nanoTime();

        public LastUsedTracker(T obj, ReferenceQueue<T> queue) {
            super(obj, queue);
        }

        public boolean clearIfOlderThan(long timeStamp) {
            if (timeStamp > this.lastUsed) {
                this.clear();
                return true;
            }
            return false;
        }
    }
}

