/*
 * Decompiled with CFR 0.152.
 */
package io.usethesource.vallang.io.binary.util;

import io.usethesource.capsule.Map;
import io.usethesource.vallang.IBool;
import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IDateTime;
import io.usethesource.vallang.IExternalValue;
import io.usethesource.vallang.IInteger;
import io.usethesource.vallang.IList;
import io.usethesource.vallang.IMap;
import io.usethesource.vallang.INode;
import io.usethesource.vallang.IRational;
import io.usethesource.vallang.IReal;
import io.usethesource.vallang.ISet;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IString;
import io.usethesource.vallang.ITuple;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IWithKeywordParameters;
import io.usethesource.vallang.impl.fields.AbstractDefaultWithKeywordParameters;
import io.usethesource.vallang.io.binary.util.StructuredIValueVisitor;
import io.usethesource.vallang.visitors.IValueVisitor;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.checkerframework.checker.nullness.qual.Nullable;

public class StacklessStructuredVisitor {
    public static <E extends Throwable> void accept(IValue root, StructuredIValueVisitor<E> visit) throws E {
        ArrayDeque workList = new ArrayDeque();
        workList.push(new SingleIValueStep(root, StacklessStructuredVisitor::visitValue));
        while (!workList.isEmpty()) {
            VisitStep current = (VisitStep)workList.peek();
            assert (current != null) : "no concurrent modification to the worklist, so a peek after an !isEmpty should never return null";
            if (current != null && current.hasSteps()) {
                current.step(workList, visit);
                continue;
            }
            workList.pop();
        }
    }

    private static <E extends Throwable> void visitValue(IValue current, final Deque<VisitStep<E>> workList, final StructuredIValueVisitor<E> visit) throws E {
        current.accept(new IValueVisitor<Void, E>(){

            @Override
            public Void visitList(IList lst) throws Throwable {
                if (visit.enterList(lst, lst.length())) {
                    workList.push(new SingleIValueStep(lst, (l, w, v) -> v.leaveList(l)));
                    workList.push(new IteratingSteps(lst.iterator(), (x$0, x$1, x$2) -> StacklessStructuredVisitor.visitValue(x$0, x$1, x$2)));
                }
                return null;
            }

            @Override
            public Void visitSet(ISet set) throws Throwable {
                if (visit.enterSet(set, set.size())) {
                    workList.push(new SingleIValueStep(set, (l, w, v) -> v.leaveSet(l)));
                    workList.push(new IteratingSteps(set.iterator(), (x$0, x$1, x$2) -> StacklessStructuredVisitor.visitValue(x$0, x$1, x$2)));
                }
                return null;
            }

            @Override
            public Void visitMap(final IMap map) throws Throwable {
                if (visit.enterMap(map, map.size())) {
                    workList.push(new SingleIValueStep(map, (l, w, v) -> v.leaveMap(l)));
                    workList.push(new IteratingSteps(new Iterator<IValue>(){
                        Iterator<Map.Entry<IValue, IValue>> entries;
                         @Nullable Map.Entry<IValue, IValue> currentEntry;
                        {
                            this.entries = map.entryIterator();
                            this.currentEntry = null;
                        }

                        @Override
                        public boolean hasNext() {
                            return this.currentEntry != null || this.entries.hasNext();
                        }

                        @Override
                        public IValue next() {
                            Map.Entry<IValue, IValue> entry = this.currentEntry;
                            if (entry != null) {
                                this.currentEntry = null;
                                return entry.getValue();
                            }
                            if (this.entries.hasNext()) {
                                entry = this.currentEntry = this.entries.next();
                                return entry.getKey();
                            }
                            throw new NoSuchElementException();
                        }
                    }, (x$0, x$1, x$2) -> StacklessStructuredVisitor.visitValue(x$0, x$1, x$2)));
                }
                return null;
            }

            @Override
            public Void visitTuple(ITuple tuple) throws Throwable {
                if (visit.enterTuple(tuple, tuple.arity())) {
                    workList.push(new SingleIValueStep(tuple, (l, w, v) -> v.leaveTuple(l)));
                    workList.push(new IteratingSteps(tuple.iterator(), (x$0, x$1, x$2) -> StacklessStructuredVisitor.visitValue(x$0, x$1, x$2)));
                }
                return null;
            }

            @Override
            public Void visitNode(INode node) throws Throwable {
                if (visit.enterNode(node, node.arity())) {
                    IWithKeywordParameters<? extends INode> withKW;
                    workList.push(new SingleIValueStep(node, (l, w, v) -> v.leaveNode(l)));
                    if (node.mayHaveKeywordParameters() && (withKW = node.asWithKeywordParameters()).hasParameters()) {
                        assert (withKW instanceof AbstractDefaultWithKeywordParameters);
                        AbstractDefaultWithKeywordParameters nodeKw = (AbstractDefaultWithKeywordParameters)withKW;
                        this.pushKWPairs(node, nodeKw.internalGetParameters());
                        workList.push(new SingleIValueStep(node, (l, w, v) -> v.enterNodeKeywordParameters()));
                    }
                    workList.push(new IteratingSteps(node.iterator(), (x$0, x$1, x$2) -> StacklessStructuredVisitor.visitValue(x$0, x$1, x$2)));
                }
                return null;
            }

            private void pushKWPairs(IValue root, Map.Immutable<String, IValue> namedValues) {
                workList.push(new SingleIValueStep(root, (l, w, v) -> v.leaveNamedValue()));
                String[] names = new String[namedValues.size()];
                int i = names.length;
                Iterator entryIterator = namedValues.entryIterator();
                while (entryIterator.hasNext()) {
                    Map.Entry param = entryIterator.next();
                    workList.push(new SingleIValueStep((IValue)param.getValue(), (x$0, x$1, x$2) -> StacklessStructuredVisitor.visitValue(x$0, x$1, x$2)));
                    names[--i] = (String)param.getKey();
                }
                assert (i == 0);
                workList.push(new SingleIValueStep(root, (l, w, v) -> v.enterNamedValues(names, names.length)));
            }

            @Override
            public Void visitConstructor(IConstructor constr) throws Throwable {
                if (visit.enterConstructor(constr, constr.arity())) {
                    IWithKeywordParameters<? extends IConstructor> withKW;
                    workList.push(new SingleIValueStep(constr, (l, w, v) -> v.leaveConstructor(l)));
                    if (constr.mayHaveKeywordParameters() && (withKW = constr.asWithKeywordParameters()).hasParameters()) {
                        assert (withKW instanceof AbstractDefaultWithKeywordParameters);
                        AbstractDefaultWithKeywordParameters constrKw = (AbstractDefaultWithKeywordParameters)withKW;
                        this.pushKWPairs(constr, constrKw.internalGetParameters());
                        workList.push(new SingleIValueStep(constr, (l, w, v) -> v.enterConstructorKeywordParameters()));
                    }
                    workList.push(new IteratingSteps(constr.iterator(), (x$0, x$1, x$2) -> StacklessStructuredVisitor.visitValue(x$0, x$1, x$2)));
                }
                return null;
            }

            @Override
            public Void visitExternal(IExternalValue externalValue) throws Throwable {
                throw new RuntimeException("External values not supported yet");
            }

            @Override
            public Void visitSourceLocation(ISourceLocation o) throws Throwable {
                visit.visitSourceLocation(o);
                return null;
            }

            @Override
            public Void visitInteger(IInteger o) throws Throwable {
                visit.visitInteger(o);
                return null;
            }

            @Override
            public Void visitBoolean(IBool boolValue) throws Throwable {
                visit.visitBoolean(boolValue);
                return null;
            }

            @Override
            public Void visitDateTime(IDateTime o) throws Throwable {
                visit.visitDateTime(o);
                return null;
            }

            @Override
            public Void visitString(IString o) throws Throwable {
                visit.visitString(o);
                return null;
            }

            @Override
            public Void visitReal(IReal o) throws Throwable {
                visit.visitReal(o);
                return null;
            }

            @Override
            public Void visitRational(IRational o) throws Throwable {
                visit.visitRational(o);
                return null;
            }
        });
    }

    private static final class IteratingSteps<E extends Throwable>
    extends VisitStep<E> {
        final Iterator<IValue> values;

        public IteratingSteps(Iterator<IValue> values, NextStepConsumer<E> next) {
            super(next);
            this.values = values;
        }

        @Override
        boolean hasSteps() {
            return this.values.hasNext();
        }

        @Override
        void step(Deque<VisitStep<E>> worklist, StructuredIValueVisitor<E> visit) throws E {
            this.next.accept(this.values.next(), worklist, visit);
        }
    }

    private static final class SingleIValueStep<E extends Throwable>
    extends VisitStep<E> {
        final IValue val;
        boolean completed = false;

        public SingleIValueStep(IValue val, NextStepConsumer<E> next) {
            super(next);
            this.val = val;
        }

        @Override
        boolean hasSteps() {
            return !this.completed;
        }

        @Override
        void step(Deque<VisitStep<E>> worklist, StructuredIValueVisitor<E> visit) throws E {
            this.next.accept(this.val, worklist, visit);
            this.completed = true;
        }
    }

    private static abstract class VisitStep<E extends Throwable> {
        final NextStepConsumer<E> next;

        VisitStep(NextStepConsumer<E> next) {
            this.next = next;
        }

        abstract boolean hasSteps();

        abstract void step(Deque<VisitStep<E>> var1, StructuredIValueVisitor<E> var2) throws E;
    }

    @FunctionalInterface
    private static interface NextStepConsumer<E extends Throwable> {
        public void accept(IValue var1, Deque<VisitStep<E>> var2, StructuredIValueVisitor<E> var3) throws E;
    }
}

