/*
 * Decompiled with CFR 0.152.
 */
package io.usethesource.vallang.type;

import io.usethesource.vallang.exceptions.FactTypeDeclarationException;
import io.usethesource.vallang.exceptions.FactTypeRedeclaredException;
import io.usethesource.vallang.exceptions.FactTypeUseException;
import io.usethesource.vallang.exceptions.IllegalIdentifierException;
import io.usethesource.vallang.exceptions.IllegalKeywordParameterDeclarationException;
import io.usethesource.vallang.exceptions.RedeclaredConstructorException;
import io.usethesource.vallang.exceptions.RedeclaredFieldNameException;
import io.usethesource.vallang.exceptions.RedeclaredKeywordParameterException;
import io.usethesource.vallang.exceptions.UndeclaredAbstractDataTypeException;
import io.usethesource.vallang.type.AliasType;
import io.usethesource.vallang.type.ConstructorType;
import io.usethesource.vallang.type.FunctionType;
import io.usethesource.vallang.type.ITypeVisitor;
import io.usethesource.vallang.type.TupleType;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.Nullable;

public class TypeStore {
    private final TypeFactory factory = TypeFactory.getInstance();
    private final Map<String, Type> fAliases = new HashMap<String, Type>();
    private final Map<String, Type> fADTs = new HashMap<String, Type>();
    private final Map<Type, Set<Type>> fConstructors = new HashMap<Type, Set<Type>>();
    private final Map<Type, Map<String, Type>> fkeywordParameters = new HashMap<Type, Map<String, Type>>();
    private final Set<TypeStore> fImports = new HashSet<TypeStore>();
    private static final List<String> IGNORE_OVERLOADING_CHECKS = Arrays.asList("AType", "Grammar", "RuntimeException", "ModuleStatus");

    public TypeStore(TypeStore ... imports) {
        for (TypeStore s2 : imports) {
            this.fImports.add(s2);
        }
    }

    public String toString() {
        return "TypeStore(adts=" + this.fADTs.size() + ",imports=" + this.fImports.size() + ")";
    }

    public Collection<Type> getAbstractDataTypes() {
        return Collections.unmodifiableCollection(this.fADTs.values());
    }

    public Collection<Type> getAliases() {
        return Collections.unmodifiableCollection(this.fAliases.values());
    }

    public Map<Type, Map<String, Type>> getKeywordParameters() {
        HashMap<Type, Map<String, Type>> unmodifiableMap = new HashMap<Type, Map<String, Type>>();
        for (Type key : this.fkeywordParameters.keySet()) {
            unmodifiableMap.put(key, Collections.unmodifiableMap(this.fkeywordParameters.get(key)));
        }
        return unmodifiableMap;
    }

    public Collection<Type> getConstructors() {
        HashSet<Type> result = new HashSet<Type>();
        for (Set<Type> adt : this.fConstructors.values()) {
            result.addAll(adt);
        }
        return Collections.unmodifiableCollection(result);
    }

    public Collection<TypeStore> getImports() {
        return Collections.unmodifiableCollection(this.fImports);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importStore(TypeStore ... stores) {
        Set<TypeStore> set = this.fImports;
        synchronized (set) {
            for (TypeStore s2 : stores) {
                this.doImport(s2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void unimportStores(TypeStore ... stores) {
        Set<TypeStore> set = this.fImports;
        synchronized (set) {
            this.fImports.removeAll(Arrays.asList(stores));
        }
    }

    private void doImport(TypeStore s2) {
        this.checkOverlappingAliases(s2);
        this.checkConstructorOverloading(s2);
        this.fImports.add(s2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void extendStore(TypeStore other) {
        Object object = this.fAliases;
        synchronized (object) {
            this.fAliases.putAll(other.fAliases);
        }
        object = this.fADTs;
        synchronized (object) {
            this.fADTs.putAll(other.fADTs);
        }
        object = this.fConstructors;
        synchronized (object) {
            for (Type type : other.fConstructors.keySet()) {
                Set<Type> set = this.fConstructors.get(type);
                if (set == null) {
                    set = new HashSet<Type>();
                }
                set.addAll((Collection<Type>)other.fConstructors.get(type));
                this.fConstructors.put(type, set);
            }
        }
        object = this.fkeywordParameters;
        synchronized (object) {
            this.fkeywordParameters.putAll(other.fkeywordParameters);
        }
        object = this.fImports;
        synchronized (object) {
            this.fImports.addAll(other.fImports);
        }
    }

    private void checkConstructorOverloading(TypeStore s2) {
        for (Type type : this.fADTs.values()) {
            Type other;
            if (IGNORE_OVERLOADING_CHECKS.contains(type.getName()) || (other = s2.fADTs.get(type.getName())) == null || other != type) continue;
            Set<Type> signature1 = this.fConstructors.get(type);
            Set<Type> signature2 = s2.fConstructors.get(type);
            if (signature2 == null || signature1 == null) continue;
            for (Type alt : signature2) {
                Type children = alt.getFieldTypes();
                this.checkOverloading(signature1, alt.getName(), children);
                try {
                    this.checkFieldNames(signature1, children);
                }
                catch (RedeclaredFieldNameException e) {
                    throw new RedeclaredFieldNameException(e.getFieldName(), e.getFirstType(), e.getSecondType(), type);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkOverlappingAliases(TypeStore s2) {
        Map<String, Type> map = this.fAliases;
        synchronized (map) {
            for (Type alias : this.fAliases.values()) {
                Type other = s2.fAliases.get(alias.getName());
                if (other == null || other.comparable(alias)) continue;
                throw new FactTypeRedeclaredException(alias.getName(), other);
            }
        }
    }

    public TypeFactory getFactory() {
        return this.factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void declareAlias(Type alias) throws FactTypeDeclarationException {
        Map<String, Type> map = this.fADTs;
        synchronized (map) {
            Map<String, Type> map2 = this.fAliases;
            synchronized (map2) {
                String name = alias.getName();
                Type oldAdt = this.lookupAbstractDataType(name);
                if (oldAdt != null) {
                    throw new FactTypeRedeclaredException(name, oldAdt);
                }
                Type oldAlias = this.lookupAlias(name);
                if (oldAlias != null) {
                    if (oldAlias == alias || !alias.isOpen() && alias.isSubtypeOf(oldAlias)) {
                        return;
                    }
                    throw new FactTypeRedeclaredException(name, oldAlias);
                }
                this.fAliases.put(name, alias);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void declareAbstractDataType(Type adt) throws FactTypeDeclarationException {
        Map<String, Type> map = this.fADTs;
        synchronized (map) {
            Map<String, Type> map2 = this.fAliases;
            synchronized (map2) {
                Map<Type, Set<Type>> map3 = this.fConstructors;
                synchronized (map3) {
                    String name = adt.getName();
                    Type oldAdt = this.lookupAbstractDataType(name);
                    if (oldAdt != null) {
                        if (adt.comparable(oldAdt) || oldAdt.isExternalType()) {
                            return;
                        }
                        throw new FactTypeRedeclaredException(name, oldAdt);
                    }
                    Type oldAlias = this.lookupAlias(name);
                    if (oldAlias != null) {
                        throw new FactTypeRedeclaredException(name, oldAlias);
                    }
                    this.fADTs.put(name, adt);
                    if (this.fConstructors.get(adt) == null) {
                        this.fConstructors.put(adt, new HashSet());
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void declareConstructor(Type constructor) throws FactTypeDeclarationException {
        Map<String, Type> map = this.fADTs;
        synchronized (map) {
            Map<Type, Set<Type>> map2 = this.fConstructors;
            synchronized (map2) {
                Set<Type> localSignature;
                Type adt = constructor.getAbstractDataType();
                Type other = this.lookupAbstractDataType(adt.getName());
                if (other == null) {
                    throw new UndeclaredAbstractDataTypeException(adt);
                }
                Set<Type> signature = this.lookupAlternatives(adt);
                if (signature == null) {
                    throw new UndeclaredAbstractDataTypeException(adt);
                }
                Type constructor1 = this.expandAliases(constructor);
                if (!constructor.equals(constructor1)) {
                    constructor = constructor1;
                }
                if (!IGNORE_OVERLOADING_CHECKS.contains(adt.getName())) {
                    this.checkOverloading(signature, constructor.getName(), constructor.getFieldTypes());
                    try {
                        this.checkFieldNames(signature, constructor.getFieldTypes());
                    }
                    catch (RedeclaredFieldNameException e) {
                        throw new RedeclaredFieldNameException(e.getFieldName(), e.getFirstType(), e.getSecondType(), adt);
                    }
                }
                if ((localSignature = this.fConstructors.get(adt)) == null) {
                    localSignature = new HashSet<Type>();
                    this.fConstructors.put(adt, localSignature);
                    if (!this.fADTs.containsKey(adt.getName())) {
                        this.fADTs.put(adt.getName(), adt);
                    }
                }
                localSignature.add(constructor);
            }
        }
    }

    private void checkFieldNames(Set<Type> signature, Type tupleType) {
        if (!tupleType.hasFieldNames()) {
            return;
        }
        for (Type alt : signature) {
            Type altArgs = alt.getFieldTypes();
            if (!altArgs.hasFieldNames()) continue;
            for (int i = tupleType.getArity() - 1; i >= 0; --i) {
                Type type = tupleType.getFieldType(i);
                String label = Objects.requireNonNull(tupleType.getFieldName(i));
                for (int j = altArgs.getArity() - 1; j >= 0; --j) {
                    if (!label.equals(altArgs.getFieldName(j)) || altArgs.getFieldType(j).equivalent(type)) continue;
                    throw new RedeclaredFieldNameException(label, type, altArgs.getFieldType(j), tupleType);
                }
            }
        }
    }

    private void checkOverloading(Set<Type> signature, String name, Type tupleType) throws FactTypeDeclarationException {
        for (Type alt : signature) {
            Type fieldTypes;
            if (!alt.getName().equals(name) || (fieldTypes = alt.getFieldTypes()) == tupleType || !fieldTypes.comparable(tupleType)) continue;
            throw new RedeclaredConstructorException(name, fieldTypes, tupleType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @Nullable Type lookupAlias(String name) {
        Map<String, Type> map = this.fAliases;
        synchronized (map) {
            Set<TypeStore> set = this.fImports;
            synchronized (set) {
                Type result = this.fAliases.get(name);
                if (result == null) {
                    for (TypeStore i : this.fImports) {
                        result = i.fAliases.get(name);
                        if (result == null) continue;
                        return result;
                    }
                }
                return result;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Type> lookupAlternatives(Type adt) {
        Map<Type, Set<Type>> map = this.fConstructors;
        synchronized (map) {
            Set<TypeStore> set = this.fImports;
            synchronized (set) {
                while (adt.isAliased()) {
                    adt = adt.getAliased();
                }
                Set<Type> result = this.fConstructors.get(adt);
                if (result == null) {
                    result = new HashSet<Type>();
                }
                for (TypeStore s2 : this.fImports) {
                    Set<Type> imported;
                    if (s2 == this || (imported = s2.fConstructors.get(adt)) == null) continue;
                    result.addAll(imported);
                }
                return result;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Type> lookupConstructor(Type adt, String constructorName) throws FactTypeUseException {
        Map<Type, Set<Type>> map = this.fConstructors;
        synchronized (map) {
            Set<TypeStore> set = this.fImports;
            synchronized (set) {
                while (adt.isAliased()) {
                    adt = adt.getAliased();
                }
                Type parameterizedADT = this.fADTs.get(adt.getName());
                Set<Type> local = parameterizedADT != null ? this.fConstructors.get(parameterizedADT) : null;
                HashSet<Type> result = new HashSet<Type>();
                if (local != null) {
                    for (Type cand : local) {
                        if (!cand.getName().equals(constructorName)) continue;
                        result.add(cand);
                    }
                }
                for (TypeStore i : this.fImports) {
                    local = i.fConstructors.get(adt);
                    if (local == null) continue;
                    for (Type cand : local) {
                        if (!cand.getName().equals(constructorName)) continue;
                        result.add(cand);
                    }
                }
                return result;
            }
        }
    }

    public @Nullable Type lookupFirstConstructor(String cons, Type args) {
        Set<Type> adts = this.allAbstractDataTypes();
        for (Type adt : adts) {
            Type cand = this.lookupConstructor(adt, cons, args);
            if (cand == null) continue;
            return cand;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<Type> allAbstractDataTypes() {
        Map<String, Type> map = this.fADTs;
        synchronized (map) {
            Set<TypeStore> set = this.fImports;
            synchronized (set) {
                HashSet<Type> result = new HashSet<Type>();
                result.addAll(this.fADTs.values());
                for (TypeStore s2 : this.fImports) {
                    result.addAll(s2.fADTs.values());
                }
                return result;
            }
        }
    }

    public @Nullable Type lookupConstructor(Type adt, String cons, Type args) {
        Set<Type> sig = this.lookupConstructor(adt, cons);
        if (sig != null) {
            for (Type cand : sig) {
                if (!args.isSubtypeOf(cand.getFieldTypes())) continue;
                return cand;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Type> lookupConstructors(String constructorName) {
        Map<Type, Set<Type>> map = this.fConstructors;
        synchronized (map) {
            Set<TypeStore> set = this.fImports;
            synchronized (set) {
                HashSet<Type> result = new HashSet<Type>();
                for (Set<Type> adt : this.fConstructors.values()) {
                    for (Type type : adt) {
                        String name = type.getName();
                        if (!name.equals(constructorName)) continue;
                        result.add(type);
                    }
                }
                for (TypeStore i : this.fImports) {
                    if (i == this) continue;
                    for (Set set2 : i.fConstructors.values()) {
                        for (Type cand : set2) {
                            String name = cand.getName();
                            if (!name.equals(constructorName)) continue;
                            result.add(cand);
                        }
                    }
                }
                return result;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @Nullable Type lookupAbstractDataType(String name) {
        Map<String, Type> map = this.fADTs;
        synchronized (map) {
            Set<TypeStore> set = this.fImports;
            synchronized (set) {
                Type result = this.fADTs.get(name);
                if (result != null) {
                    return result;
                }
                for (TypeStore s2 : this.fImports) {
                    result = s2.fADTs.get(name);
                    if (result == null) continue;
                    return result;
                }
                return result;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void declareKeywordParameter(Type onType, String key, Type valueType) {
        if (!onType.isConstructor() && !onType.isAbstractData()) {
            throw new IllegalKeywordParameterDeclarationException(onType);
        }
        onType = this.expandAliases(onType);
        Map<Type, Map<String, Type>> map = this.fkeywordParameters;
        synchronized (map) {
            Map<String, Type> declaredEarlier;
            Map<String, Type> kwParamsForType = this.fkeywordParameters.get(onType);
            if (!this.factory.isIdentifier(key)) {
                throw new IllegalIdentifierException(key);
            }
            if (kwParamsForType == null) {
                kwParamsForType = new HashMap<String, Type>();
                this.fkeywordParameters.put(onType, kwParamsForType);
            }
            if (!(declaredEarlier = this.getKeywordParameters(onType)).containsKey(key)) {
                kwParamsForType.put(key, valueType);
            } else if (!declaredEarlier.get(key).equivalent(valueType)) {
                throw new RedeclaredKeywordParameterException(key, declaredEarlier.get(key));
            }
        }
    }

    @Deprecated
    private Type expandAliases(Type type) {
        return this.expandAliases1(type, new HashSet<String>());
    }

    private Type expandAliases1(Type type, final Set<String> seen) {
        return type.accept(new ITypeVisitor<Type, RuntimeException>(){

            @Override
            public Type visitReal(Type type) throws RuntimeException {
                return type;
            }

            @Override
            public Type visitInteger(Type type) throws RuntimeException {
                return type;
            }

            @Override
            public Type visitRational(Type type) throws RuntimeException {
                return type;
            }

            @Override
            public Type visitList(Type type) throws RuntimeException {
                return TypeStore.this.factory.listType(TypeStore.this.expandAliases1(type.getElementType(), seen));
            }

            @Override
            public Type visitMap(Type type) throws RuntimeException {
                return TypeStore.this.factory.mapType(TypeStore.this.expandAliases1(type.getKeyType(), seen), TypeStore.this.expandAliases1(type.getValueType(), seen));
            }

            @Override
            public Type visitNumber(Type type) throws RuntimeException {
                return type;
            }

            @Override
            public Type visitAlias(Type type) throws RuntimeException {
                String aliasName = type.getName();
                if (seen.contains(aliasName)) {
                    throw new IllegalIdentifierException("Circular alias definition for: " + aliasName);
                }
                seen.add(aliasName);
                return TypeStore.this.expandAliases1(type.getAliased(), seen);
            }

            @Override
            public Type visitSet(Type type) throws RuntimeException {
                return TypeStore.this.factory.setType(TypeStore.this.expandAliases1(type.getElementType(), seen));
            }

            @Override
            public Type visitSourceLocation(Type type) throws RuntimeException {
                return type;
            }

            @Override
            public Type visitString(Type type) throws RuntimeException {
                return type;
            }

            @Override
            public Type visitNode(Type type) throws RuntimeException {
                return type;
            }

            @Override
            public Type visitConstructor(Type type) throws RuntimeException {
                return TypeStore.this.factory.getFromCache(new ConstructorType(type.getName(), TypeStore.this.expandAliases1(type.getFieldTypes(), seen), type.getAbstractDataType()));
            }

            @Override
            public Type visitAbstractData(Type type) throws RuntimeException {
                return type;
            }

            @Override
            public Type visitFunction(Type type) throws RuntimeException {
                return TypeStore.this.factory.getFromCache(new FunctionType(TypeStore.this.expandAliases1(type.getReturnType(), seen), (TupleType)TypeStore.this.expandAliases1(type.getFieldTypes(), seen), (TupleType)TypeStore.this.expandAliases1(type.getKeywordParameterTypes(), seen)));
            }

            @Override
            public Type visitTuple(Type type) throws RuntimeException {
                int arity = type.getArity();
                Type[] fieldTypes = new Type[arity];
                boolean aliasFound = false;
                for (int i = 0; i < arity; ++i) {
                    Type newFieldType;
                    Type fieldType = type.getFieldType(i);
                    if (fieldType.isAliased()) {
                        aliasFound = true;
                        AliasType alias = (AliasType)fieldType;
                        fieldType = alias.getAliased();
                    }
                    aliasFound |= (newFieldType = TypeStore.this.expandAliases1(fieldType, seen)) != fieldType;
                    fieldTypes[i] = newFieldType;
                }
                if (aliasFound) {
                    return type.hasFieldNames() ? TypeStore.this.factory.tupleType(fieldTypes, type.getFieldNames()) : TypeStore.this.factory.tupleType(fieldTypes);
                }
                return type;
            }

            @Override
            public Type visitValue(Type type) throws RuntimeException {
                return type;
            }

            @Override
            public Type visitVoid(Type type) throws RuntimeException {
                return type;
            }

            @Override
            public Type visitBool(Type type) throws RuntimeException {
                return type;
            }

            @Override
            public Type visitParameter(Type type) throws RuntimeException {
                return TypeStore.this.factory.parameterType(type.getName(), TypeStore.this.expandAliases1(type.getBound(), seen));
            }

            @Override
            public Type visitExternal(Type type) throws RuntimeException {
                return type;
            }

            @Override
            public Type visitDateTime(Type type) throws RuntimeException {
                return type;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Type> getKeywordParameters(Type onType) {
        if (!onType.isConstructor() && !onType.isAbstractData()) {
            return Collections.emptyMap();
        }
        onType = this.expandAliases(onType);
        Map<Type, Map<String, Type>> map = this.fkeywordParameters;
        synchronized (map) {
            Set<TypeStore> set = this.fImports;
            synchronized (set) {
                HashMap<String, Type> result = new HashMap<String, Type>();
                Map<String, Type> local = this.fkeywordParameters.get(onType);
                if (local != null) {
                    result.putAll(local);
                }
                if (onType.isConstructor() && (local = this.fkeywordParameters.get(onType.getAbstractDataType())) != null) {
                    result.putAll(local);
                }
                for (TypeStore s2 : this.fImports) {
                    if (s2.fkeywordParameters == null) continue;
                    Map<String, Type> here = s2.fkeywordParameters.get(onType);
                    if (here != null) {
                        result.putAll(here);
                    }
                    if (!onType.isConstructor() || (here = s2.fkeywordParameters.get(onType.getAbstractDataType())) == null) continue;
                    result.putAll(here);
                }
                return result;
            }
        }
    }

    public @Nullable Type getKeywordParameterType(Type onType, String key) {
        assert (onType.isConstructor() || onType.isAbstractData());
        return this.getKeywordParameters(onType).get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasKeywordParameters(Type onType) {
        if (!onType.isConstructor()) {
            return false;
        }
        Map<Type, Map<String, Type>> map = this.fkeywordParameters;
        synchronized (map) {
            Set<TypeStore> set = this.fImports;
            synchronized (set) {
                Map<String, Type> local = this.fkeywordParameters.get(onType);
                if (local != null && local.size() > 0) {
                    return true;
                }
                for (TypeStore s2 : this.fImports) {
                    Map<String, Type> here;
                    if (s2.fkeywordParameters == null || (here = s2.fkeywordParameters.get(onType)) == null || here.size() <= 0) continue;
                    return true;
                }
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EnsuresNonNullIf(expression={"getKeywordParameterType(#1,#2)"}, result=true)
    public boolean hasKeywordParameter(Type onType, String label) {
        if (!onType.isConstructor()) {
            return false;
        }
        onType = this.expandAliases(onType);
        Map<Type, Map<String, Type>> map = this.fkeywordParameters;
        synchronized (map) {
            Set<TypeStore> set = this.fImports;
            synchronized (set) {
                Map<String, Type> local = this.fkeywordParameters.get(onType);
                if (local != null && local.containsKey(label)) {
                    return true;
                }
                local = this.fkeywordParameters.get(onType.getAbstractDataType());
                if (local != null && local.containsKey(label)) {
                    return true;
                }
                for (TypeStore s2 : this.fImports) {
                    if (s2.fkeywordParameters == null) continue;
                    Map<String, Type> here = s2.fkeywordParameters.get(onType);
                    if (here != null && here.containsKey(label)) {
                        return true;
                    }
                    here = s2.fkeywordParameters.get(onType.getAbstractDataType());
                    if (here == null || !here.containsKey(label)) continue;
                    return true;
                }
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @Nullable Type getAlias(String name) {
        Map<String, Type> map = this.fAliases;
        synchronized (map) {
            Set<TypeStore> set = this.fImports;
            synchronized (set) {
                Type result = this.fAliases.get(name);
                if (result != null) {
                    return result;
                }
                for (TypeStore s2 : this.fImports) {
                    result = s2.fAliases.get(name);
                    if (result == null) continue;
                    return result;
                }
                return null;
            }
        }
    }
}

