/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4j.jsonrpc.json.adapters;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Type;
import org.eclipse.lsp4j.jsonrpc.json.adapters.TypeUtils;
import org.eclipse.lsp4j.jsonrpc.messages.Tuple;

public final class TupleTypeAdapters {
    private TupleTypeAdapters() {
    }

    public static class TwoTypeAdapterFactory
    implements TypeAdapterFactory {
        @Override
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
            if (!TypeUtils.isTwoTuple(typeToken.getType())) {
                return null;
            }
            return new TwoTypeAdapter(gson, typeToken);
        }
    }

    public static class TwoTypeAdapter<F, S>
    extends TypeAdapter<Tuple.Two<F, S>> {
        protected final TypeAdapter<F> first;
        protected final TypeAdapter<S> second;

        public TwoTypeAdapter(Gson gson, TypeToken<Tuple.Two<F, S>> typeToken) {
            Type[] elementTypes = TypeUtils.getElementTypes(typeToken, Tuple.Two.class);
            this.first = gson.getAdapter(TypeToken.get(elementTypes[0]));
            this.second = gson.getAdapter(TypeToken.get(elementTypes[1]));
        }

        @Override
        public void write(JsonWriter out, Tuple.Two<F, S> value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                out.beginArray();
                this.first.write(out, value.getFirst());
                this.second.write(out, value.getSecond());
                out.endArray();
            }
        }

        @Override
        public Tuple.Two<F, S> read(JsonReader in) throws IOException {
            JsonToken next = in.peek();
            if (next == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            in.beginArray();
            F f = this.first.read(in);
            S s2 = this.second.read(in);
            Tuple.Two<F, S> result = new Tuple.Two<F, S>(f, s2);
            in.endArray();
            return result;
        }
    }
}

