/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.ast;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.ISourceLocation;
import java.util.List;
import org.rascalmpl.ast.AbstractAST;
import org.rascalmpl.ast.IASTVisitor;
import org.rascalmpl.ast.TypeVar;

public abstract class ModuleParameters
extends AbstractAST {
    public ModuleParameters(ISourceLocation src, IConstructor node) {
        super(src);
    }

    public boolean hasParameters() {
        return false;
    }

    public List<TypeVar> getParameters() {
        throw new UnsupportedOperationException(this.src.toString());
    }

    public boolean isDefault() {
        return false;
    }

    public static class Default
    extends ModuleParameters {
        private final List<TypeVar> parameters;

        public Default(ISourceLocation src, IConstructor node, List<TypeVar> parameters) {
            super(src, node);
            this.parameters = parameters;
        }

        @Override
        public boolean isDefault() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitModuleParametersDefault(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            for (AbstractAST abstractAST : this.parameters) {
                ISourceLocation $l = abstractAST.getLocation();
                if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                    abstractAST.addForLineNumber($line, $result);
                }
                if ($l.getBeginLine() <= $line) continue;
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Default)) {
                return false;
            }
            Default tmp = (Default)o;
            return tmp.parameters.equals(this.parameters);
        }

        @Override
        public int hashCode() {
            return 83 + 673 * this.parameters.hashCode();
        }

        @Override
        public List<TypeVar> getParameters() {
            return this.parameters;
        }

        @Override
        public boolean hasParameters() {
            return true;
        }

        @Override
        public Object clone() {
            return Default.newInstance(this.getClass(), this.src, null, this.clone(this.parameters));
        }
    }
}

