/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.ast;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.ISourceLocation;
import java.util.List;
import org.rascalmpl.ast.AbstractAST;
import org.rascalmpl.ast.Expression;
import org.rascalmpl.ast.IASTVisitor;
import org.rascalmpl.ast.PreStringChars;
import org.rascalmpl.ast.StringConstant;
import org.rascalmpl.ast.StringTail;
import org.rascalmpl.ast.StringTemplate;

public abstract class StringLiteral
extends AbstractAST {
    public StringLiteral(ISourceLocation src, IConstructor node) {
        super(src);
    }

    public boolean hasExpression() {
        return false;
    }

    public Expression getExpression() {
        throw new UnsupportedOperationException(this.src.toString());
    }

    public boolean hasPre() {
        return false;
    }

    public PreStringChars getPre() {
        throw new UnsupportedOperationException(this.src.toString());
    }

    public boolean hasConstant() {
        return false;
    }

    public StringConstant getConstant() {
        throw new UnsupportedOperationException(this.src.toString());
    }

    public boolean hasTail() {
        return false;
    }

    public StringTail getTail() {
        throw new UnsupportedOperationException(this.src.toString());
    }

    public boolean hasTemplate() {
        return false;
    }

    public StringTemplate getTemplate() {
        throw new UnsupportedOperationException(this.src.toString());
    }

    public boolean isInterpolated() {
        return false;
    }

    public boolean isNonInterpolated() {
        return false;
    }

    public boolean isTemplate() {
        return false;
    }

    public static class Template
    extends StringLiteral {
        private final PreStringChars pre;
        private final StringTemplate template;
        private final StringTail tail;

        public Template(ISourceLocation src, IConstructor node, PreStringChars pre, StringTemplate template, StringTail tail) {
            super(src, node);
            this.pre = pre;
            this.template = template;
            this.tail = tail;
        }

        @Override
        public boolean isTemplate() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitStringLiteralTemplate(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.pre.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.pre.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.template.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.template.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.tail.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.tail.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Template)) {
                return false;
            }
            Template tmp = (Template)o;
            return tmp.pre.equals(this.pre) && tmp.template.equals(this.template) && tmp.tail.equals(this.tail);
        }

        @Override
        public int hashCode() {
            return 547 + 283 * this.pre.hashCode() + 757 * this.template.hashCode() + 347 * this.tail.hashCode();
        }

        @Override
        public PreStringChars getPre() {
            return this.pre;
        }

        @Override
        public boolean hasPre() {
            return true;
        }

        @Override
        public StringTemplate getTemplate() {
            return this.template;
        }

        @Override
        public boolean hasTemplate() {
            return true;
        }

        @Override
        public StringTail getTail() {
            return this.tail;
        }

        @Override
        public boolean hasTail() {
            return true;
        }

        @Override
        public Object clone() {
            return Template.newInstance(this.getClass(), this.src, null, this.clone(this.pre), this.clone(this.template), this.clone(this.tail));
        }
    }

    public static class NonInterpolated
    extends StringLiteral {
        private final StringConstant constant;

        public NonInterpolated(ISourceLocation src, IConstructor node, StringConstant constant) {
            super(src, node);
            this.constant = constant;
        }

        @Override
        public boolean isNonInterpolated() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitStringLiteralNonInterpolated(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.constant.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.constant.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof NonInterpolated)) {
                return false;
            }
            NonInterpolated tmp = (NonInterpolated)o;
            return tmp.constant.equals(this.constant);
        }

        @Override
        public int hashCode() {
            return 97 + 607 * this.constant.hashCode();
        }

        @Override
        public StringConstant getConstant() {
            return this.constant;
        }

        @Override
        public boolean hasConstant() {
            return true;
        }

        @Override
        public Object clone() {
            return NonInterpolated.newInstance(this.getClass(), this.src, null, this.clone(this.constant));
        }
    }

    public static class Interpolated
    extends StringLiteral {
        private final PreStringChars pre;
        private final Expression expression;
        private final StringTail tail;

        public Interpolated(ISourceLocation src, IConstructor node, PreStringChars pre, Expression expression, StringTail tail) {
            super(src, node);
            this.pre = pre;
            this.expression = expression;
            this.tail = tail;
        }

        @Override
        public boolean isInterpolated() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitStringLiteralInterpolated(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.pre.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.pre.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.expression.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.expression.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.tail.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.tail.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Interpolated)) {
                return false;
            }
            Interpolated tmp = (Interpolated)o;
            return tmp.pre.equals(this.pre) && tmp.expression.equals(this.expression) && tmp.tail.equals(this.tail);
        }

        @Override
        public int hashCode() {
            return 2 + 947 * this.pre.hashCode() + 281 * this.expression.hashCode() + 409 * this.tail.hashCode();
        }

        @Override
        public PreStringChars getPre() {
            return this.pre;
        }

        @Override
        public boolean hasPre() {
            return true;
        }

        @Override
        public Expression getExpression() {
            return this.expression;
        }

        @Override
        public boolean hasExpression() {
            return true;
        }

        @Override
        public StringTail getTail() {
            return this.tail;
        }

        @Override
        public boolean hasTail() {
            return true;
        }

        @Override
        public Object clone() {
            return Interpolated.newInstance(this.getClass(), this.src, null, this.clone(this.pre), this.clone(this.expression), this.clone(this.tail));
        }
    }
}

