/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.ast;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.ISourceLocation;
import java.util.List;
import org.rascalmpl.ast.AbstractAST;
import org.rascalmpl.ast.IASTVisitor;
import org.rascalmpl.ast.Name;
import org.rascalmpl.ast.TagString;

public abstract class Tag
extends AbstractAST {
    public Tag(ISourceLocation src, IConstructor node) {
        super(src);
    }

    public boolean hasExpression() {
        return false;
    }

    public org.rascalmpl.ast.Expression getExpression() {
        throw new UnsupportedOperationException(this.src.toString());
    }

    public boolean hasName() {
        return false;
    }

    public Name getName() {
        throw new UnsupportedOperationException(this.src.toString());
    }

    public boolean hasContents() {
        return false;
    }

    public TagString getContents() {
        throw new UnsupportedOperationException(this.src.toString());
    }

    public boolean isDefault() {
        return false;
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean isExpression() {
        return false;
    }

    public static class Expression
    extends Tag {
        private final Name name;
        private final org.rascalmpl.ast.Expression expression;

        public Expression(ISourceLocation src, IConstructor node, Name name, org.rascalmpl.ast.Expression expression) {
            super(src, node);
            this.name = name;
            this.expression = expression;
        }

        @Override
        public boolean isExpression() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitTagExpression(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.name.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.name.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.expression.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.expression.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Expression)) {
                return false;
            }
            Expression tmp = (Expression)o;
            return tmp.name.equals(this.name) && tmp.expression.equals(this.expression);
        }

        @Override
        public int hashCode() {
            return 101 + 421 * this.name.hashCode() + 277 * this.expression.hashCode();
        }

        @Override
        public Name getName() {
            return this.name;
        }

        @Override
        public boolean hasName() {
            return true;
        }

        @Override
        public org.rascalmpl.ast.Expression getExpression() {
            return this.expression;
        }

        @Override
        public boolean hasExpression() {
            return true;
        }

        @Override
        public Object clone() {
            return Expression.newInstance(this.getClass(), this.src, null, this.clone(this.name), this.clone(this.expression));
        }
    }

    public static class Empty
    extends Tag {
        private final Name name;

        public Empty(ISourceLocation src, IConstructor node, Name name) {
            super(src, node);
            this.name = name;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitTagEmpty(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.name.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.name.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Empty)) {
                return false;
            }
            Empty tmp = (Empty)o;
            return tmp.name.equals(this.name);
        }

        @Override
        public int hashCode() {
            return 181 + 599 * this.name.hashCode();
        }

        @Override
        public Name getName() {
            return this.name;
        }

        @Override
        public boolean hasName() {
            return true;
        }

        @Override
        public Object clone() {
            return Empty.newInstance(this.getClass(), this.src, null, this.clone(this.name));
        }
    }

    public static class Default
    extends Tag {
        private final Name name;
        private final TagString contents;

        public Default(ISourceLocation src, IConstructor node, Name name, TagString contents) {
            super(src, node);
            this.name = name;
            this.contents = contents;
        }

        @Override
        public boolean isDefault() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitTagDefault(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.name.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.name.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.contents.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.contents.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Default)) {
                return false;
            }
            Default tmp = (Default)o;
            return tmp.name.equals(this.name) && tmp.contents.equals(this.contents);
        }

        @Override
        public int hashCode() {
            return 431 + 67 * this.name.hashCode() + 19 * this.contents.hashCode();
        }

        @Override
        public Name getName() {
            return this.name;
        }

        @Override
        public boolean hasName() {
            return true;
        }

        @Override
        public TagString getContents() {
            return this.contents;
        }

        @Override
        public boolean hasContents() {
            return true;
        }

        @Override
        public Object clone() {
            return Default.newInstance(this.getClass(), this.src, null, this.clone(this.name), this.clone(this.contents));
        }
    }
}

