/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.dap;

import java.io.IOException;
import java.net.Socket;
import java.util.concurrent.ExecutorService;
import org.eclipse.lsp4j.debug.launch.DSPLauncher;
import org.eclipse.lsp4j.debug.services.IDebugProtocolClient;
import org.eclipse.lsp4j.jsonrpc.Launcher;
import org.rascalmpl.dap.DebugSocketServer;
import org.rascalmpl.dap.RascalDebugAdapter;
import org.rascalmpl.debug.DebugHandler;
import org.rascalmpl.ideservices.IDEServices;
import org.rascalmpl.interpreter.Evaluator;

public class RascalDebugAdapterLauncher {
    public static IDebugProtocolClient start(Evaluator evaluator, Socket clientSocket, DebugSocketServer socketServer, IDEServices services, ExecutorService threadPool) {
        try {
            DebugHandler debugHandler = new DebugHandler();
            debugHandler.setTerminateAction(() -> {
                try {
                    evaluator.removeSuspendTriggerListener(debugHandler);
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                finally {
                    socketServer.closeClientSocket();
                }
            });
            evaluator.addSuspendTriggerListener(debugHandler);
            RascalDebugAdapter server = new RascalDebugAdapter(debugHandler, evaluator, services, threadPool);
            Launcher<IDebugProtocolClient> launcher = DSPLauncher.createServerLauncher(server, clientSocket.getInputStream(), clientSocket.getOutputStream());
            server.connect(launcher.getRemoteProxy());
            launcher.startListening();
            return launcher.getRemoteProxy();
        }
        catch (IOException e) {
            services.warning("Error opening communication to DAP", RascalDebugAdapter.DEBUGGER_LOC);
            throw new RuntimeException("Error opening connection to DAP", e);
        }
    }
}

