/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.interpreter.control_exceptions;

import io.usethesource.vallang.ISourceLocation;
import org.rascalmpl.ast.AbstractAST;
import org.rascalmpl.exceptions.Throw;
import org.rascalmpl.interpreter.control_exceptions.ControlException;

public class FailedTestError
extends ControlException {
    private static final long serialVersionUID = 8282771874859604692L;
    private String trace = null;
    private ISourceLocation loc;

    public FailedTestError(AbstractAST t2) {
        super("test failed");
        this.loc = t2.getLocation();
    }

    public FailedTestError(AbstractAST t2, Throw tr) {
        super("test failed due to unexpected Rascal exception: " + tr.getMessage());
        this.loc = tr.getLocation();
    }

    public FailedTestError(AbstractAST t2, Throwable e) {
        super("test failed due to unexpected Java exception: " + e.getMessage(), e);
        this.loc = t2.getLocation();
    }

    @Override
    public String getMessage() {
        return (this.loc.getScheme().equals("file") ? this.loc.getAuthority() + this.loc.getPath() : this.loc.top()) + ":" + this.loc.getBeginLine() + "," + this.loc.getBeginColumn() + ": " + super.getMessage() + (this.trace != null ? this.trace : "");
    }
}

