/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.interpreter.env;

import io.usethesource.capsule.SetMultimap;
import io.usethesource.vallang.IList;
import io.usethesource.vallang.IString;
import io.usethesource.vallang.IValue;
import java.io.PrintWriter;
import java.net.URI;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.rascalmpl.ast.AbstractAST;
import org.rascalmpl.ast.QualifiedName;
import org.rascalmpl.exceptions.ImplementationError;
import org.rascalmpl.interpreter.env.Environment;
import org.rascalmpl.interpreter.env.ModuleEnvironment;
import org.rascalmpl.interpreter.result.AbstractFunction;
import org.rascalmpl.interpreter.result.ICallableValue;
import org.rascalmpl.interpreter.staticErrors.UndeclaredModule;
import org.rascalmpl.interpreter.utils.Names;
import org.rascalmpl.values.IRascalValueFactory;

public class GlobalEnvironment {
    private final Deque<String> loadStack = new ArrayDeque<String>();
    private final HashMap<String, ModuleEnvironment> moduleEnvironment = new HashMap();
    private final HashMap<String, URI> moduleLocations = new HashMap();
    private final HashMap<URI, String> locationModules = new HashMap();
    private final HashMap<String, ICallableValue> sourceResolvers = new HashMap();
    private boolean bootstrapper;

    public void clear() {
        this.moduleEnvironment.clear();
        this.moduleLocations.clear();
        this.locationModules.clear();
        this.sourceResolvers.clear();
    }

    public boolean pushModuleLoading(String name) {
        boolean preExists = this.loadStack.contains(name);
        this.loadStack.push(name);
        return preExists;
    }

    public String popModuleLoading() {
        return this.loadStack.pop();
    }

    public boolean onLoadingStack(String name) {
        return this.loadStack.contains(name);
    }

    public void writeLoadMessages(PrintWriter out) {
        this.moduleEnvironment.values().stream().forEach(m4 -> m4.writeLoadMessages(out));
    }

    public List<String> getLoadStack() {
        return this.loadStack.stream().collect(Collectors.toList());
    }

    public void registerSourceResolver(String scheme, ICallableValue function) {
        this.sourceResolvers.put(scheme, function);
    }

    public ModuleEnvironment addModule(ModuleEnvironment mod) {
        assert (mod != null);
        this.clearLookupChaches();
        ModuleEnvironment env = this.moduleEnvironment.get(mod.getName());
        if (env == null) {
            this.moduleEnvironment.put(mod.getName(), mod);
            return mod;
        }
        if (env == mod) {
            return mod;
        }
        throw new ImplementationError("Reinstantiating same module " + mod.getName());
    }

    public ModuleEnvironment resetModule(String name) {
        ModuleEnvironment mod = this.moduleEnvironment.get(name);
        mod.reset();
        this.clearLookupChaches();
        return mod;
    }

    public ModuleEnvironment getModule(String name) {
        return this.moduleEnvironment.get(name);
    }

    public ModuleEnvironment getModule(QualifiedName name, AbstractAST ast) {
        ModuleEnvironment module = this.getModule(Names.fullName(name));
        if (module == null) {
            throw new UndeclaredModule(Names.fullName(name), ast);
        }
        return module;
    }

    public boolean existsModule(String name) {
        return this.moduleEnvironment.containsKey(name);
    }

    public String toString() {
        StringBuffer res = new StringBuffer();
        res.append("heap.modules: ");
        for (String mod : this.moduleEnvironment.keySet()) {
            res.append(mod + ",");
        }
        return res.toString();
    }

    public void removeModule(ModuleEnvironment env) {
        String name = env.getName();
        this.moduleEnvironment.remove(name);
        for (ModuleEnvironment mod : this.moduleEnvironment.values()) {
            mod.removeModule(name);
        }
    }

    public void setModuleURI(String name, URI location) {
        this.moduleLocations.put(name, location);
        this.locationModules.put(location, name);
    }

    public URI getModuleURI(String name) {
        return this.moduleLocations.get(name);
    }

    public String getModuleForURI(URI location) {
        return this.locationModules.get(location);
    }

    public Environment getEnvironmentForName(QualifiedName name, Environment current) {
        if (Names.isQualified(name)) {
            ModuleEnvironment mod = this.getModule(Names.moduleName(name));
            if (mod == null) {
                throw new UndeclaredModule(Names.moduleName(name), name);
            }
            return mod;
        }
        return current;
    }

    public Set<String> getImportingModules(String mod) {
        HashSet<String> result = new HashSet<String>();
        for (ModuleEnvironment env : this.moduleEnvironment.values()) {
            if (!env.getImports().contains(mod)) continue;
            result.add(env.getName());
        }
        return result;
    }

    public SetMultimap.Transient<String, String> getExtendGraphFrom(String mod) {
        return this.getModule(mod).collectExtendsGraph();
    }

    public Set<String> getExtendingModules(String mod) {
        HashSet<String> result = new HashSet<String>();
        ArrayDeque<String> todo = new ArrayDeque<String>();
        todo.add(mod);
        while (!todo.isEmpty()) {
            String next = (String)todo.remove();
            for (ModuleEnvironment env : this.moduleEnvironment.values()) {
                String extending;
                if (!env.getExtends().contains(next) || todo.contains(extending = env.getName()) || result.contains(extending)) continue;
                todo.addFirst(extending);
                result.add(extending);
            }
            result.add(next);
        }
        result.remove(mod);
        return result;
    }

    public AbstractFunction getResourceImporter(String resourceScheme) {
        for (ModuleEnvironment menv : this.moduleEnvironment.values()) {
            if (!menv.hasImporterForResource(resourceScheme)) continue;
            return menv.getResourceImporter(resourceScheme);
        }
        return null;
    }

    public void isBootstrapper(boolean b) {
        this.bootstrapper = b;
    }

    public boolean isBootstrapper() {
        return this.bootstrapper;
    }

    public List<String> findCyclicExtendPathFrom(String parent, String child) {
        SetMultimap.Transient<String, String> graph = this.getExtendGraphFrom(child);
        graph.__put(parent, child);
        IRascalValueFactory vf = IRascalValueFactory.getInstance();
        return this.depthFirstCycleSearch(parent, new HashSet<String>(), vf.list(vf.string(parent)), graph).stream().map(IString.class::cast).map(IString::getValue).collect(Collectors.toList());
    }

    public IList depthFirstCycleSearch(String parent, Set<String> visited, IList path, SetMultimap.Transient<String, String> graph) {
        visited.add(parent);
        IRascalValueFactory vf = IRascalValueFactory.getInstance();
        for (String child : graph.get(parent)) {
            if (!visited.contains(child)) {
                IList result = this.depthFirstCycleSearch(child, visited, path.append(vf.string(child)), graph);
                if (result.isEmpty()) continue;
                return result;
            }
            if (!path.contains(vf.string(child))) continue;
            return path.stream().dropWhile(e -> !e.equals(vf.string(child))).collect(vf.listWriter());
        }
        return vf.list(new IValue[0]);
    }

    public List<String> nonInitializedModules() {
        return this.moduleEnvironment.entrySet().stream().filter(e -> !((ModuleEnvironment)e.getValue()).isInitialized()).map(e -> (String)e.getKey()).collect(Collectors.toList());
    }

    public void clearLookupChaches() {
        this.moduleEnvironment.values().forEach(ModuleEnvironment::clearLookupCaches);
    }
}

