/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.interpreter.matching;

import org.rascalmpl.interpreter.IEvaluatorContext;
import org.rascalmpl.interpreter.env.Environment;
import org.rascalmpl.interpreter.matching.AbstractBooleanResult;
import org.rascalmpl.interpreter.matching.IBooleanResult;

public class OrResult
extends AbstractBooleanResult {
    private final IBooleanResult left;
    private final IBooleanResult right;
    private boolean atRight;
    private Environment old;

    public OrResult(IEvaluatorContext ctx, IBooleanResult left, IBooleanResult right) {
        super(ctx);
        this.left = left;
        this.right = right;
    }

    @Override
    public void init() {
        super.init();
        this.left.init();
        this.old = this.ctx.getCurrentEnvt();
        this.ctx.pushEnv();
        this.atRight = false;
    }

    @Override
    public boolean hasNext() {
        if (this.left.hasNext()) {
            return true;
        }
        if (!this.atRight) {
            this.right.init();
            this.atRight = true;
        }
        return this.right.hasNext();
    }

    @Override
    public boolean next() {
        if (this.atRight) {
            return this.right.next();
        }
        if (this.left.next()) {
            return true;
        }
        this.ctx.unwind(this.old);
        this.right.init();
        this.atRight = true;
        return this.next();
    }
}

