/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.interpreter.result;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IList;
import io.usethesource.vallang.IListWriter;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.type.Type;
import java.util.Collections;
import java.util.Map;
import org.rascalmpl.ast.AbstractAST;
import org.rascalmpl.interpreter.IEvaluator;
import org.rascalmpl.interpreter.env.Environment;
import org.rascalmpl.interpreter.result.ConstructorFunction;
import org.rascalmpl.interpreter.result.Result;
import org.rascalmpl.interpreter.result.ResultFactory;
import org.rascalmpl.types.NonTerminalType;
import org.rascalmpl.types.RascalTypeFactory;
import org.rascalmpl.values.RascalValueFactory;
import org.rascalmpl.values.parsetrees.ITree;
import org.rascalmpl.values.parsetrees.ProductionAdapter;
import org.rascalmpl.values.parsetrees.SymbolAdapter;
import org.rascalmpl.values.parsetrees.TreeAdapter;

public class ConcreteConstructorFunction
extends ConstructorFunction {
    public ConcreteConstructorFunction(AbstractAST ast, Type constructorType, IEvaluator<Result<IValue>> eval, Environment env) {
        super(ast, eval, env, constructorType, Collections.emptyList());
    }

    @Override
    public Result<IValue> call(Type[] actualTypes, IValue[] actuals, Map<String, IValue> keyArgValues) {
        if (this.constructorType == RascalValueFactory.Tree_Appl) {
            IConstructor prod = (IConstructor)actuals[0];
            IList args = (IList)actuals[1];
            if (ProductionAdapter.isList(prod)) {
                actuals[1] = this.flatten(prod, args);
            }
        }
        IConstructor newAppl = this.getValueFactory().constructor(this.constructorType, actuals, keyArgValues);
        NonTerminalType concreteType = (NonTerminalType)RascalTypeFactory.getInstance().nonTerminalType(newAppl);
        return ResultFactory.makeResult(concreteType, newAppl, this.ctx);
    }

    private IValue flatten(IConstructor prod, IList args) {
        IListWriter result = this.vf.listWriter();
        int delta = this.getDelta(prod);
        for (int i = 0; i < args.length(); i += delta + 1) {
            ITree tree = (ITree)args.get(i);
            if (TreeAdapter.isList(tree) && TreeAdapter.isAppl(tree)) {
                if (ProductionAdapter.shouldFlatten(prod, TreeAdapter.getProduction(tree))) {
                    IList nestedArgs = TreeAdapter.getArgs(tree);
                    if (nestedArgs.length() > 0) {
                        this.appendSeparators(args, result, delta, i);
                        result.appendAll(nestedArgs);
                        continue;
                    }
                    i += delta;
                    continue;
                }
                this.appendSeparators(args, result, delta, i);
                result.append(tree);
                continue;
            }
            this.appendSeparators(args, result, delta, i);
            result.append(tree);
        }
        return result.done();
    }

    private void appendSeparators(IList args, IListWriter result, int delta, int i) {
        for (int j = i - delta; j > 0 && j < i; ++j) {
            result.append(args.get(j));
        }
    }

    private int getDelta(IConstructor prod) {
        IConstructor rhs = ProductionAdapter.getType(prod);
        if (SymbolAdapter.isIterPlusSeps(rhs) || SymbolAdapter.isIterStarSeps(rhs)) {
            return SymbolAdapter.getSeparators(rhs).length();
        }
        return 0;
    }
}

