/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.parser.gtd.util;

public class IntegerObjectList<V> {
    private static final int DEFAULT_SIZE = 8;
    private int[] keys;
    private V[] values;
    private int size;

    public IntegerObjectList() {
        this.keys = new int[8];
        this.values = new Object[8];
    }

    public IntegerObjectList(int size) {
        this.keys = new int[size];
        this.values = new Object[size];
    }

    public IntegerObjectList(IntegerObjectList<V> original) {
        int[] oldKeys = original.keys;
        V[] oldValues = original.values;
        int length = oldKeys.length;
        this.size = original.size;
        this.keys = new int[length];
        System.arraycopy(oldKeys, 0, this.keys, 0, this.size);
        this.values = new Object[length];
        System.arraycopy(oldValues, 0, this.values, 0, this.size);
    }

    public void enlarge() {
        int[] oldKeys = this.keys;
        this.keys = new int[this.size << 1];
        System.arraycopy(oldKeys, 0, this.keys, 0, this.size);
        V[] oldValues = this.values;
        this.values = new Object[this.size << 1];
        System.arraycopy(oldValues, 0, this.values, 0, this.size);
    }

    public void add(int key, V value) {
        while (this.size >= this.keys.length) {
            this.enlarge();
        }
        this.keys[this.size] = key;
        this.values[this.size++] = value;
    }

    public int getKey(int index) {
        return this.keys[index];
    }

    public V getValue(int index) {
        return this.values[index];
    }

    public int findKey(int key) {
        for (int i = this.size - 1; i >= 0; --i) {
            if (this.keys[i] != key) continue;
            return i;
        }
        return -1;
    }

    public int findKeyBefore(int key, int index) {
        for (int i = index - 1; i >= 0; --i) {
            if (this.keys[i] != key) continue;
            return i;
        }
        return -1;
    }

    public V findValue(int key) {
        for (int i = this.size - 1; i >= 0; --i) {
            if (this.keys[i] != key) continue;
            return this.values[i];
        }
        return null;
    }

    public V findValueBefore(int key, int index) {
        for (int i = index - 1; i >= 0; --i) {
            if (this.keys[i] != key) continue;
            return this.values[i];
        }
        return null;
    }

    public int size() {
        return this.size;
    }

    public void clear() {
        int length = this.keys.length;
        this.keys = new int[length];
        this.values = new Object[length];
        this.size = 0;
    }

    public void dirtyClear() {
        this.size = 0;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("[");
        for (int i = 0; i < this.size; ++i) {
            if (i > 0) {
                builder.append(",");
            }
            builder.append(this.keys[i]);
            builder.append("=");
            builder.append(this.values[i]);
        }
        builder.append("]");
        return builder.toString();
    }
}

