/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.repl.rascal;

import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IValue;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jline.terminal.Terminal;
import org.rascalmpl.dap.DebugSocketServer;
import org.rascalmpl.debug.IRascalMonitor;
import org.rascalmpl.exceptions.RascalStackOverflowError;
import org.rascalmpl.exceptions.StackTrace;
import org.rascalmpl.exceptions.Throw;
import org.rascalmpl.ideservices.BasicIDEServices;
import org.rascalmpl.ideservices.IDEServices;
import org.rascalmpl.ideservices.RemoteIDEServices;
import org.rascalmpl.interpreter.Evaluator;
import org.rascalmpl.interpreter.NullRascalMonitor;
import org.rascalmpl.interpreter.control_exceptions.InterruptException;
import org.rascalmpl.interpreter.control_exceptions.QuitException;
import org.rascalmpl.interpreter.staticErrors.StaticError;
import org.rascalmpl.interpreter.utils.ReadEvalPrintDialogMessages;
import org.rascalmpl.parser.gtd.exception.ParseError;
import org.rascalmpl.repl.StopREPLException;
import org.rascalmpl.repl.output.ICommandOutput;
import org.rascalmpl.repl.output.IOutputPrinter;
import org.rascalmpl.repl.rascal.IRascalLanguageProtocol;
import org.rascalmpl.repl.rascal.RascalValuePrinter;
import org.rascalmpl.shell.ShellEvaluatorFactory;
import org.rascalmpl.uri.ISourceLocationWatcher;
import org.rascalmpl.uri.URIResolverRegistry;
import org.rascalmpl.uri.URIUtil;
import org.rascalmpl.values.functions.IFunction;
import org.rascalmpl.values.parsetrees.ITree;

public class RascalInterpreterREPL
implements IRascalLanguageProtocol {
    protected IDEServices services;
    protected Evaluator eval;
    protected final Set<String> dirtyModules = ConcurrentHashMap.newKeySet();
    private final URIResolverRegistry reg = URIResolverRegistry.getInstance();
    private final RascalValuePrinter printer;
    private static final ISourceLocation PROMPT_LOCATION = URIUtil.rootLocation("prompt");
    protected DebugSocketServer debugServer;
    protected final int ideServicesPort;
    private final Pattern debuggingCommandPattern = Pattern.compile("^\\s*:set\\s+debugging\\s+(true|false)");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ITree parseCommand(String command) {
        Objects.requireNonNull(this.eval, "Not initialized yet");
        Evaluator evaluator = this.eval;
        synchronized (evaluator) {
            return this.eval.parseCommand(new NullRascalMonitor(), command, PROMPT_LOCATION);
        }
    }

    public RascalInterpreterREPL() {
        this(-1);
    }

    public RascalInterpreterREPL(int ideServicesPort) {
        this.ideServicesPort = ideServicesPort;
        this.printer = new RascalValuePrinter(){

            @Override
            protected Function<IValue, IValue> liftProviderFunction(IFunction func) {
                return v -> {
                    Objects.requireNonNull(RascalInterpreterREPL.this.eval, "Not initialized yet");
                    Evaluator evaluator = RascalInterpreterREPL.this.eval;
                    synchronized (evaluator) {
                        return func.call((IValue)v);
                    }
                };
            }
        };
    }

    @Override
    public ISourceLocation promptRootLocation() {
        return PROMPT_LOCATION;
    }

    protected IDEServices buildIDEService(PrintWriter err, IRascalMonitor monitor, Terminal term) {
        if (this.ideServicesPort == -1) {
            return new BasicIDEServices(err, monitor, term, URIUtil.rootLocation("cwd"));
        }
        return new RemoteIDEServices(this.ideServicesPort, err, monitor, term, URIUtil.rootLocation("cwd"));
    }

    protected Evaluator buildEvaluator(Reader input, PrintWriter stdout, PrintWriter stderr, IDEServices services) {
        Evaluator evaluator = ShellEvaluatorFactory.getDefaultEvaluator(input, stdout, stderr, services);
        this.debugServer = new DebugSocketServer(evaluator, services);
        return evaluator;
    }

    @Override
    public IDEServices initialize(Reader input, PrintWriter stdout, PrintWriter stderr, IRascalMonitor monitor, Terminal term) {
        this.services = this.buildIDEService(stderr, monitor, term);
        if (this.eval != null) {
            throw new IllegalStateException("Already initialized");
        }
        this.eval = this.buildEvaluator(input, stdout, stderr, this.services);
        this.eval.getRascalResolver().collect().stream().filter(this::isWatchable).forEach(p -> {
            try {
                this.reg.watch((ISourceLocation)p, true, d -> this.sourceLocationChanged((ISourceLocation)p, (ISourceLocationWatcher.ISourceLocationChanged)d));
            }
            catch (IOException e) {
                monitor.warning("Not watching " + p + " for changes because: " + e.getMessage(), (ISourceLocation)p);
            }
        });
        return this.services;
    }

    private boolean isWatchable(ISourceLocation loc) {
        return this.reg.isDirectory(loc) && (this.reg.hasNativelyWatchableResolver(loc) || this.reg.hasWritableResolver(loc));
    }

    private @Nullable ICommandOutput handleDebuggerCommand(String command) {
        String message;
        String icon;
        Matcher matcher = this.debuggingCommandPattern.matcher(command);
        if (!matcher.find()) {
            return null;
        }
        if (matcher.group(1).equals("true")) {
            if (!this.debugServer.isClientConnected()) {
                this.services.startDebuggingSession(this.debugServer.getPort());
                icon = "\ud83d\udc1e ";
                message = "Debugging session started.";
            } else {
                icon = "\ud83d\udd17 ";
                message = "Debugging session was already running.";
            }
        } else if (this.debugServer.isClientConnected()) {
            this.debugServer.terminateDebugSession();
            icon = "\ud83d\uded1 ";
            message = "Debugging session stopped.";
        } else {
            icon = "\u274c ";
            message = "Debugging session was not running.";
        }
        return () -> new IOutputPrinter(){

            @Override
            public void write(PrintWriter target, boolean unicodeSupported) {
                if (unicodeSupported) {
                    target.write(icon);
                }
                target.println(message);
            }

            @Override
            public String mimeType() {
                return "text/plain";
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ICommandOutput handleInput(String command) throws InterruptedException, ParseError, StopREPLException {
        ICommandOutput result = this.handleDebuggerCommand(command);
        if (result != null) {
            return result;
        }
        Objects.requireNonNull(this.eval, "Not initialized yet");
        Evaluator evaluator = this.eval;
        synchronized (evaluator) {
            try {
                HashSet<String> changes = new HashSet<String>();
                changes.addAll(this.dirtyModules);
                if (!changes.isEmpty()) {
                    this.dirtyModules.removeAll(changes);
                    this.eval.reloadModules(this.eval.getMonitor(), changes, URIUtil.rootLocation("reloader"));
                }
                return this.printer.outputResult(this.eval.eval(this.eval.getMonitor(), command, PROMPT_LOCATION));
            }
            catch (InterruptException ex) {
                return this.printer.outputError((w, sw, u) -> {
                    w.println((u ? "\u00bb\u00bb " : ">> ") + "Interrupted");
                    ex.getRascalStackTrace().prettyPrintedString(w, sw);
                });
            }
            catch (RascalStackOverflowError e) {
                return this.printer.outputError((w, sw, _u) -> ReadEvalPrintDialogMessages.throwMessage(w, e.makeThrow(), sw));
            }
            catch (StaticError e) {
                return this.printer.outputError((w, sw, _u) -> ReadEvalPrintDialogMessages.staticErrorMessage(w, e, sw));
            }
            catch (Throw e) {
                return this.printer.outputError((w, sw, _u) -> ReadEvalPrintDialogMessages.throwMessage(w, e, sw));
            }
            catch (QuitException q) {
                throw new StopREPLException();
            }
            catch (Throwable e) {
                if (e instanceof ParseError) {
                    throw e;
                }
                return this.printer.outputError((w, sw, _u) -> ReadEvalPrintDialogMessages.throwableMessage(w, e, this.eval.getStackTrace(), sw));
            }
        }
    }

    @Override
    public void cancelRunningCommandRequested() {
        Objects.requireNonNull(this.eval, "Not initialized yet");
        this.eval.interrupt();
        this.eval.endAllJobs();
    }

    public void cleanEnvironment() {
        Objects.requireNonNull(this.eval, "Not initialized yet");
        this.eval.getCurrentModuleEnvironment().reset();
    }

    @Override
    public ICommandOutput stackTraceRequested() {
        Objects.requireNonNull(this.eval, "Not initialized yet");
        StackTrace trace = this.eval.getStackTrace();
        return this.printer.prettyPrinted((w, sw, u) -> {
            w.println("Current stack trace:");
            trace.prettyPrintedString(w, sw);
            w.flush();
        });
    }

    @Override
    public List<String> lookupModules(String modulePrefix) {
        Objects.requireNonNull(this.eval, "Not initialized yet");
        return this.eval.getRascalResolver().listModuleEntries(modulePrefix);
    }

    @Override
    public Map<String, String> completePartialIdentifier(String qualifier, String partial) {
        Objects.requireNonNull(this.eval, "Not initialized yet");
        return this.eval.completePartialIdentifier(qualifier, partial);
    }

    @Override
    public Map<String, String> availableCommandLineOptions() {
        HashMap<String, String> commandLineOptions = new HashMap<String, String>();
        commandLineOptions.put("rascal.generatorProfiling".substring("rascal.".length()), "enable sampling profiler for generator");
        commandLineOptions.put("rascal.profiling".substring("rascal.".length()), "enable sampling profiler");
        commandLineOptions.put("rascal.errors".substring("rascal.".length()), "print raw java errors");
        commandLineOptions.put("rascal.tracing".substring("rascal.".length()), "trace all function calls (warning: a lot of output will be generated)");
        commandLineOptions.put("rascal.debugging".substring("rascal.".length()), "enable debugging (true/false)");
        return commandLineOptions;
    }

    @Override
    public void flush() {
        this.eval.getErrorPrinter().flush();
        this.eval.getOutPrinter().flush();
    }

    protected void sourceLocationChanged(ISourceLocation srcPath, ISourceLocationWatcher.ISourceLocationChanged d) {
        if (URIUtil.isParentOf(srcPath, d.getLocation()) && d.getLocation().getPath().endsWith(".rsc")) {
            ISourceLocation relative = URIUtil.relativize(srcPath, d.getLocation());
            String modName = (relative = URIUtil.removeExtension(relative)).getPath();
            if (modName.startsWith("/")) {
                modName = modName.substring(1);
            }
            modName = modName.replace("/", "::");
            modName = modName.replace("\\", "::");
            this.dirtyModules.add(modName);
        }
    }
}

