/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.runtime.traverse;

import io.usethesource.vallang.IBool;
import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.type.Type;
import java.util.HashSet;
import org.rascalmpl.runtime.traverse.IDescendantDescriptor;
import org.rascalmpl.values.parsetrees.ITree;

public class DescendantDescriptor
implements IDescendantDescriptor {
    private final HashSet<Object> mSymbolSet;
    private final boolean concreteMatch;
    final boolean debug = false;

    public DescendantDescriptor(Type[] symbolset, IConstructor[] prodset, IBool concreteMatch) {
        this.mSymbolSet = new HashSet(symbolset.length + prodset.length);
        this.concreteMatch = concreteMatch.getValue();
        for (Type type : symbolset) {
            this.mSymbolSet.add(type);
        }
        for (Iterable<Type> iterable : prodset) {
            this.mSymbolSet.add(iterable);
        }
    }

    @Override
    public boolean isConcreteMatch() {
        return this.concreteMatch;
    }

    @Override
    public boolean isAllwaysTrue() {
        return false;
    }

    @Override
    public IBool shouldDescentInAbstractValue(IValue subject) {
        Type type = subject instanceof IConstructor ? ((IConstructor)subject).getConstructorType().getAbstractDataType() : subject.getType();
        IBool res = this.mSymbolSet.contains(type) ? TRUE : FALSE;
        return res;
    }

    @Override
    public IBool shouldDescentInConcreteValue(ITree subject) {
        if (subject.isAppl()) {
            IConstructor prod = subject.getProduction();
            IBool res = this.mSymbolSet.contains(prod) ? TRUE : FALSE;
            return res;
        }
        if (subject.isAmb()) {
            return TRUE;
        }
        return FALSE;
    }
}

