/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.test.infrastructure;

import io.usethesource.vallang.ISourceLocation;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.Runner;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.rascalmpl.interpreter.Evaluator;
import org.rascalmpl.interpreter.ITestResultListener;
import org.rascalmpl.interpreter.TestEvaluator;
import org.rascalmpl.interpreter.env.ModuleEnvironment;
import org.rascalmpl.interpreter.result.AbstractFunction;
import org.rascalmpl.interpreter.utils.RascalManifest;
import org.rascalmpl.shell.ShellEvaluatorFactory;
import org.rascalmpl.test.infrastructure.CompilationFailed;
import org.rascalmpl.test.infrastructure.RascalJUnitTestRunner;
import org.rascalmpl.test.infrastructure.RascalJunitConsoleMonitor;
import org.rascalmpl.test.infrastructure.RecursiveRascalParallelTest;
import org.rascalmpl.uri.URIUtil;

public class RascalJUnitParallelRecursiveTestRunner
extends Runner {
    private final int numberOfWorkers;
    private final Semaphore importsCompleted = new Semaphore(0);
    private final Semaphore waitForRunning = new Semaphore(0);
    private final Semaphore workersCompleted = new Semaphore(0);
    private final String[] prefixes;
    private final Queue<String> modules = new ConcurrentLinkedQueue<String>();
    private final Queue<Description> descriptions = new ConcurrentLinkedQueue<Description>();
    private final Queue<Consumer<RunNotifier>> results = new ConcurrentLinkedQueue<Consumer<RunNotifier>>();
    private Description rootDesc;
    private final ISourceLocation projectRoot;
    private static final String JUNIT_TEST = "___junit_test___";

    public RascalJUnitParallelRecursiveTestRunner(Class<?> clazz) {
        System.err.println("Rascal JUnit uses Rascal version " + RascalManifest.getRascalVersionNumber());
        this.projectRoot = RascalJUnitTestRunner.inferProjectRootFromClass(clazz);
        System.err.println("Rascal JUnit Project root: " + this.projectRoot);
        int numberOfWorkers = Math.min(4, Runtime.getRuntime().availableProcessors() - 1);
        System.out.println("Number of workers based on CPU: " + numberOfWorkers);
        if (numberOfWorkers > 1) {
            numberOfWorkers = Math.min(numberOfWorkers, (int)(Runtime.getRuntime().maxMemory() / 314572800L));
            System.out.println("Number of workers based on memory: " + numberOfWorkers + " (" + Runtime.getRuntime().maxMemory() / 0x100000L + ")");
        }
        this.numberOfWorkers = numberOfWorkers < 1 ? 1 : numberOfWorkers;
        System.out.println("Running parallel test with " + this.numberOfWorkers + " runners");
        System.out.flush();
        this.prefixes = clazz.getAnnotation(RecursiveRascalParallelTest.class).value();
    }

    @Override
    public Description getDescription() {
        if (this.rootDesc == null) {
            this.fillModuleWorkList();
            this.startModuleTesters();
            this.rootDesc = Description.createSuiteDescription(this.projectRoot.toString(), new Annotation[0]);
            this.processIncomingModuleDescriptions(this.rootDesc);
            assert (this.descriptions.isEmpty());
        }
        return this.rootDesc;
    }

    @Override
    public void run(RunNotifier notifier) {
        assert (this.rootDesc != null);
        notifier.fireTestRunStarted(this.rootDesc);
        this.runTests(notifier);
        notifier.fireTestRunFinished(new Result());
    }

    private void processIncomingModuleDescriptions(Description rootDesc) {
        int completed = 0;
        while (completed < this.numberOfWorkers) {
            Description newDescription;
            try {
                if (this.importsCompleted.tryAcquire(10L, TimeUnit.MILLISECONDS)) {
                    ++completed;
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            while ((newDescription = this.descriptions.poll()) != null) {
                rootDesc.addChild(newDescription);
            }
        }
    }

    private void startModuleTesters() {
        for (int i = 0; i < this.numberOfWorkers; ++i) {
            new ModuleTester("JUnit Rascal Evaluator " + (i + 1)).start();
        }
    }

    private void fillModuleWorkList() {
        for (String prefix : this.prefixes) {
            try {
                ArrayList<String> result = new ArrayList<String>();
                for (String src : new RascalManifest().getSourceRoots(this.projectRoot)) {
                    RascalJUnitTestRunner.getRecursiveModuleList(URIUtil.getChildLocation(this.projectRoot, src + "/" + prefix.replaceAll("::", "/")), result);
                }
                result.stream().map(m4 -> prefix + "::" + m4).forEach(n -> this.modules.add((String)n));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTests(RunNotifier notifier) {
        try {
            this.waitForRunning.release(this.numberOfWorkers);
            int completed = 0;
            while (completed < this.numberOfWorkers) {
                Consumer<RunNotifier> newResult;
                try {
                    if (this.workersCompleted.tryAcquire(10L, TimeUnit.MILLISECONDS)) {
                        ++completed;
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                while ((newResult = this.results.poll()) != null) {
                    newResult.accept(notifier);
                }
            }
            assert (this.results.isEmpty());
        }
        finally {
            RascalJunitConsoleMonitor.getInstance().endAllJobs();
        }
    }

    public class Listener
    implements ITestResultListener {
        private final PrintWriter stderr;
        private final Description module;

        public Listener(Description module, PrintWriter stderr) {
            this.module = module;
            this.stderr = stderr;
        }

        private Description getDescription(String name, ISourceLocation loc) {
            String testName = RascalJUnitTestRunner.computeTestName(name, loc);
            for (Description child : this.module.getChildren()) {
                if (!child.getMethodName().equals(testName)) continue;
                return child;
            }
            throw new IllegalArgumentException(name + " test was never registered");
        }

        @Override
        public void start(String context, int count) {
        }

        @Override
        public void done() {
        }

        @Override
        public void report(boolean successful, String test, ISourceLocation loc, String message, Throwable exception) {
            Description desc = this.getDescription(test, loc);
            RascalJUnitParallelRecursiveTestRunner.this.results.add(notifier -> {
                notifier.fireTestStarted(desc);
                if (!successful) {
                    if (exception != null) {
                        PrintWriter printWriter = this.stderr;
                        synchronized (printWriter) {
                            exception.printStackTrace(this.stderr);
                        }
                    }
                    notifier.fireTestFailure(new Failure(desc, exception != null ? exception : new Exception(message != null ? message : "no message")));
                } else {
                    notifier.fireTestFinished(desc);
                }
            });
        }

        @Override
        public void ignored(String test, ISourceLocation loc) {
            Description desc = this.getDescription(test, loc);
            RascalJUnitParallelRecursiveTestRunner.this.results.add(notifier -> notifier.fireTestIgnored(desc));
        }
    }

    public class ModuleTester
    extends Thread {
        private PrintWriter stderr;
        private PrintWriter stdout;
        private Evaluator evaluator;
        private final List<Description> testModules;

        public ModuleTester(String name) {
            super(name);
            this.testModules = new ArrayList<Description>();
        }

        @Override
        public void run() {
            this.initializeEvaluator();
            this.processModules();
            this.runTests();
        }

        private void runTests() {
            try {
                if (this.waitForRunSignal()) {
                    this.evaluator.job("Testing modules", this.testModules.size(), jn -> {
                        for (Description mod : this.testModules) {
                            this.evaluator.jobStep((String)jn, mod.getDisplayName(), 1);
                            Listener trl = new Listener(mod, this.stdout);
                            if (mod.getAnnotations().stream().anyMatch(t2 -> t2 instanceof CompilationFailed)) {
                                RascalJUnitParallelRecursiveTestRunner.this.results.add(notifier -> {
                                    notifier.fireTestStarted(mod);
                                    notifier.fireTestFailure(new Failure(mod, new IllegalArgumentException(mod.getDisplayName() + " had import/compilation errors")));
                                });
                                continue;
                            }
                            TestEvaluator runner = new TestEvaluator(this.evaluator, trl);
                            runner.test(mod.getDisplayName());
                            this.stdout.flush();
                            this.stderr.flush();
                        }
                        return true;
                    });
                }
            }
            finally {
                RascalJUnitParallelRecursiveTestRunner.this.workersCompleted.release();
            }
        }

        private boolean waitForRunSignal() {
            try {
                RascalJUnitParallelRecursiveTestRunner.this.waitForRunning.acquire();
                return true;
            }
            catch (InterruptedException e) {
                return false;
            }
        }

        private void processModules() {
            this.evaluator.job("loading modules", 0, jn -> {
                try {
                    String module;
                    while ((module = RascalJUnitParallelRecursiveTestRunner.this.modules.poll()) != null) {
                        this.evaluator.jobTodo((String)jn, 1);
                        try {
                            this.evaluator.jobStep((String)jn, module);
                            this.evaluator.doNextImport((String)jn, module);
                        }
                        catch (Throwable e) {
                            PrintWriter printWriter = this.stdout;
                            synchronized (printWriter) {
                                this.evaluator.warning("Could not import " + module + " for testing...", null);
                                this.evaluator.warning(e.getMessage(), null);
                                e.printStackTrace(this.evaluator.getOutPrinter());
                            }
                            Description testDesc = Description.createTestDescription(this.getClass(), module, new CompilationFailed(){

                                @Override
                                public Class<? extends Annotation> annotationType() {
                                    return this.getClass();
                                }
                            });
                            this.testModules.add(testDesc);
                            RascalJUnitParallelRecursiveTestRunner.this.descriptions.add(testDesc);
                            continue;
                        }
                        ModuleEnvironment moduleEnv = this.evaluator.getHeap().getModule(module.replaceAll("\\\\", ""));
                        if (moduleEnv.getTests().isEmpty()) continue;
                        Description modDesc = Description.createSuiteDescription(module, new Annotation[0]);
                        for (AbstractFunction f : moduleEnv.getTests()) {
                            modDesc.addChild(Description.createTestDescription(this.getClass(), RascalJUnitTestRunner.computeTestName(f.getName(), f.getAst().getLocation())));
                        }
                        RascalJUnitParallelRecursiveTestRunner.this.descriptions.add(modDesc);
                        this.testModules.add(modDesc);
                    }
                    Collections.shuffle(this.testModules);
                }
                finally {
                    RascalJUnitParallelRecursiveTestRunner.this.importsCompleted.release();
                }
                return true;
            });
        }

        private void initializeEvaluator() {
            this.evaluator = RascalJUnitParallelRecursiveTestRunner.this.projectRoot != null ? ShellEvaluatorFactory.getDefaultEvaluatorForLocation(RascalJUnitParallelRecursiveTestRunner.this.projectRoot, Reader.nullReader(), new PrintWriter(System.err, true), new PrintWriter(System.out, true), RascalJunitConsoleMonitor.getInstance(), RascalJUnitParallelRecursiveTestRunner.JUNIT_TEST) : ShellEvaluatorFactory.getBasicEvaluator(Reader.nullReader(), new PrintWriter(System.err, true), new PrintWriter(System.out, true), RascalJunitConsoleMonitor.getInstance(), RascalJUnitParallelRecursiveTestRunner.JUNIT_TEST);
            this.stdout = this.evaluator.getOutPrinter();
            this.stderr = this.evaluator.getErrorPrinter();
            this.evaluator.getConfiguration().setErrors(true);
        }
    }
}

