/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.uri;

import io.usethesource.vallang.ISourceLocation;

public class SourceLocationURICompare {
    private static final URIIterator SCHEME = new URIIterator(){

        @Override
        public URIIterator next(ISourceLocation loc) {
            return SCHEME_SEP;
        }

        @Override
        public String current(ISourceLocation loc) {
            return loc.getScheme();
        }
    };
    private static final URIIterator SCHEME_SEP = new URIIterator(){

        @Override
        public URIIterator next(ISourceLocation loc) {
            return loc.hasAuthority() ? AUTHORITY : AUTHORITY_SEP;
        }

        @Override
        public String current(ISourceLocation loc) {
            return "://";
        }
    };
    private static final URIIterator AUTHORITY = new URIIterator(){

        @Override
        public URIIterator next(ISourceLocation loc) {
            return AUTHORITY_SEP;
        }

        @Override
        public String current(ISourceLocation loc) {
            return loc.getAuthority();
        }
    };
    private static final URIIterator AUTHORITY_SEP = new URIIterator(){

        @Override
        public URIIterator next(ISourceLocation loc) {
            return loc.hasPath() ? PATH : (loc.hasQuery() ? QUERY_PRE : (loc.hasFragment() ? FRAGMENT_PRE : null));
        }

        @Override
        public String current(ISourceLocation loc) {
            return "/";
        }
    };
    private static final URIIterator PATH = new URIIterator(){

        @Override
        public URIIterator next(ISourceLocation loc) {
            return loc.hasQuery() ? QUERY_PRE : (loc.hasFragment() ? FRAGMENT_PRE : null);
        }

        @Override
        public String current(ISourceLocation loc) {
            return loc.getPath();
        }
    };
    private static final URIIterator QUERY_PRE = new URIIterator(){

        @Override
        public URIIterator next(ISourceLocation loc) {
            return QUERY;
        }

        @Override
        public String current(ISourceLocation loc) {
            return "?";
        }
    };
    private static final URIIterator QUERY = new URIIterator(){

        @Override
        public URIIterator next(ISourceLocation loc) {
            return loc.hasFragment() ? FRAGMENT_PRE : null;
        }

        @Override
        public String current(ISourceLocation loc) {
            return loc.getQuery();
        }
    };
    private static final URIIterator FRAGMENT_PRE = new URIIterator(){

        @Override
        public URIIterator next(ISourceLocation loc) {
            return FRAGMENT;
        }

        @Override
        public String current(ISourceLocation loc) {
            return "#";
        }
    };
    private static final URIIterator FRAGMENT = new URIIterator(){

        @Override
        public URIIterator next(ISourceLocation loc) {
            return null;
        }

        @Override
        public String current(ISourceLocation loc) {
            return loc.getFragment();
        }
    };

    public static int compare(ISourceLocation a, ISourceLocation b) {
        URIIterator right;
        URIIterator left = SCHEME;
        for (right = SCHEME; left != null && right != null; left = left.next(a), right = right.next(b)) {
            int result;
            String rightChunk;
            String leftChunk = left.current(a);
            if (leftChunk == (rightChunk = right.current(b)) || (result = leftChunk.compareTo(rightChunk)) == 0) continue;
            return result;
        }
        if (left == null && right == null) {
            return 0;
        }
        if (right != null) {
            return -1;
        }
        return 1;
    }

    private static interface URIIterator {
        public String current(ISourceLocation var1);

        public URIIterator next(ISourceLocation var1);
    }
}

