/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.uri.zip;

import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IValueFactory;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import org.rascalmpl.uri.FileAttributes;
import org.rascalmpl.uri.ISourceLocationInput;
import org.rascalmpl.uri.URIResolverRegistry;
import org.rascalmpl.uri.classloaders.IClassloaderLocationResolver;
import org.rascalmpl.uri.zip.ZipFileResolver;
import org.rascalmpl.uri.zip.ZipInputStreamResolver;
import org.rascalmpl.values.ValueFactoryFactory;

public class ZipURIResolver
implements ISourceLocationInput,
IClassloaderLocationResolver {
    private static final IValueFactory VF = ValueFactoryFactory.getValueFactory();
    private final ZipFileResolver file = new ZipFileResolver();
    private final ZipFileResolver inputStream;
    private final URIResolverRegistry registry;

    public ZipURIResolver(URIResolverRegistry registry) {
        this.registry = registry;
        this.inputStream = new ZipInputStreamResolver(registry);
    }

    @Override
    public String scheme() {
        return "zip";
    }

    private ZipFileResolver getTargetResolver(ISourceLocation uri) {
        if (uri.getScheme().equals("file")) {
            return this.file;
        }
        return this.inputStream;
    }

    private ISourceLocation safeResolve(ISourceLocation loc) {
        try {
            return this.registry.logicalToPhysical(loc);
        }
        catch (Throwable e) {
            return loc;
        }
    }

    private static String getInsideZipPath(ISourceLocation uri) {
        int bang;
        String path = uri.getPath();
        if (path != null && !path.isEmpty() && (bang = path.lastIndexOf(33)) != -1) {
            path = path.substring(bang + 1);
            while (path.startsWith("/")) {
                path = path.substring(1);
            }
            return path;
        }
        return "";
    }

    private ISourceLocation getResolvedZipPath(ISourceLocation uri) throws IOException {
        boolean isWrapped = uri.getScheme().startsWith("zip+");
        try {
            int bang;
            String path = uri.getPath();
            if (path != null && !path.isEmpty() && (bang = path.lastIndexOf(33)) != -1) {
                return this.safeResolve(VF.sourceLocation(isWrapped ? uri.getScheme().substring("zip+".length()) : "file", isWrapped ? uri.getAuthority() : "", path.substring(path.indexOf("/"), bang)));
            }
            throw new IOException("The zip-file and the internal path should be separated with a ! (" + uri.getPath() + ")");
        }
        catch (UnsupportedOperationException | URISyntaxException e) {
            throw new IOException("Invalid URI: \"" + uri + "\"", e);
        }
    }

    @Override
    public InputStream getInputStream(ISourceLocation uri) throws IOException {
        ISourceLocation zipUri = this.getResolvedZipPath(uri);
        return this.getTargetResolver(zipUri).getInputStream(zipUri, ZipURIResolver.getInsideZipPath(uri));
    }

    @Override
    public boolean isDirectory(ISourceLocation uri) {
        if (uri.getPath() != null && (uri.getPath().endsWith("!") || uri.getPath().endsWith("!/"))) {
            return true;
        }
        try {
            ISourceLocation zipUri = this.getResolvedZipPath(uri);
            return this.getTargetResolver(zipUri).isDirectory(zipUri, ZipURIResolver.getInsideZipPath(uri));
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public boolean exists(ISourceLocation uri) {
        try {
            ISourceLocation zipUri = this.getResolvedZipPath(uri);
            return this.getTargetResolver(zipUri).exists(zipUri, ZipURIResolver.getInsideZipPath(uri));
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public boolean isFile(ISourceLocation uri) {
        try {
            ISourceLocation zipUri = this.getResolvedZipPath(uri);
            return this.getTargetResolver(zipUri).isFile(zipUri, ZipURIResolver.getInsideZipPath(uri));
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public Charset getCharset(ISourceLocation uri) throws IOException {
        return null;
    }

    @Override
    public long lastModified(ISourceLocation uri) throws IOException {
        ISourceLocation zipUri = this.getResolvedZipPath(uri);
        return this.getTargetResolver(zipUri).lastModified(zipUri, ZipURIResolver.getInsideZipPath(uri));
    }

    @Override
    public long created(ISourceLocation uri) throws IOException {
        ISourceLocation zipUri = this.getResolvedZipPath(uri);
        return this.getTargetResolver(zipUri).created(zipUri, ZipURIResolver.getInsideZipPath(uri));
    }

    @Override
    public String[] list(ISourceLocation uri) throws IOException {
        ISourceLocation zipUri = this.getResolvedZipPath(uri);
        return this.getTargetResolver(zipUri).list(zipUri, ZipURIResolver.getInsideZipPath(uri));
    }

    @Override
    public boolean supportsHost() {
        return true;
    }

    @Override
    public ClassLoader getClassLoader(ISourceLocation loc, ClassLoader parent) throws IOException {
        return this.registry.getClassLoader(this.getResolvedZipPath(loc), parent);
    }

    @Override
    public FileAttributes stat(ISourceLocation uri) throws IOException {
        ISourceLocation zipUri = this.getResolvedZipPath(uri);
        return this.getTargetResolver(zipUri).stat(zipUri, ZipURIResolver.getInsideZipPath(uri));
    }

    @Override
    public long size(ISourceLocation uri) throws IOException {
        ISourceLocation zipUri = this.getResolvedZipPath(uri);
        return this.getTargetResolver(zipUri).size(zipUri, ZipURIResolver.getInsideZipPath(uri));
    }

    @Override
    public boolean isReadable(ISourceLocation uri) throws IOException {
        if (this.isFile(uri)) {
            return true;
        }
        throw new FileNotFoundException(uri.toString());
    }
}

