---
title: "module Prelude"
id: Prelude
slug: /Library//Prelude
---

<div class="theme-doc-version-badge badge badge--secondary">rascal-Not specified</div>

All basic utility functions in one handy module to import
#### Usage

```rascal
import Prelude;
```

#### Dependencies
```rascal
extend Boolean;
extend DateTime;
extend Exception;
extend Grammar;
extend IO;
extend List;
extend ListRelation;
extend Map;
extend Node;
extend ParseTree;
extend Relation;
extend Set;
extend String;
extend Type;
extend ValueIO;
```

#### Description


Unlike the module name suggests the Prelude module is _not_ automatically imported when Rascal is started.
All it is, is a handy combination of extended modules that will provide the utility functions most
Rascal programmers need.

Prelude combines the following modules:

*  [Boolean](..//Library/Boolean.md)
*  [Date Time](..//Library/DateTime.md)
*  [Exception](..//Library/Exception.md)
*  [IO](..//Library/IO.md)
*  [List](..//Library/List.md)
*  [Map](..//Library/Map.md)
*  [Node](..//Library/Node.md)
*  [Parse Tree](..//Library/ParseTree.md)
*  [Relation](..//Library/Relation.md)
*  [Set](..//Library/Set.md)
*  [String](..//Library/String.md)
*  [Value IO](..//Library/ValueIO.md)

#### Examples



```rascal-shell 
rascal>import Prelude;
ok
rascal>println("Hello World"); // from IO
Hello World
ok
rascal>size([1,2,3])           // from List
int: 3
rascal>size({1,2,1})           // from Set
int: 2
```

#### Benefits


* Prelude makes all the feature of the extended modules transitively available to an importing module.

#### Pitfalls


* Prelude combines many many function names and so the namespace of modules that import it is a bit crowded.


